/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FlowingFluid
extends Fluid {
    public static final BooleanProperty f_75947_ = BlockStateProperties.f_61434_;
    public static final IntegerProperty f_75948_ = BlockStateProperties.f_61420_;
    private static final int f_164507_ = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> f_75949_ = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2ByteLinkedOpenHashMap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(200){

            protected void rehash(int p_76102_) {
            }
        };
        object2ByteLinkedOpenHashMap.defaultReturnValue((byte)127);
        return object2ByteLinkedOpenHashMap;
    });
    private final Map<FluidState, VoxelShape> f_75950_ = Maps.newIdentityHashMap();

    @Override
    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> p_76046_) {
        p_76046_.m_61104_(f_75947_);
    }

    @Override
    public Vec3 m_7000_(BlockGetter p_75987_, BlockPos p_75988_, FluidState p_75989_) {
        double d = 0.0;
        \u00e2\u02dc\u0192 = 0.0;
        BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            \u00e2\u02dc\u01922.m_122159_(p_75988_, direction);
            Object object = p_75987_.m_6425_(\u00e2\u02dc\u01922);
            if (!this.m_76094_((FluidState)object)) continue;
            float \u00e2\u02dc\u01923 = ((FluidState)object).m_76182_();
            float \u00e2\u02dc\u01924 = 0.0f;
            if (\u00e2\u02dc\u01923 == 0.0f) {
                if (!p_75987_.m_8055_(\u00e2\u02dc\u01922).m_60767_().m_76334_() && this.m_76094_(\u00e2\u02dc\u0192 = p_75987_.m_6425_((BlockPos)(\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_7495_()))) && (\u00e2\u02dc\u01923 = \u00e2\u02dc\u0192.m_76182_()) > 0.0f) {
                    \u00e2\u02dc\u01924 = p_75989_.m_76182_() - (\u00e2\u02dc\u01923 - 0.8888889f);
                }
            } else if (\u00e2\u02dc\u01923 > 0.0f) {
                \u00e2\u02dc\u01924 = p_75989_.m_76182_() - \u00e2\u02dc\u01923;
            }
            if (\u00e2\u02dc\u01924 == 0.0f) continue;
            d += (double)((float)direction.m_122429_() * \u00e2\u02dc\u01924);
            \u00e2\u02dc\u0192 += (double)((float)direction.m_122431_() * \u00e2\u02dc\u01924);
        }
        Vec3 vec3 = new Vec3(d, 0.0, \u00e2\u02dc\u0192);
        if (p_75989_.m_61143_(f_75947_).booleanValue()) {
            for (Object object : Direction.Plane.HORIZONTAL) {
                \u00e2\u02dc\u01922.m_122159_(p_75988_, (Direction)object);
                if (!this.m_75990_(p_75987_, \u00e2\u02dc\u01922, (Direction)object) && !this.m_75990_(p_75987_, (BlockPos)\u00e2\u02dc\u01922.m_7494_(), (Direction)object)) continue;
                vec3 = vec3.m_82541_().m_82520_(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.m_82541_();
    }

    private boolean m_76094_(FluidState p_76095_) {
        return p_76095_.m_76178_() || p_76095_.m_76152_().m_6212_(this);
    }

    protected boolean m_75990_(BlockGetter p_75991_, BlockPos p_75992_, Direction p_75993_) {
        BlockState blockState = p_75991_.m_8055_(p_75992_);
        FluidState \u00e2\u02dc\u01922 = p_75991_.m_6425_(p_75992_);
        if (\u00e2\u02dc\u01922.m_76152_().m_6212_(this)) {
            return false;
        }
        if (p_75993_ == Direction.UP) {
            return true;
        }
        if (blockState.m_60767_() == Material.f_76276_) {
            return false;
        }
        return blockState.m_60783_(p_75991_, p_75992_, p_75993_);
    }

    protected void m_76010_(LevelAccessor p_76011_, BlockPos p_76012_, FluidState p_76013_) {
        if (p_76013_.m_76178_()) {
            return;
        }
        BlockState blockState = p_76011_.m_8055_(p_76012_);
        BlockPos \u00e2\u02dc\u01922 = p_76012_.m_7495_();
        \u00e2\u02dc\u0192 = p_76011_.m_8055_(\u00e2\u02dc\u01922);
        FluidState \u00e2\u02dc\u01923 = this.m_76035_(p_76011_, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192);
        if (this.m_75977_(p_76011_, p_76012_, blockState, Direction.DOWN, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192, p_76011_.m_6425_(\u00e2\u02dc\u01922), \u00e2\u02dc\u01923.m_76152_())) {
            this.m_6364_(p_76011_, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192, Direction.DOWN, \u00e2\u02dc\u01923);
            if (this.m_76019_(p_76011_, p_76012_) >= 3) {
                this.m_76014_(p_76011_, p_76012_, p_76013_, blockState);
            }
        } else if (p_76013_.m_76170_() || !this.m_75956_(p_76011_, \u00e2\u02dc\u01923.m_76152_(), p_76012_, blockState, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192)) {
            this.m_76014_(p_76011_, p_76012_, p_76013_, blockState);
        }
    }

    private void m_76014_(LevelAccessor p_76015_, BlockPos p_76016_, FluidState p_76017_, BlockState p_76018_) {
        int n = p_76017_.m_76186_() - this.m_6713_(p_76015_);
        if (p_76017_.m_61143_(f_75947_).booleanValue()) {
            n = 7;
        }
        if (n <= 0) {
            return;
        }
        Map<Direction, FluidState> \u00e2\u02dc\u01922 = this.m_76079_(p_76015_, p_76016_, p_76018_);
        for (Map.Entry<Direction, FluidState> entry : \u00e2\u02dc\u01922.entrySet()) {
            Direction direction = entry.getKey();
            FluidState \u00e2\u02dc\u01923 = entry.getValue();
            BlockPos \u00e2\u02dc\u01924 = p_76016_.m_142300_(direction);
            if (!this.m_75977_(p_76015_, p_76016_, p_76018_, direction, \u00e2\u02dc\u01924, \u00e2\u02dc\u0192 = p_76015_.m_8055_(\u00e2\u02dc\u01924), p_76015_.m_6425_(\u00e2\u02dc\u01924), \u00e2\u02dc\u01923.m_76152_())) continue;
            this.m_6364_(p_76015_, \u00e2\u02dc\u01924, \u00e2\u02dc\u0192, direction, \u00e2\u02dc\u01923);
        }
    }

    protected FluidState m_76035_(LevelReader p_76036_, BlockPos p_76037_, BlockState p_76038_) {
        Object object;
        int n;
        int \u00e2\u02dc\u01923 = 0;
        n = 0;
        for (Object object2 : Direction.Plane.HORIZONTAL) {
            object = p_76037_.m_142300_((Direction)object2);
            BlockState blockState = p_76036_.m_8055_((BlockPos)object);
            FluidState \u00e2\u02dc\u01922 = blockState.m_60819_();
            if (!\u00e2\u02dc\u01922.m_76152_().m_6212_(this) || !this.m_76061_((Direction)object2, p_76036_, p_76037_, p_76038_, (BlockPos)object, blockState)) continue;
            if (\u00e2\u02dc\u01922.m_76170_()) {
                ++n;
            }
            \u00e2\u02dc\u01923 = Math.max(\u00e2\u02dc\u01923, \u00e2\u02dc\u01922.m_76186_());
        }
        if (this.m_6760_() && n >= 2) {
            Object object3 = p_76036_.m_8055_(p_76037_.m_7495_());
            object2 = ((BlockBehaviour.BlockStateBase)object3).m_60819_();
            if (((BlockBehaviour.BlockStateBase)object3).m_60767_().m_76333_() || this.m_76096_((FluidState)object2)) {
                return this.m_76068_(false);
            }
        }
        if (!((FluidState)(object = ((BlockBehaviour.BlockStateBase)(object2 = p_76036_.m_8055_((BlockPos)(object3 = p_76037_.m_7494_())))).m_60819_())).m_76178_() && ((FluidState)object).m_76152_().m_6212_(this) && this.m_76061_(Direction.UP, p_76036_, p_76037_, p_76038_, (BlockPos)object3, (BlockState)object2)) {
            return this.m_75953_(8, true);
        }
        int n2 = \u00e2\u02dc\u01923 - this.m_6713_(p_76036_);
        if (n2 <= 0) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.m_75953_(n2, false);
    }

    private boolean m_76061_(Direction p_76062_, BlockGetter p_76063_, BlockPos p_76064_, BlockState p_76065_, BlockPos p_76066_, BlockState p_76067_) {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2ByteLinkedOpenHashMap = p_76065_.m_60734_().m_49967_() || p_76067_.m_60734_().m_49967_() ? null : f_75949_.get();
        if (object2ByteLinkedOpenHashMap != null) {
            Block.BlockStatePairKey blockStatePairKey = new Block.BlockStatePairKey(p_76065_, p_76067_, p_76062_);
            byte \u00e2\u02dc\u01922 = object2ByteLinkedOpenHashMap.getAndMoveToFirst((Object)blockStatePairKey);
            if (\u00e2\u02dc\u01922 != 127) {
                return \u00e2\u02dc\u01922 != 0;
            }
        } else {
            blockStatePairKey = null;
        }
        boolean bl = \u00e2\u02dc\u0192 = !Shapes.m_83152_(\u00e2\u02dc\u0192 = p_76065_.m_60812_(p_76063_, p_76064_), \u00e2\u02dc\u0192 = p_76067_.m_60812_(p_76063_, p_76066_), p_76062_);
        if (object2ByteLinkedOpenHashMap != null) {
            if (object2ByteLinkedOpenHashMap.size() == 200) {
                object2ByteLinkedOpenHashMap.removeLastByte();
            }
            object2ByteLinkedOpenHashMap.putAndMoveToFirst((Object)blockStatePairKey, (byte)(\u00e2\u02dc\u0192 ? 1 : 0));
        }
        return \u00e2\u02dc\u0192;
    }

    public abstract Fluid m_5615_();

    public FluidState m_75953_(int p_75954_, boolean p_75955_) {
        return (FluidState)((FluidState)this.m_5615_().m_76145_().m_61124_(f_75948_, p_75954_)).m_61124_(f_75947_, p_75955_);
    }

    public abstract Fluid m_5613_();

    public FluidState m_76068_(boolean p_76069_) {
        return (FluidState)this.m_5613_().m_76145_().m_61124_(f_75947_, p_76069_);
    }

    protected abstract boolean m_6760_();

    protected void m_6364_(LevelAccessor p_76005_, BlockPos p_76006_, BlockState p_76007_, Direction p_76008_, FluidState p_76009_) {
        if (p_76007_.m_60734_() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)((Object)p_76007_.m_60734_())).m_7361_(p_76005_, p_76006_, p_76007_, p_76009_);
        } else {
            if (!p_76007_.m_60795_()) {
                this.m_7456_(p_76005_, p_76006_, p_76007_);
            }
            p_76005_.m_7731_(p_76006_, p_76009_.m_76188_(), 3);
        }
    }

    protected abstract void m_7456_(LevelAccessor var1, BlockPos var2, BlockState var3);

    private static short m_76058_(BlockPos p_76059_, BlockPos p_76060_) {
        int n = p_76060_.m_123341_() - p_76059_.m_123341_();
        \u00e2\u02dc\u0192 = p_76060_.m_123343_() - p_76059_.m_123343_();
        return (short)((n + 128 & 0xFF) << 8 | \u00e2\u02dc\u0192 + 128 & 0xFF);
    }

    protected int m_76026_(LevelReader p_76027_, BlockPos p_76028_, int p_76029_, Direction p_76030_, BlockState p_76031_, BlockPos p_76032_, Short2ObjectMap<Pair<BlockState, FluidState>> p_76033_, Short2BooleanMap p_76034_) {
        int \u00e2\u02dc\u01927 = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == p_76030_) continue;
            BlockPos blockPos = p_76028_.m_142300_(direction);
            short \u00e2\u02dc\u01922 = FlowingFluid.m_76058_(p_76032_, blockPos);
            Pair \u00e2\u02dc\u01923 = (Pair)p_76033_.computeIfAbsent(\u00e2\u02dc\u01922, p_76078_ -> {
                BlockState blockState = p_76027_.m_8055_(blockPos);
                return Pair.of((Object)blockState, (Object)blockState.m_60819_());
            });
            BlockState \u00e2\u02dc\u01924 = (BlockState)\u00e2\u02dc\u01923.getFirst();
            FluidState \u00e2\u02dc\u01925 = (FluidState)\u00e2\u02dc\u01923.getSecond();
            if (!this.m_75963_(p_76027_, this.m_5615_(), p_76028_, p_76031_, direction, blockPos, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925)) continue;
            boolean \u00e2\u02dc\u01926 = p_76034_.computeIfAbsent(\u00e2\u02dc\u01922, p_76057_ -> {
                BlockPos blockPos = blockPos.m_7495_();
                BlockState \u00e2\u02dc\u01922 = p_76027_.m_8055_(blockPos);
                return this.m_75956_(p_76027_, this.m_5615_(), blockPos, \u00e2\u02dc\u01924, blockPos, \u00e2\u02dc\u01922);
            });
            if (\u00e2\u02dc\u01926) {
                return p_76029_;
            }
            if (p_76029_ >= this.m_6719_(p_76027_) || (\u00e2\u02dc\u0192 = this.m_76026_(p_76027_, blockPos, p_76029_ + 1, direction.m_122424_(), \u00e2\u02dc\u01924, p_76032_, p_76033_, p_76034_)) >= \u00e2\u02dc\u01927) continue;
            \u00e2\u02dc\u01927 = \u00e2\u02dc\u0192;
        }
        return \u00e2\u02dc\u01927;
    }

    private boolean m_75956_(BlockGetter p_75957_, Fluid p_75958_, BlockPos p_75959_, BlockState p_75960_, BlockPos p_75961_, BlockState p_75962_) {
        if (!this.m_76061_(Direction.DOWN, p_75957_, p_75959_, p_75960_, p_75961_, p_75962_)) {
            return false;
        }
        if (p_75962_.m_60819_().m_76152_().m_6212_(this)) {
            return true;
        }
        return this.m_75972_(p_75957_, p_75961_, p_75962_, p_75958_);
    }

    private boolean m_75963_(BlockGetter p_75964_, Fluid p_75965_, BlockPos p_75966_, BlockState p_75967_, Direction p_75968_, BlockPos p_75969_, BlockState p_75970_, FluidState p_75971_) {
        return !this.m_76096_(p_75971_) && this.m_76061_(p_75968_, p_75964_, p_75966_, p_75967_, p_75969_, p_75970_) && this.m_75972_(p_75964_, p_75969_, p_75970_, p_75965_);
    }

    private boolean m_76096_(FluidState p_76097_) {
        return p_76097_.m_76152_().m_6212_(this) && p_76097_.m_76170_();
    }

    protected abstract int m_6719_(LevelReader var1);

    private int m_76019_(LevelReader p_76020_, BlockPos p_76021_) {
        int n = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = p_76021_.m_142300_(direction);
            FluidState \u00e2\u02dc\u01922 = p_76020_.m_6425_(blockPos);
            if (!this.m_76096_(\u00e2\u02dc\u01922)) continue;
            ++n;
        }
        return n;
    }

    protected Map<Direction, FluidState> m_76079_(LevelReader p_76080_, BlockPos p_76081_, BlockState p_76082_) {
        int \u00e2\u02dc\u019212 = 1000;
        EnumMap \u00e2\u02dc\u01922 = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap \u00e2\u02dc\u01923 = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap \u00e2\u02dc\u01924 = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = p_76081_.m_142300_(direction);
            short \u00e2\u02dc\u01925 = FlowingFluid.m_76058_(p_76081_, blockPos);
            Pair \u00e2\u02dc\u01926 = (Pair)\u00e2\u02dc\u01923.computeIfAbsent(\u00e2\u02dc\u01925, p_76025_ -> {
                BlockState blockState = p_76080_.m_8055_(blockPos);
                return Pair.of((Object)blockState, (Object)blockState.m_60819_());
            });
            BlockState \u00e2\u02dc\u01927 = (BlockState)\u00e2\u02dc\u01926.getFirst();
            FluidState \u00e2\u02dc\u01928 = (FluidState)\u00e2\u02dc\u01926.getSecond();
            FluidState \u00e2\u02dc\u01929 = this.m_76035_(p_76080_, blockPos, \u00e2\u02dc\u01927);
            if (!this.m_75963_(p_76080_, \u00e2\u02dc\u01929.m_76152_(), p_76081_, p_76082_, direction, blockPos, \u00e2\u02dc\u01927, \u00e2\u02dc\u01928)) continue;
            \u00e2\u02dc\u0192 = blockPos.m_7495_();
            boolean \u00e2\u02dc\u019210 = \u00e2\u02dc\u01924.computeIfAbsent(\u00e2\u02dc\u01925, p_76044_ -> {
                BlockState blockState = p_76080_.m_8055_(\u00e2\u02dc\u0192);
                return this.m_75956_(p_76080_, this.m_5615_(), blockPos, \u00e2\u02dc\u01927, \u00e2\u02dc\u0192, blockState);
            });
            int \u00e2\u02dc\u019211 = \u00e2\u02dc\u019210 ? 0 : this.m_76026_(p_76080_, blockPos, 1, direction.m_122424_(), \u00e2\u02dc\u01927, p_76081_, (Short2ObjectMap<Pair<BlockState, FluidState>>)\u00e2\u02dc\u01923, (Short2BooleanMap)\u00e2\u02dc\u01924);
            if (\u00e2\u02dc\u019211 < \u00e2\u02dc\u019212) {
                \u00e2\u02dc\u01922.clear();
            }
            if (\u00e2\u02dc\u019211 > \u00e2\u02dc\u019212) continue;
            \u00e2\u02dc\u01922.put(direction, \u00e2\u02dc\u01929);
            \u00e2\u02dc\u019212 = \u00e2\u02dc\u019211;
        }
        return \u00e2\u02dc\u01922;
    }

    private boolean m_75972_(BlockGetter p_75973_, BlockPos p_75974_, BlockState p_75975_, Fluid p_75976_) {
        Block block = p_75975_.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            return ((LiquidBlockContainer)((Object)block)).m_6044_(p_75973_, p_75974_, p_75975_, p_75976_);
        }
        if (block instanceof DoorBlock || p_75975_.m_60620_(BlockTags.f_13068_) || p_75975_.m_60713_(Blocks.f_50155_) || p_75975_.m_60713_(Blocks.f_50130_) || p_75975_.m_60713_(Blocks.f_50628_)) {
            return false;
        }
        Material \u00e2\u02dc\u01922 = p_75975_.m_60767_();
        if (\u00e2\u02dc\u01922 == Material.f_76298_ || \u00e2\u02dc\u01922 == Material.f_76297_ || \u00e2\u02dc\u01922 == Material.f_76301_ || \u00e2\u02dc\u01922 == Material.f_76304_) {
            return false;
        }
        return !\u00e2\u02dc\u01922.m_76334_();
    }

    protected boolean m_75977_(BlockGetter p_75978_, BlockPos p_75979_, BlockState p_75980_, Direction p_75981_, BlockPos p_75982_, BlockState p_75983_, FluidState p_75984_, Fluid p_75985_) {
        return p_75984_.m_76158_(p_75978_, p_75982_, p_75985_, p_75981_) && this.m_76061_(p_75981_, p_75978_, p_75979_, p_75980_, p_75982_, p_75983_) && this.m_75972_(p_75978_, p_75982_, p_75983_, p_75985_);
    }

    protected abstract int m_6713_(LevelReader var1);

    protected int m_6886_(Level p_75998_, BlockPos p_75999_, FluidState p_76000_, FluidState p_76001_) {
        return this.m_6718_(p_75998_);
    }

    @Override
    public void m_6292_(Level p_75995_, BlockPos p_75996_, FluidState p_75997_) {
        if (!p_75997_.m_76170_()) {
            FluidState fluidState = this.m_76035_(p_75995_, p_75996_, p_75995_.m_8055_(p_75996_));
            int \u00e2\u02dc\u01922 = this.m_6886_(p_75995_, p_75996_, p_75997_, fluidState);
            if (fluidState.m_76178_()) {
                p_75997_ = fluidState;
                p_75995_.m_7731_(p_75996_, Blocks.f_50016_.m_49966_(), 3);
            } else if (!fluidState.equals(p_75997_)) {
                p_75997_ = fluidState;
                BlockState blockState = p_75997_.m_76188_();
                p_75995_.m_7731_(p_75996_, blockState, 2);
                p_75995_.m_6217_().m_5945_(p_75996_, p_75997_.m_76152_(), \u00e2\u02dc\u01922);
                p_75995_.m_46672_(p_75996_, blockState.m_60734_());
            }
        }
        this.m_76010_(p_75995_, p_75996_, p_75997_);
    }

    protected static int m_76092_(FluidState p_76093_) {
        if (p_76093_.m_76170_()) {
            return 0;
        }
        return 8 - Math.min(p_76093_.m_76186_(), 8) + (p_76093_.m_61143_(f_75947_) != false ? 8 : 0);
    }

    private static boolean m_76088_(FluidState p_76089_, BlockGetter p_76090_, BlockPos p_76091_) {
        return p_76089_.m_76152_().m_6212_(p_76090_.m_6425_(p_76091_.m_7494_()).m_76152_());
    }

    @Override
    public float m_6098_(FluidState p_76050_, BlockGetter p_76051_, BlockPos p_76052_) {
        if (FlowingFluid.m_76088_(p_76050_, p_76051_, p_76052_)) {
            return 1.0f;
        }
        return p_76050_.m_76182_();
    }

    @Override
    public float m_7427_(FluidState p_76048_) {
        return (float)p_76048_.m_76186_() / 9.0f;
    }

    @Override
    public abstract int m_7430_(FluidState var1);

    @Override
    public VoxelShape m_7999_(FluidState p_76084_, BlockGetter p_76085_, BlockPos p_76086_) {
        if (p_76084_.m_76186_() == 9 && FlowingFluid.m_76088_(p_76084_, p_76085_, p_76086_)) {
            return Shapes.m_83144_();
        }
        return this.f_75950_.computeIfAbsent(p_76084_, p_76073_ -> Shapes.m_83048_(0.0, 0.0, 0.0, 1.0, p_76073_.m_76155_(p_76085_, p_76086_), 1.0));
    }
}

