/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;

public class PathFinder {
    private static final float f_164714_ = 1.5f;
    private final Node[] f_77420_ = new Node[32];
    private final int f_77421_;
    private final NodeEvaluator f_77422_;
    private static final boolean f_164715_ = false;
    private final BinaryHeap f_77423_ = new BinaryHeap();

    public PathFinder(NodeEvaluator p_77425_, int p_77426_) {
        this.f_77422_ = p_77425_;
        this.f_77421_ = p_77426_;
    }

    @Nullable
    public Path m_77427_(PathNavigationRegion p_77428_, Mob p_77429_, Set<BlockPos> p_77430_, float p_77431_, int p_77432_, float p_77433_) {
        this.f_77423_.m_77081_();
        this.f_77422_.m_6028_(p_77428_, p_77429_);
        Node node = this.f_77422_.m_7171_();
        Map<Target, BlockPos> \u00e2\u02dc\u01922 = p_77430_.stream().collect(Collectors.toMap(p_77448_ -> this.f_77422_.m_7568_(p_77448_.m_123341_(), p_77448_.m_123342_(), p_77448_.m_123343_()), Function.identity()));
        Path \u00e2\u02dc\u01923 = this.m_164716_(p_77428_.m_151625_(), node, \u00e2\u02dc\u01922, p_77431_, p_77432_, p_77433_);
        this.f_77422_.m_6802_();
        return \u00e2\u02dc\u01923;
    }

    @Nullable
    private Path m_164716_(ProfilerFiller p_164717_, Node p_164718_, Map<Target, BlockPos> p_164719_, float p_164720_, int p_164721_, float p_164722_) {
        Object object;
        p_164717_.m_6180_("find_path");
        p_164717_.m_142259_(MetricCategory.PATH_FINDING);
        Set<Target> set = p_164719_.keySet();
        p_164718_.f_77275_ = 0.0f;
        p_164718_.f_77277_ = p_164718_.f_77276_ = this.m_77444_(p_164718_, set);
        this.f_77423_.m_77081_();
        this.f_77423_.m_77084_(p_164718_);
        ImmutableSet \u00e2\u02dc\u01922 = ImmutableSet.of();
        int \u00e2\u02dc\u01923 = 0;
        HashSet \u00e2\u02dc\u01924 = Sets.newHashSetWithExpectedSize((int)set.size());
        int \u00e2\u02dc\u01925 = (int)((float)this.f_77421_ * p_164722_);
        while (!this.f_77423_.m_77092_() && ++\u00e2\u02dc\u01923 < \u00e2\u02dc\u01925) {
            object = this.f_77423_.m_77091_();
            ((Node)object).f_77279_ = true;
            for (Target target : set) {
                if (!(((Node)object).m_77304_(target) <= (float)p_164721_)) continue;
                target.m_77509_();
                \u00e2\u02dc\u01924.add(target);
            }
            if (!\u00e2\u02dc\u01924.isEmpty()) break;
            if (((Node)object).m_77293_(p_164718_) >= p_164720_) continue;
            int \u00e2\u02dc\u01926 = this.f_77422_.m_6065_(this.f_77420_, (Node)object);
            for (int i = 0; i < \u00e2\u02dc\u01926; ++i) {
                Node node = this.f_77420_[i];
                float \u00e2\u02dc\u01927 = ((Node)object).m_77293_(node);
                node.f_77280_ = ((Node)object).f_77280_ + \u00e2\u02dc\u01927;
                float \u00e2\u02dc\u01928 = ((Node)object).f_77275_ + \u00e2\u02dc\u01927 + node.f_77281_;
                if (!(node.f_77280_ < p_164720_) || node.m_77303_() && !(\u00e2\u02dc\u01928 < node.f_77275_)) continue;
                node.f_77278_ = object;
                node.f_77275_ = \u00e2\u02dc\u01928;
                node.f_77276_ = this.m_77444_(node, set) * 1.5f;
                if (node.m_77303_()) {
                    this.f_77423_.m_77086_(node, node.f_77275_ + node.f_77276_);
                    continue;
                }
                node.f_77277_ = node.f_77275_ + node.f_77276_;
                this.f_77423_.m_77084_(node);
            }
        }
        object = !\u00e2\u02dc\u01924.isEmpty() ? \u00e2\u02dc\u01924.stream().map(p_77454_ -> this.m_77434_(p_77454_.m_77508_(), (BlockPos)p_164719_.get(p_77454_), true)).min(Comparator.comparingInt(Path::m_77398_)) : set.stream().map(p_77451_ -> this.m_77434_(p_77451_.m_77508_(), (BlockPos)p_164719_.get(p_77451_), false)).min(Comparator.comparingDouble(Path::m_77407_).thenComparingInt(Path::m_77398_));
        p_164717_.m_7238_();
        if (!((Optional)object).isPresent()) {
            return null;
        }
        Path \u00e2\u02dc\u01929 = (Path)((Optional)object).get();
        return \u00e2\u02dc\u01929;
    }

    private float m_77444_(Node p_77445_, Set<Target> p_77446_) {
        float f = Float.MAX_VALUE;
        for (Target target : p_77446_) {
            float f2 = p_77445_.m_77293_(target);
            target.m_77503_(f2, p_77445_);
            f = Math.min(f2, f);
        }
        return f;
    }

    private Path m_77434_(Node p_77435_, BlockPos p_77436_, boolean p_77437_) {
        ArrayList arrayList = Lists.newArrayList();
        Node \u00e2\u02dc\u01922 = p_77435_;
        arrayList.add(0, \u00e2\u02dc\u01922);
        while (\u00e2\u02dc\u01922.f_77278_ != null) {
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.f_77278_;
            arrayList.add(0, \u00e2\u02dc\u01922);
        }
        return new Path(arrayList, p_77436_, p_77437_);
    }
}

