/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;

public class SwimNodeEvaluator
extends NodeEvaluator {
    private final boolean f_77455_;

    public SwimNodeEvaluator(boolean p_77457_) {
        this.f_77455_ = p_77457_;
    }

    @Override
    public Node m_7171_() {
        return super.m_5676_(Mth.m_14107_(this.f_77313_.m_142469_().f_82288_), Mth.m_14107_(this.f_77313_.m_142469_().f_82289_ + 0.5), Mth.m_14107_(this.f_77313_.m_142469_().f_82290_));
    }

    @Override
    public Target m_7568_(double p_77459_, double p_77460_, double p_77461_) {
        return new Target(super.m_5676_(Mth.m_14107_(p_77459_ - (double)(this.f_77313_.m_20205_() / 2.0f)), Mth.m_14107_(p_77460_ + 0.5), Mth.m_14107_(p_77461_ - (double)(this.f_77313_.m_20205_() / 2.0f))));
    }

    @Override
    public int m_6065_(Node[] p_77483_, Node p_77484_) {
        int n = 0;
        for (Direction direction : Direction.values()) {
            Node node = this.m_77486_(p_77484_.f_77271_ + direction.m_122429_(), p_77484_.f_77272_ + direction.m_122430_(), p_77484_.f_77273_ + direction.m_122431_());
            if (node == null || node.f_77279_) continue;
            p_77483_[n++] = node;
        }
        return n;
    }

    @Override
    public BlockPathTypes m_7209_(BlockGetter p_77472_, int p_77473_, int p_77474_, int p_77475_, Mob p_77476_, int p_77477_, int p_77478_, int p_77479_, boolean p_77480_, boolean p_77481_) {
        return this.m_8086_(p_77472_, p_77473_, p_77474_, p_77475_);
    }

    @Override
    public BlockPathTypes m_8086_(BlockGetter p_77467_, int p_77468_, int p_77469_, int p_77470_) {
        BlockPos blockPos = new BlockPos(p_77468_, p_77469_, p_77470_);
        FluidState \u00e2\u02dc\u01922 = p_77467_.m_6425_(blockPos);
        BlockState \u00e2\u02dc\u01923 = p_77467_.m_8055_(blockPos);
        if (\u00e2\u02dc\u01922.m_76178_() && \u00e2\u02dc\u01923.m_60647_(p_77467_, blockPos.m_7495_(), PathComputationType.WATER) && \u00e2\u02dc\u01923.m_60795_()) {
            return BlockPathTypes.BREACH;
        }
        if (!\u00e2\u02dc\u01922.m_76153_(FluidTags.f_13131_) || !\u00e2\u02dc\u01923.m_60647_(p_77467_, blockPos, PathComputationType.WATER)) {
            return BlockPathTypes.BLOCKED;
        }
        return BlockPathTypes.WATER;
    }

    @Nullable
    private Node m_77486_(int p_77487_, int p_77488_, int p_77489_) {
        BlockPathTypes blockPathTypes = this.m_77490_(p_77487_, p_77488_, p_77489_);
        if (this.f_77455_ && blockPathTypes == BlockPathTypes.BREACH || blockPathTypes == BlockPathTypes.WATER) {
            return this.m_5676_(p_77487_, p_77488_, p_77489_);
        }
        return null;
    }

    @Override
    @Nullable
    protected Node m_5676_(int p_77463_, int p_77464_, int p_77465_) {
        Node node = null;
        BlockPathTypes \u00e2\u02dc\u01922 = this.m_8086_(this.f_77313_.f_19853_, p_77463_, p_77464_, p_77465_);
        float \u00e2\u02dc\u01923 = this.f_77313_.m_21439_(\u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01923 >= 0.0f) {
            node = super.m_5676_(p_77463_, p_77464_, p_77465_);
            node.f_77282_ = \u00e2\u02dc\u01922;
            node.f_77281_ = Math.max(node.f_77281_, \u00e2\u02dc\u01923);
            if (this.f_77312_.m_6425_(new BlockPos(p_77463_, p_77464_, p_77465_)).m_76178_()) {
                node.f_77281_ += 8.0f;
            }
        }
        if (\u00e2\u02dc\u01922 == BlockPathTypes.OPEN) {
            return node;
        }
        return node;
    }

    private BlockPathTypes m_77490_(int p_77491_, int p_77492_, int p_77493_) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = p_77491_; i < p_77491_ + this.f_77315_; ++i) {
            for (\u00e2\u02dc\u0192 = p_77492_; \u00e2\u02dc\u0192 < p_77492_ + this.f_77316_; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = p_77493_; \u00e2\u02dc\u0192 < p_77493_ + this.f_77317_; ++\u00e2\u02dc\u0192) {
                    FluidState fluidState = this.f_77312_.m_6425_(mutableBlockPos.m_122178_(i, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
                    BlockState \u00e2\u02dc\u01922 = this.f_77312_.m_8055_(mutableBlockPos.m_122178_(i, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
                    if (fluidState.m_76178_() && \u00e2\u02dc\u01922.m_60647_(this.f_77312_, (BlockPos)mutableBlockPos.m_7495_(), PathComputationType.WATER) && \u00e2\u02dc\u01922.m_60795_()) {
                        return BlockPathTypes.BREACH;
                    }
                    if (fluidState.m_76153_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.BLOCKED;
                }
            }
        }
        BlockState blockState = this.f_77312_.m_8055_(mutableBlockPos);
        if (blockState.m_60647_(this.f_77312_, mutableBlockPos, PathComputationType.WATER)) {
            return BlockPathTypes.WATER;
        }
        return BlockPathTypes.BLOCKED;
    }
}

