/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WalkNodeEvaluator
extends NodeEvaluator {
    public static final double f_164724_ = 0.5;
    protected float f_77544_;
    private final Long2ObjectMap<BlockPathTypes> f_77545_ = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> f_77546_ = new Object2BooleanOpenHashMap();

    @Override
    public void m_6028_(PathNavigationRegion p_77620_, Mob p_77621_) {
        super.m_6028_(p_77620_, p_77621_);
        this.f_77544_ = p_77621_.m_21439_(BlockPathTypes.WATER);
    }

    @Override
    public void m_6802_() {
        this.f_77313_.m_21441_(BlockPathTypes.WATER, this.f_77544_);
        this.f_77545_.clear();
        this.f_77546_.clear();
        super.m_6802_();
    }

    @Override
    public Node m_7171_() {
        Object \u00e2\u02dc\u01925;
        BlockPos blockPos;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int \u00e2\u02dc\u01922 = this.f_77313_.m_146904_();
        BlockState \u00e2\u02dc\u01923 = this.f_77312_.m_8055_(mutableBlockPos.m_122169_(this.f_77313_.m_20185_(), \u00e2\u02dc\u01922, this.f_77313_.m_20189_()));
        if (this.f_77313_.m_7479_(\u00e2\u02dc\u01923.m_60819_().m_76152_())) {
            while (this.f_77313_.m_7479_(\u00e2\u02dc\u01923.m_60819_().m_76152_())) {
                \u00e2\u02dc\u01923 = this.f_77312_.m_8055_(mutableBlockPos.m_122169_(this.f_77313_.m_20185_(), ++\u00e2\u02dc\u01922, this.f_77313_.m_20189_()));
            }
            --\u00e2\u02dc\u01922;
        } else if (this.m_77361_() && this.f_77313_.m_20069_()) {
            while (\u00e2\u02dc\u01923.m_60713_(Blocks.f_49990_) || \u00e2\u02dc\u01923.m_60819_() == Fluids.f_76193_.m_76068_(false)) {
                \u00e2\u02dc\u01923 = this.f_77312_.m_8055_(mutableBlockPos.m_122169_(this.f_77313_.m_20185_(), ++\u00e2\u02dc\u01922, this.f_77313_.m_20189_()));
            }
            --\u00e2\u02dc\u01922;
        } else if (this.f_77313_.m_20096_()) {
            \u00e2\u02dc\u01922 = Mth.m_14107_(this.f_77313_.m_20186_() + 0.5);
        } else {
            blockPos = this.f_77313_.m_142538_();
            while ((this.f_77312_.m_8055_(blockPos).m_60795_() || this.f_77312_.m_8055_(blockPos).m_60647_(this.f_77312_, blockPos, PathComputationType.LAND)) && blockPos.m_123342_() > this.f_77313_.f_19853_.m_141937_()) {
                blockPos = blockPos.m_7495_();
            }
            \u00e2\u02dc\u01922 = blockPos.m_7494_().m_123342_();
        }
        blockPos = this.f_77313_.m_142538_();
        BlockPathTypes \u00e2\u02dc\u01924 = this.m_77567_(this.f_77313_, blockPos.m_123341_(), \u00e2\u02dc\u01922, blockPos.m_123343_());
        if (this.f_77313_.m_21439_(\u00e2\u02dc\u01924) < 0.0f) {
            \u00e2\u02dc\u01925 = this.f_77313_.m_142469_();
            if (this.m_77646_(mutableBlockPos.m_122169_(((AABB)\u00e2\u02dc\u01925).f_82288_, \u00e2\u02dc\u01922, ((AABB)\u00e2\u02dc\u01925).f_82290_)) || this.m_77646_(mutableBlockPos.m_122169_(((AABB)\u00e2\u02dc\u01925).f_82288_, \u00e2\u02dc\u01922, ((AABB)\u00e2\u02dc\u01925).f_82293_)) || this.m_77646_(mutableBlockPos.m_122169_(((AABB)\u00e2\u02dc\u01925).f_82291_, \u00e2\u02dc\u01922, ((AABB)\u00e2\u02dc\u01925).f_82290_)) || this.m_77646_(mutableBlockPos.m_122169_(((AABB)\u00e2\u02dc\u01925).f_82291_, \u00e2\u02dc\u01922, ((AABB)\u00e2\u02dc\u01925).f_82293_))) {
                Node node = this.m_77349_(mutableBlockPos);
                node.f_77282_ = this.m_77572_(this.f_77313_, node.m_77288_());
                node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
                return node;
            }
        }
        \u00e2\u02dc\u01925 = this.m_5676_(blockPos.m_123341_(), \u00e2\u02dc\u01922, blockPos.m_123343_());
        ((Node)\u00e2\u02dc\u01925).f_77282_ = this.m_77572_(this.f_77313_, ((Node)\u00e2\u02dc\u01925).m_77288_());
        ((Node)\u00e2\u02dc\u01925).f_77281_ = this.f_77313_.m_21439_(((Node)\u00e2\u02dc\u01925).f_77282_);
        return \u00e2\u02dc\u01925;
    }

    private boolean m_77646_(BlockPos p_77647_) {
        BlockPathTypes blockPathTypes = this.m_77572_(this.f_77313_, p_77647_);
        return this.f_77313_.m_21439_(blockPathTypes) >= 0.0f;
    }

    @Override
    public Target m_7568_(double p_77550_, double p_77551_, double p_77552_) {
        return new Target(this.m_5676_(Mth.m_14107_(p_77550_), Mth.m_14107_(p_77551_), Mth.m_14107_(p_77552_)));
    }

    @Override
    public int m_6065_(Node[] p_77640_, Node p_77641_) {
        int n = 0;
        \u00e2\u02dc\u0192 = 0;
        BlockPathTypes \u00e2\u02dc\u01922 = this.m_77567_(this.f_77313_, p_77641_.f_77271_, p_77641_.f_77272_ + 1, p_77641_.f_77273_);
        BlockPathTypes \u00e2\u02dc\u01923 = this.m_77567_(this.f_77313_, p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_);
        if (this.f_77313_.m_21439_(\u00e2\u02dc\u01922) >= 0.0f && \u00e2\u02dc\u01923 != BlockPathTypes.STICKY_HONEY) {
            \u00e2\u02dc\u0192 = Mth.m_14143_(Math.max(1.0f, this.f_77313_.f_19793_));
        }
        if (this.m_77626_(\u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_ + 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 = this.m_142213_(new BlockPos(p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_)), Direction.SOUTH, \u00e2\u02dc\u01923), p_77641_)) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77626_(\u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_ - 1, p_77641_.f_77272_, p_77641_.f_77273_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.WEST, \u00e2\u02dc\u01923), p_77641_)) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77626_(\u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_ + 1, p_77641_.f_77272_, p_77641_.f_77273_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.EAST, \u00e2\u02dc\u01923), p_77641_)) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77626_(\u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_, p_77641_.f_77272_, p_77641_.f_77273_ - 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.NORTH, \u00e2\u02dc\u01923), p_77641_)) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77629_(p_77641_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_ - 1, p_77641_.f_77272_, p_77641_.f_77273_ - 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.NORTH, \u00e2\u02dc\u01923))) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77629_(p_77641_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_ + 1, p_77641_.f_77272_, p_77641_.f_77273_ - 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.NORTH, \u00e2\u02dc\u01923))) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77629_(p_77641_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_ - 1, p_77641_.f_77272_, p_77641_.f_77273_ + 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.SOUTH, \u00e2\u02dc\u01923))) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        if (this.m_77629_(p_77641_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 = this.m_164725_(p_77641_.f_77271_ + 1, p_77641_.f_77272_, p_77641_.f_77273_ + 1, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, Direction.SOUTH, \u00e2\u02dc\u01923))) {
            p_77640_[n++] = \u00e2\u02dc\u0192;
        }
        return n;
    }

    protected boolean m_77626_(@Nullable Node p_77627_, Node p_77628_) {
        return p_77627_ != null && !p_77627_.f_77279_ && (p_77627_.f_77281_ >= 0.0f || p_77628_.f_77281_ < 0.0f);
    }

    protected boolean m_77629_(Node p_77630_, @Nullable Node p_77631_, @Nullable Node p_77632_, @Nullable Node p_77633_) {
        if (p_77633_ == null || p_77632_ == null || p_77631_ == null) {
            return false;
        }
        if (p_77633_.f_77279_) {
            return false;
        }
        if (p_77632_.f_77272_ > p_77630_.f_77272_ || p_77631_.f_77272_ > p_77630_.f_77272_) {
            return false;
        }
        if (p_77631_.f_77282_ == BlockPathTypes.WALKABLE_DOOR || p_77632_.f_77282_ == BlockPathTypes.WALKABLE_DOOR || p_77633_.f_77282_ == BlockPathTypes.WALKABLE_DOOR) {
            return false;
        }
        boolean bl = p_77632_.f_77282_ == BlockPathTypes.FENCE && p_77631_.f_77282_ == BlockPathTypes.FENCE && (double)this.f_77313_.m_20205_() < 0.5;
        return p_77633_.f_77281_ >= 0.0f && (p_77632_.f_77272_ < p_77630_.f_77272_ || p_77632_.f_77281_ >= 0.0f || bl) && (p_77631_.f_77272_ < p_77630_.f_77272_ || p_77631_.f_77281_ >= 0.0f || bl);
    }

    private boolean m_77624_(Node p_77625_) {
        Vec3 vec3 = new Vec3((double)p_77625_.f_77271_ - this.f_77313_.m_20185_(), (double)p_77625_.f_77272_ - this.f_77313_.m_20186_(), (double)p_77625_.f_77273_ - this.f_77313_.m_20189_());
        AABB \u00e2\u02dc\u01922 = this.f_77313_.m_142469_();
        int \u00e2\u02dc\u01923 = Mth.m_14165_(vec3.m_82553_() / \u00e2\u02dc\u01922.m_82309_());
        vec3 = vec3.m_82490_(1.0f / (float)\u00e2\u02dc\u01923);
        for (int i = 1; i <= \u00e2\u02dc\u01923; ++i) {
            if (!this.m_77634_(\u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double m_142213_(BlockPos p_164733_) {
        return WalkNodeEvaluator.m_77611_(this.f_77312_, p_164733_);
    }

    public static double m_77611_(BlockGetter p_77612_, BlockPos p_77613_) {
        BlockPos blockPos = p_77613_.m_7495_();
        VoxelShape \u00e2\u02dc\u01922 = p_77612_.m_8055_(blockPos).m_60812_(p_77612_, blockPos);
        return (double)blockPos.m_123342_() + (\u00e2\u02dc\u01922.m_83281_() ? 0.0 : \u00e2\u02dc\u01922.m_83297_(Direction.Axis.Y));
    }

    protected boolean m_141974_() {
        return false;
    }

    @Nullable
    protected Node m_164725_(int p_164726_, int p_164727_, int p_164728_, int p_164729_, double p_164730_, Direction p_164731_, BlockPathTypes p_164732_) {
        Node node = null;
        BlockPos.MutableBlockPos \u00e2\u02dc\u01922 = new BlockPos.MutableBlockPos();
        double \u00e2\u02dc\u01923 = this.m_142213_(\u00e2\u02dc\u01922.m_122178_(p_164726_, p_164727_, p_164728_));
        if (\u00e2\u02dc\u01923 - p_164730_ > 1.125) {
            return null;
        }
        BlockPathTypes \u00e2\u02dc\u01924 = this.m_77567_(this.f_77313_, p_164726_, p_164727_, p_164728_);
        float \u00e2\u02dc\u01925 = this.f_77313_.m_21439_(\u00e2\u02dc\u01924);
        double \u00e2\u02dc\u01926 = (double)this.f_77313_.m_20205_() / 2.0;
        if (\u00e2\u02dc\u01925 >= 0.0f) {
            node = this.m_5676_(p_164726_, p_164727_, p_164728_);
            node.f_77282_ = \u00e2\u02dc\u01924;
            node.f_77281_ = Math.max(node.f_77281_, \u00e2\u02dc\u01925);
        }
        if (p_164732_ == BlockPathTypes.FENCE && node != null && node.f_77281_ >= 0.0f && !this.m_77624_(node)) {
            node = null;
        }
        if (\u00e2\u02dc\u01924 == BlockPathTypes.WALKABLE || this.m_141974_() && \u00e2\u02dc\u01924 == BlockPathTypes.WATER) {
            return node;
        }
        if ((node == null || node.f_77281_ < 0.0f) && p_164729_ > 0 && \u00e2\u02dc\u01924 != BlockPathTypes.FENCE && \u00e2\u02dc\u01924 != BlockPathTypes.UNPASSABLE_RAIL && \u00e2\u02dc\u01924 != BlockPathTypes.TRAPDOOR && \u00e2\u02dc\u01924 != BlockPathTypes.POWDER_SNOW && (node = this.m_164725_(p_164726_, p_164727_ + 1, p_164728_, p_164729_ - 1, p_164730_, p_164731_, p_164732_)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && this.f_77313_.m_20205_() < 1.0f && this.m_77634_(\u00e2\u02dc\u0192 = new AABB((\u00e2\u02dc\u0192 = (double)(p_164726_ - p_164731_.m_122429_()) + 0.5) - \u00e2\u02dc\u01926, WalkNodeEvaluator.m_77611_(this.f_77312_, \u00e2\u02dc\u01922.m_122169_(\u00e2\u02dc\u0192, p_164727_ + 1, \u00e2\u02dc\u0192 = (double)(p_164728_ - p_164731_.m_122431_()) + 0.5)) + 0.001, \u00e2\u02dc\u0192 - \u00e2\u02dc\u01926, \u00e2\u02dc\u0192 + \u00e2\u02dc\u01926, (double)this.f_77313_.m_20206_() + WalkNodeEvaluator.m_77611_(this.f_77312_, \u00e2\u02dc\u01922.m_122169_(node.f_77271_, node.f_77272_, node.f_77273_)) - 0.002, \u00e2\u02dc\u0192 + \u00e2\u02dc\u01926))) {
            node = null;
        }
        if (!this.m_141974_() && \u00e2\u02dc\u01924 == BlockPathTypes.WATER && !this.m_77361_()) {
            if (this.m_77567_(this.f_77313_, p_164726_, p_164727_ - 1, p_164728_) != BlockPathTypes.WATER) {
                return node;
            }
            while (p_164727_ > this.f_77313_.f_19853_.m_141937_()) {
                if ((\u00e2\u02dc\u01924 = this.m_77567_(this.f_77313_, p_164726_, --p_164727_, p_164728_)) == BlockPathTypes.WATER) {
                    node = this.m_5676_(p_164726_, p_164727_, p_164728_);
                    node.f_77282_ = \u00e2\u02dc\u01924;
                    node.f_77281_ = Math.max(node.f_77281_, this.f_77313_.m_21439_(\u00e2\u02dc\u01924));
                    continue;
                }
                return node;
            }
        }
        if (\u00e2\u02dc\u01924 == BlockPathTypes.OPEN) {
            int n = 0;
            \u00e2\u02dc\u0192 = p_164727_;
            while (\u00e2\u02dc\u01924 == BlockPathTypes.OPEN) {
                if (--p_164727_ < this.f_77313_.f_19853_.m_141937_()) {
                    Node node2 = this.m_5676_(p_164726_, \u00e2\u02dc\u0192, p_164728_);
                    node2.f_77282_ = BlockPathTypes.BLOCKED;
                    node2.f_77281_ = -1.0f;
                    return node2;
                }
                if (n++ >= this.f_77313_.m_6056_()) {
                    Node node3 = this.m_5676_(p_164726_, p_164727_, p_164728_);
                    node3.f_77282_ = BlockPathTypes.BLOCKED;
                    node3.f_77281_ = -1.0f;
                    return node3;
                }
                \u00e2\u02dc\u01924 = this.m_77567_(this.f_77313_, p_164726_, p_164727_, p_164728_);
                \u00e2\u02dc\u01925 = this.f_77313_.m_21439_(\u00e2\u02dc\u01924);
                if (\u00e2\u02dc\u01924 != BlockPathTypes.OPEN && \u00e2\u02dc\u01925 >= 0.0f) {
                    node = this.m_5676_(p_164726_, p_164727_, p_164728_);
                    node.f_77282_ = \u00e2\u02dc\u01924;
                    node.f_77281_ = Math.max(node.f_77281_, \u00e2\u02dc\u01925);
                    break;
                }
                if (!(\u00e2\u02dc\u01925 < 0.0f)) continue;
                Node node4 = this.m_5676_(p_164726_, p_164727_, p_164728_);
                node4.f_77282_ = BlockPathTypes.BLOCKED;
                node4.f_77281_ = -1.0f;
                return node4;
            }
        }
        if (\u00e2\u02dc\u01924 == BlockPathTypes.FENCE) {
            node = this.m_5676_(p_164726_, p_164727_, p_164728_);
            node.f_77279_ = true;
            node.f_77282_ = \u00e2\u02dc\u01924;
            node.f_77281_ = \u00e2\u02dc\u01924.m_77124_();
        }
        return node;
    }

    private boolean m_77634_(AABB p_77635_) {
        return (Boolean)this.f_77546_.computeIfAbsent((Object)p_77635_, p_77638_ -> !this.f_77312_.m_45756_(this.f_77313_, p_77635_));
    }

    @Override
    public BlockPathTypes m_7209_(BlockGetter p_77594_, int p_77595_, int p_77596_, int p_77597_, Mob p_77598_, int p_77599_, int p_77600_, int p_77601_, boolean p_77602_, boolean p_77603_) {
        EnumSet<BlockPathTypes> enumSet = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes \u00e2\u02dc\u01922 = BlockPathTypes.BLOCKED;
        BlockPos \u00e2\u02dc\u01923 = p_77598_.m_142538_();
        \u00e2\u02dc\u01922 = this.m_77580_(p_77594_, p_77595_, p_77596_, p_77597_, p_77599_, p_77600_, p_77601_, p_77602_, p_77603_, enumSet, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
        if (enumSet.contains((Object)BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        if (enumSet.contains((Object)BlockPathTypes.UNPASSABLE_RAIL)) {
            return BlockPathTypes.UNPASSABLE_RAIL;
        }
        BlockPathTypes \u00e2\u02dc\u01924 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockPathTypes : enumSet) {
            if (p_77598_.m_21439_(blockPathTypes) < 0.0f) {
                return blockPathTypes;
            }
            if (!(p_77598_.m_21439_(blockPathTypes) >= p_77598_.m_21439_(\u00e2\u02dc\u01924))) continue;
            \u00e2\u02dc\u01924 = blockPathTypes;
        }
        if (\u00e2\u02dc\u01922 == BlockPathTypes.OPEN && p_77598_.m_21439_(\u00e2\u02dc\u01924) == 0.0f && p_77599_ <= 1) {
            return BlockPathTypes.OPEN;
        }
        return \u00e2\u02dc\u01924;
    }

    public BlockPathTypes m_77580_(BlockGetter p_77581_, int p_77582_, int p_77583_, int p_77584_, int p_77585_, int p_77586_, int p_77587_, boolean p_77588_, boolean p_77589_, EnumSet<BlockPathTypes> p_77590_, BlockPathTypes p_77591_, BlockPos p_77592_) {
        for (int i = 0; i < p_77585_; ++i) {
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_77586_; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_77587_; ++\u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u0192 = i + p_77582_;
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 + p_77583_;
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 + p_77584_;
                    BlockPathTypes blockPathTypes = this.m_8086_(p_77581_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    blockPathTypes = this.m_6603_(p_77581_, p_77588_, p_77589_, p_77592_, blockPathTypes);
                    if (i == 0 && \u00e2\u02dc\u0192 == 0 && \u00e2\u02dc\u0192 == 0) {
                        p_77591_ = blockPathTypes;
                    }
                    p_77590_.add(blockPathTypes);
                }
            }
        }
        return p_77591_;
    }

    protected BlockPathTypes m_6603_(BlockGetter p_77614_, boolean p_77615_, boolean p_77616_, BlockPos p_77617_, BlockPathTypes p_77618_) {
        if (p_77618_ == BlockPathTypes.DOOR_WOOD_CLOSED && p_77615_ && p_77616_) {
            p_77618_ = BlockPathTypes.WALKABLE_DOOR;
        }
        if (p_77618_ == BlockPathTypes.DOOR_OPEN && !p_77616_) {
            p_77618_ = BlockPathTypes.BLOCKED;
        }
        if (p_77618_ == BlockPathTypes.RAIL && !(p_77614_.m_8055_(p_77617_).m_60734_() instanceof BaseRailBlock) && !(p_77614_.m_8055_(p_77617_.m_7495_()).m_60734_() instanceof BaseRailBlock)) {
            p_77618_ = BlockPathTypes.UNPASSABLE_RAIL;
        }
        if (p_77618_ == BlockPathTypes.LEAVES) {
            p_77618_ = BlockPathTypes.BLOCKED;
        }
        return p_77618_;
    }

    private BlockPathTypes m_77572_(Mob p_77573_, BlockPos p_77574_) {
        return this.m_77567_(p_77573_, p_77574_.m_123341_(), p_77574_.m_123342_(), p_77574_.m_123343_());
    }

    protected BlockPathTypes m_77567_(Mob p_77568_, int p_77569_, int p_77570_, int p_77571_) {
        return (BlockPathTypes)((Object)this.f_77545_.computeIfAbsent(BlockPos.m_121882_(p_77569_, p_77570_, p_77571_), p_77566_ -> this.m_7209_(this.f_77312_, p_77569_, p_77570_, p_77571_, p_77568_, this.f_77315_, this.f_77316_, this.f_77317_, this.m_77360_(), this.m_77357_())));
    }

    @Override
    public BlockPathTypes m_8086_(BlockGetter p_77576_, int p_77577_, int p_77578_, int p_77579_) {
        return WalkNodeEvaluator.m_77604_(p_77576_, new BlockPos.MutableBlockPos(p_77577_, p_77578_, p_77579_));
    }

    public static BlockPathTypes m_77604_(BlockGetter p_77605_, BlockPos.MutableBlockPos p_77606_) {
        int n = p_77606_.m_123341_();
        \u00e2\u02dc\u0192 = p_77606_.m_123342_();
        \u00e2\u02dc\u0192 = p_77606_.m_123343_();
        BlockPathTypes \u00e2\u02dc\u01922 = WalkNodeEvaluator.m_77643_(p_77605_, p_77606_);
        if (\u00e2\u02dc\u01922 == BlockPathTypes.OPEN && \u00e2\u02dc\u0192 >= p_77605_.m_141937_() + 1) {
            BlockPathTypes blockPathTypes = WalkNodeEvaluator.m_77643_(p_77605_, p_77606_.m_122178_(n, \u00e2\u02dc\u0192 - 1, \u00e2\u02dc\u0192));
            BlockPathTypes blockPathTypes2 = \u00e2\u02dc\u01922 = blockPathTypes == BlockPathTypes.WALKABLE || blockPathTypes == BlockPathTypes.OPEN || blockPathTypes == BlockPathTypes.WATER || blockPathTypes == BlockPathTypes.LAVA ? BlockPathTypes.OPEN : BlockPathTypes.WALKABLE;
            if (blockPathTypes == BlockPathTypes.DAMAGE_FIRE) {
                \u00e2\u02dc\u01922 = BlockPathTypes.DAMAGE_FIRE;
            }
            if (blockPathTypes == BlockPathTypes.DAMAGE_CACTUS) {
                \u00e2\u02dc\u01922 = BlockPathTypes.DAMAGE_CACTUS;
            }
            if (blockPathTypes == BlockPathTypes.DAMAGE_OTHER) {
                \u00e2\u02dc\u01922 = BlockPathTypes.DAMAGE_OTHER;
            }
            if (blockPathTypes == BlockPathTypes.STICKY_HONEY) {
                \u00e2\u02dc\u01922 = BlockPathTypes.STICKY_HONEY;
            }
        }
        if (\u00e2\u02dc\u01922 == BlockPathTypes.WALKABLE) {
            \u00e2\u02dc\u01922 = WalkNodeEvaluator.m_77607_(p_77605_, p_77606_.m_122178_(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192), \u00e2\u02dc\u01922);
        }
        return \u00e2\u02dc\u01922;
    }

    public static BlockPathTypes m_77607_(BlockGetter p_77608_, BlockPos.MutableBlockPos p_77609_, BlockPathTypes p_77610_) {
        int n = p_77609_.m_123341_();
        \u00e2\u02dc\u0192 = p_77609_.m_123342_();
        \u00e2\u02dc\u0192 = p_77609_.m_123343_();
        for (\u00e2\u02dc\u0192 = -1; \u00e2\u02dc\u0192 <= 1; ++\u00e2\u02dc\u0192) {
            for (\u00e2\u02dc\u0192 = -1; \u00e2\u02dc\u0192 <= 1; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = -1; \u00e2\u02dc\u0192 <= 1; ++\u00e2\u02dc\u0192) {
                    if (\u00e2\u02dc\u0192 == 0 && \u00e2\u02dc\u0192 == 0) continue;
                    p_77609_.m_122178_(n + \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192);
                    BlockState blockState = p_77608_.m_8055_(p_77609_);
                    if (blockState.m_60713_(Blocks.f_50128_)) {
                        return BlockPathTypes.DANGER_CACTUS;
                    }
                    if (blockState.m_60713_(Blocks.f_50685_)) {
                        return BlockPathTypes.DANGER_OTHER;
                    }
                    if (WalkNodeEvaluator.m_77622_(blockState)) {
                        return BlockPathTypes.DANGER_FIRE;
                    }
                    if (!p_77608_.m_6425_(p_77609_).m_76153_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.WATER_BORDER;
                }
            }
        }
        return p_77610_;
    }

    protected static BlockPathTypes m_77643_(BlockGetter p_77644_, BlockPos p_77645_) {
        BlockState blockState = p_77644_.m_8055_(p_77645_);
        Block \u00e2\u02dc\u01922 = blockState.m_60734_();
        Material \u00e2\u02dc\u01923 = blockState.m_60767_();
        if (blockState.m_60795_()) {
            return BlockPathTypes.OPEN;
        }
        if (blockState.m_60620_(BlockTags.f_13036_) || blockState.m_60713_(Blocks.f_50196_) || blockState.m_60713_(Blocks.f_152545_)) {
            return BlockPathTypes.TRAPDOOR;
        }
        if (blockState.m_60713_(Blocks.f_152499_)) {
            return BlockPathTypes.POWDER_SNOW;
        }
        if (blockState.m_60713_(Blocks.f_50128_)) {
            return BlockPathTypes.DAMAGE_CACTUS;
        }
        if (blockState.m_60713_(Blocks.f_50685_)) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        if (blockState.m_60713_(Blocks.f_50719_)) {
            return BlockPathTypes.STICKY_HONEY;
        }
        if (blockState.m_60713_(Blocks.f_50262_)) {
            return BlockPathTypes.COCOA;
        }
        FluidState \u00e2\u02dc\u01924 = p_77644_.m_6425_(p_77645_);
        if (\u00e2\u02dc\u01924.m_76153_(FluidTags.f_13132_)) {
            return BlockPathTypes.LAVA;
        }
        if (WalkNodeEvaluator.m_77622_(blockState)) {
            return BlockPathTypes.DAMAGE_FIRE;
        }
        if (DoorBlock.m_52817_(blockState) && !blockState.m_61143_(DoorBlock.f_52727_).booleanValue()) {
            return BlockPathTypes.DOOR_WOOD_CLOSED;
        }
        if (\u00e2\u02dc\u01922 instanceof DoorBlock && \u00e2\u02dc\u01923 == Material.f_76279_ && !blockState.m_61143_(DoorBlock.f_52727_).booleanValue()) {
            return BlockPathTypes.DOOR_IRON_CLOSED;
        }
        if (\u00e2\u02dc\u01922 instanceof DoorBlock && blockState.m_61143_(DoorBlock.f_52727_).booleanValue()) {
            return BlockPathTypes.DOOR_OPEN;
        }
        if (\u00e2\u02dc\u01922 instanceof BaseRailBlock) {
            return BlockPathTypes.RAIL;
        }
        if (\u00e2\u02dc\u01922 instanceof LeavesBlock) {
            return BlockPathTypes.LEAVES;
        }
        if (blockState.m_60620_(BlockTags.f_13039_) || blockState.m_60620_(BlockTags.f_13032_) || \u00e2\u02dc\u01922 instanceof FenceGateBlock && !blockState.m_61143_(FenceGateBlock.f_53341_).booleanValue()) {
            return BlockPathTypes.FENCE;
        }
        if (!blockState.m_60647_(p_77644_, p_77645_, PathComputationType.LAND)) {
            return BlockPathTypes.BLOCKED;
        }
        if (\u00e2\u02dc\u01924.m_76153_(FluidTags.f_13131_)) {
            return BlockPathTypes.WATER;
        }
        return BlockPathTypes.OPEN;
    }

    public static boolean m_77622_(BlockState p_77623_) {
        return p_77623_.m_60620_(BlockTags.f_13076_) || p_77623_.m_60713_(Blocks.f_49991_) || p_77623_.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_(p_77623_) || p_77623_.m_60713_(Blocks.f_152477_);
    }
}

