/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapItemSavedData
extends SavedData {
    private static final Logger f_77895_ = LogManager.getLogger();
    private static final int f_164765_ = 128;
    private static final int f_164766_ = 64;
    public static final int f_164764_ = 4;
    public static final int f_181307_ = 256;
    public final int f_77885_;
    public final int f_77886_;
    public final ResourceKey<Level> f_77887_;
    private final boolean f_77888_;
    private final boolean f_77889_;
    public final byte f_77890_;
    public byte[] f_77891_ = new byte[16384];
    public final boolean f_77892_;
    private final List<HoldingPlayer> f_77893_ = Lists.newArrayList();
    private final Map<Player, HoldingPlayer> f_77896_ = Maps.newHashMap();
    private final Map<String, MapBanner> f_77897_ = Maps.newHashMap();
    final Map<String, MapDecoration> f_77894_ = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> f_77898_ = Maps.newHashMap();
    private int f_181308_;

    private MapItemSavedData(int p_164768_, int p_164769_, byte p_164770_, boolean p_164771_, boolean p_164772_, boolean p_164773_, ResourceKey<Level> p_164774_) {
        this.f_77890_ = p_164770_;
        this.f_77885_ = p_164768_;
        this.f_77886_ = p_164769_;
        this.f_77887_ = p_164774_;
        this.f_77888_ = p_164771_;
        this.f_77889_ = p_164772_;
        this.f_77892_ = p_164773_;
        this.m_77762_();
    }

    public static MapItemSavedData m_164780_(double p_164781_, double p_164782_, byte p_164783_, boolean p_164784_, boolean p_164785_, ResourceKey<Level> p_164786_) {
        int n = 128 * (1 << p_164783_);
        \u00e2\u02dc\u0192 = Mth.m_14107_((p_164781_ + 64.0) / (double)n);
        \u00e2\u02dc\u0192 = Mth.m_14107_((p_164782_ + 64.0) / (double)n);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * n + n / 2 - 64;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * n + n / 2 - 64;
        return new MapItemSavedData(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, p_164783_, p_164784_, p_164785_, false, p_164786_);
    }

    public static MapItemSavedData m_164776_(byte p_164777_, boolean p_164778_, ResourceKey<Level> p_164779_) {
        return new MapItemSavedData(0, 0, p_164777_, false, false, p_164778_, p_164779_);
    }

    public static MapItemSavedData m_164807_(CompoundTag p_164808_) {
        ResourceKey resourceKey = (ResourceKey)DimensionType.m_63911_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_164808_.m_128423_("dimension"))).resultOrPartial(arg_0 -> ((Logger)f_77895_).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid map dimension: " + p_164808_.m_128423_("dimension")));
        int \u00e2\u02dc\u01922 = p_164808_.m_128451_("xCenter");
        int \u00e2\u02dc\u01923 = p_164808_.m_128451_("zCenter");
        byte \u00e2\u02dc\u01924 = (byte)Mth.m_14045_(p_164808_.m_128445_("scale"), 0, 4);
        boolean \u00e2\u02dc\u01925 = !p_164808_.m_128425_("trackingPosition", 1) || p_164808_.m_128471_("trackingPosition");
        boolean \u00e2\u02dc\u01926 = p_164808_.m_128471_("unlimitedTracking");
        boolean \u00e2\u02dc\u01927 = p_164808_.m_128471_("locked");
        MapItemSavedData \u00e2\u02dc\u01928 = new MapItemSavedData(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926, \u00e2\u02dc\u01927, resourceKey);
        byte[] \u00e2\u02dc\u01929 = p_164808_.m_128463_("colors");
        if (\u00e2\u02dc\u01929.length == 16384) {
            \u00e2\u02dc\u01928.f_77891_ = \u00e2\u02dc\u01929;
        }
        ListTag \u00e2\u02dc\u019210 = p_164808_.m_128437_("banners", 10);
        for (int i = 0; i < \u00e2\u02dc\u019210.size(); ++i) {
            MapBanner mapBanner = MapBanner.m_77777_(\u00e2\u02dc\u019210.m_128728_(i));
            \u00e2\u02dc\u01928.f_77897_.put(mapBanner.m_77787_(), mapBanner);
            \u00e2\u02dc\u01928.m_77937_(mapBanner.m_77782_(), null, mapBanner.m_77787_(), mapBanner.m_77773_().m_123341_(), mapBanner.m_77773_().m_123343_(), 180.0, mapBanner.m_77783_());
        }
        ListTag listTag = p_164808_.m_128437_("frames", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            MapFrame mapFrame = MapFrame.m_77872_(listTag.m_128728_(i));
            \u00e2\u02dc\u01928.f_77898_.put(mapFrame.m_77877_(), mapFrame);
            \u00e2\u02dc\u01928.m_77937_(MapDecoration.Type.FRAME, null, "frame-" + mapFrame.m_77876_(), mapFrame.m_77874_().m_123341_(), mapFrame.m_77874_().m_123343_(), mapFrame.m_77875_(), null);
        }
        return \u00e2\u02dc\u01928;
    }

    @Override
    public CompoundTag m_7176_(CompoundTag p_77956_) {
        ListTag listTag;
        ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.f_77887_.m_135782_()).resultOrPartial(arg_0 -> ((Logger)f_77895_).error(arg_0)).ifPresent(p_77954_ -> p_77956_.m_128365_("dimension", (Tag)p_77954_));
        p_77956_.m_128405_("xCenter", this.f_77885_);
        p_77956_.m_128405_("zCenter", this.f_77886_);
        p_77956_.m_128344_("scale", this.f_77890_);
        p_77956_.m_128382_("colors", this.f_77891_);
        p_77956_.m_128379_("trackingPosition", this.f_77888_);
        p_77956_.m_128379_("unlimitedTracking", this.f_77889_);
        p_77956_.m_128379_("locked", this.f_77892_);
        ListTag listTag2 = new ListTag();
        for (MapBanner mapBanner : this.f_77897_.values()) {
            listTag2.add(mapBanner.m_77784_());
        }
        p_77956_.m_128365_("banners", listTag2);
        listTag = new ListTag();
        for (MapFrame mapFrame : this.f_77898_.values()) {
            listTag.add(mapFrame.m_77869_());
        }
        p_77956_.m_128365_("frames", listTag);
        return p_77956_;
    }

    public MapItemSavedData m_164775_() {
        MapItemSavedData mapItemSavedData = new MapItemSavedData(this.f_77885_, this.f_77886_, this.f_77890_, this.f_77888_, this.f_77889_, true, this.f_77887_);
        mapItemSavedData.f_77897_.putAll(this.f_77897_);
        mapItemSavedData.f_77894_.putAll(this.f_77894_);
        mapItemSavedData.f_181308_ = this.f_181308_;
        System.arraycopy(this.f_77891_, 0, mapItemSavedData.f_77891_, 0, this.f_77891_.length);
        mapItemSavedData.m_77762_();
        return mapItemSavedData;
    }

    public MapItemSavedData m_164787_(int p_164788_) {
        return MapItemSavedData.m_164780_(this.f_77885_, this.f_77886_, (byte)Mth.m_14045_(this.f_77890_ + p_164788_, 0, 4), this.f_77888_, this.f_77889_, this.f_77887_);
    }

    public void m_77918_(Player p_77919_, ItemStack p_77920_) {
        Object \u00e2\u02dc\u01924;
        Object \u00e2\u02dc\u01922;
        if (!this.f_77896_.containsKey(p_77919_)) {
            HoldingPlayer holdingPlayer = new HoldingPlayer(p_77919_);
            this.f_77896_.put(p_77919_, holdingPlayer);
            this.f_77893_.add(holdingPlayer);
        }
        if (!p_77919_.m_150109_().m_36063_(p_77920_)) {
            this.m_164799_(p_77919_.m_7755_().getString());
        }
        for (int i = 0; i < this.f_77893_.size(); ++i) {
            \u00e2\u02dc\u01922 = this.f_77893_.get(i);
            \u00e2\u02dc\u01923 = ((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.m_7755_().getString();
            if (((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.m_146910_() || !((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.m_150109_().m_36063_(p_77920_) && !p_77920_.m_41794_()) {
                this.f_77896_.remove(((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_);
                this.f_77893_.remove(\u00e2\u02dc\u01922);
                this.m_164799_((String)\u00e2\u02dc\u01923);
                continue;
            }
            if (p_77920_.m_41794_() || ((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.f_19853_.m_46472_() != this.f_77887_ || !this.f_77888_) continue;
            this.m_77937_(MapDecoration.Type.PLAYER, ((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.f_19853_, (String)\u00e2\u02dc\u01923, ((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.m_20185_(), ((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.m_20189_(), ((HoldingPlayer)\u00e2\u02dc\u01922).f_77959_.m_146908_(), null);
        }
        if (p_77920_.m_41794_() && this.f_77888_) {
            ItemFrame itemFrame = p_77920_.m_41795_();
            \u00e2\u02dc\u01922 = itemFrame.m_31748_();
            Object \u00e2\u02dc\u01923 = this.f_77898_.get(MapFrame.m_77870_((BlockPos)\u00e2\u02dc\u01922));
            if (\u00e2\u02dc\u01923 != null && itemFrame.m_142049_() != ((MapFrame)\u00e2\u02dc\u01923).m_77876_() && this.f_77898_.containsKey(((MapFrame)\u00e2\u02dc\u01923).m_77877_())) {
                this.m_164799_("frame-" + ((MapFrame)\u00e2\u02dc\u01923).m_77876_());
            }
            \u00e2\u02dc\u01924 = new MapFrame((BlockPos)\u00e2\u02dc\u01922, itemFrame.m_6350_().m_122416_() * 90, itemFrame.m_142049_());
            this.m_77937_(MapDecoration.Type.FRAME, p_77919_.f_19853_, "frame-" + itemFrame.m_142049_(), ((Vec3i)\u00e2\u02dc\u01922).m_123341_(), ((Vec3i)\u00e2\u02dc\u01922).m_123343_(), itemFrame.m_6350_().m_122416_() * 90, null);
            this.f_77898_.put(((MapFrame)\u00e2\u02dc\u01924).m_77877_(), (MapFrame)\u00e2\u02dc\u01924);
        }
        if ((\u00e2\u02dc\u0192 = p_77920_.m_41783_()) != null && \u00e2\u02dc\u0192.m_128425_("Decorations", 9)) {
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.m_128437_("Decorations", 10);
            for (int i = 0; i < ((ListTag)\u00e2\u02dc\u01922).size(); ++i) {
                \u00e2\u02dc\u01924 = ((ListTag)\u00e2\u02dc\u01922).m_128728_(i);
                if (this.f_77894_.containsKey(((CompoundTag)\u00e2\u02dc\u01924).m_128461_("id"))) continue;
                this.m_77937_(MapDecoration.Type.m_77854_(((CompoundTag)\u00e2\u02dc\u01924).m_128445_("type")), p_77919_.f_19853_, ((CompoundTag)\u00e2\u02dc\u01924).m_128461_("id"), ((CompoundTag)\u00e2\u02dc\u01924).m_128459_("x"), ((CompoundTag)\u00e2\u02dc\u01924).m_128459_("z"), ((CompoundTag)\u00e2\u02dc\u01924).m_128459_("rot"), null);
            }
        }
    }

    private void m_164799_(String p_164800_) {
        MapDecoration mapDecoration = this.f_77894_.remove(p_164800_);
        if (mapDecoration != null && mapDecoration.m_77803_().m_181306_()) {
            --this.f_181308_;
        }
        this.m_164812_();
    }

    public static void m_77925_(ItemStack p_77926_, BlockPos p_77927_, String p_77928_, MapDecoration.Type p_77929_) {
        if (p_77926_.m_41782_() && p_77926_.m_41783_().m_128425_("Decorations", 9)) {
            \u00e2\u02dc\u0192 = p_77926_.m_41783_().m_128437_("Decorations", 10);
        } else {
            \u00e2\u02dc\u0192 = new ListTag();
            p_77926_.m_41700_("Decorations", \u00e2\u02dc\u0192);
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128344_("type", p_77929_.m_77853_());
        compoundTag.m_128359_("id", p_77928_);
        compoundTag.m_128347_("x", p_77927_.m_123341_());
        compoundTag.m_128347_("z", p_77927_.m_123343_());
        compoundTag.m_128347_("rot", 180.0);
        \u00e2\u02dc\u0192.add(compoundTag);
        if (p_77929_.m_77857_()) {
            \u00e2\u02dc\u0192 = p_77926_.m_41698_("display");
            \u00e2\u02dc\u0192.m_128405_("MapColor", p_77929_.m_77858_());
        }
    }

    private void m_77937_(MapDecoration.Type p_77938_, @Nullable LevelAccessor p_77939_, String p_77940_, double p_77941_, double p_77942_, double p_77943_, @Nullable Component p_77944_) {
        byte \u00e2\u02dc\u01926;
        int n = 1 << this.f_77890_;
        float \u00e2\u02dc\u01922 = (float)(p_77941_ - (double)this.f_77885_) / (float)n;
        float \u00e2\u02dc\u01923 = (float)(p_77942_ - (double)this.f_77886_) / (float)n;
        byte \u00e2\u02dc\u01924 = (byte)((double)(\u00e2\u02dc\u01922 * 2.0f) + 0.5);
        byte \u00e2\u02dc\u01925 = (byte)((double)(\u00e2\u02dc\u01923 * 2.0f) + 0.5);
        \u00e2\u02dc\u0192 = 63;
        if (\u00e2\u02dc\u01922 >= -63.0f && \u00e2\u02dc\u01923 >= -63.0f && \u00e2\u02dc\u01922 <= 63.0f && \u00e2\u02dc\u01923 <= 63.0f) {
            \u00e2\u02dc\u01926 = (byte)((p_77943_ += p_77943_ < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.f_77887_ == Level.f_46429_ && p_77939_ != null) {
                int n2 = (int)(p_77939_.m_6106_().m_6792_() / 10L);
                \u00e2\u02dc\u01926 = (byte)(n2 * n2 * 34187121 + n2 * 121 >> 15 & 0xF);
            }
        } else if (p_77938_ == MapDecoration.Type.PLAYER) {
            n2 = 320;
            if (Math.abs(\u00e2\u02dc\u01922) < 320.0f && Math.abs(\u00e2\u02dc\u01923) < 320.0f) {
                p_77938_ = MapDecoration.Type.PLAYER_OFF_MAP;
            } else if (this.f_77889_) {
                p_77938_ = MapDecoration.Type.PLAYER_OFF_LIMITS;
            } else {
                this.m_164799_(p_77940_);
                return;
            }
            \u00e2\u02dc\u01926 = 0;
            if (\u00e2\u02dc\u01922 <= -63.0f) {
                \u00e2\u02dc\u01924 = -128;
            }
            if (\u00e2\u02dc\u01923 <= -63.0f) {
                \u00e2\u02dc\u01925 = -128;
            }
            if (\u00e2\u02dc\u01922 >= 63.0f) {
                \u00e2\u02dc\u01924 = 127;
            }
            if (\u00e2\u02dc\u01923 >= 63.0f) {
                \u00e2\u02dc\u01925 = 127;
            }
        } else {
            this.m_164799_(p_77940_);
            return;
        }
        if (!(\u00e2\u02dc\u0192 = new MapDecoration(p_77938_, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926, p_77944_)).equals(\u00e2\u02dc\u0192 = this.f_77894_.put(p_77940_, \u00e2\u02dc\u0192))) {
            if (\u00e2\u02dc\u0192 != null && \u00e2\u02dc\u0192.m_77803_().m_181306_()) {
                --this.f_181308_;
            }
            if (p_77938_.m_181306_()) {
                ++this.f_181308_;
            }
            this.m_164812_();
        }
    }

    @Nullable
    public Packet<?> m_164796_(int p_164797_, Player p_164798_) {
        HoldingPlayer holdingPlayer = this.f_77896_.get(p_164798_);
        if (holdingPlayer == null) {
            return null;
        }
        return holdingPlayer.m_164815_(p_164797_);
    }

    private void m_164789_(int p_164790_, int p_164791_) {
        this.m_77762_();
        for (HoldingPlayer holdingPlayer : this.f_77893_) {
            holdingPlayer.m_164817_(p_164790_, p_164791_);
        }
    }

    private void m_164812_() {
        this.m_77762_();
        this.f_77893_.forEach(HoldingPlayer::m_164820_);
    }

    public HoldingPlayer m_77916_(Player p_77917_) {
        HoldingPlayer holdingPlayer = this.f_77896_.get(p_77917_);
        if (holdingPlayer == null) {
            holdingPlayer = new HoldingPlayer(p_77917_);
            this.f_77896_.put(p_77917_, holdingPlayer);
            this.f_77893_.add(holdingPlayer);
        }
        return holdingPlayer;
    }

    public boolean m_77934_(LevelAccessor p_77935_, BlockPos p_77936_) {
        double d = (double)p_77936_.m_123341_() + 0.5;
        \u00e2\u02dc\u0192 = (double)p_77936_.m_123343_() + 0.5;
        int \u00e2\u02dc\u01922 = 1 << this.f_77890_;
        \u00e2\u02dc\u0192 = (d - (double)this.f_77885_) / (double)\u00e2\u02dc\u01922;
        \u00e2\u02dc\u0192 = (\u00e2\u02dc\u0192 - (double)this.f_77886_) / (double)\u00e2\u02dc\u01922;
        int \u00e2\u02dc\u01923 = 63;
        if (\u00e2\u02dc\u0192 >= -63.0 && \u00e2\u02dc\u0192 >= -63.0 && \u00e2\u02dc\u0192 <= 63.0 && \u00e2\u02dc\u0192 <= 63.0) {
            MapBanner mapBanner = MapBanner.m_77774_(p_77935_, p_77936_);
            if (mapBanner == null) {
                return false;
            }
            if (this.f_77897_.remove(mapBanner.m_77787_(), mapBanner)) {
                this.m_164799_(mapBanner.m_77787_());
                return true;
            }
            if (!this.m_181312_(256)) {
                this.f_77897_.put(mapBanner.m_77787_(), mapBanner);
                this.m_77937_(mapBanner.m_77782_(), p_77935_, mapBanner.m_77787_(), d, \u00e2\u02dc\u0192, 180.0, mapBanner.m_77783_());
                return true;
            }
        }
        return false;
    }

    public void m_77930_(BlockGetter p_77931_, int p_77932_, int p_77933_) {
        Iterator<MapBanner> iterator = this.f_77897_.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapBanner = iterator.next();
            if (mapBanner.m_77773_().m_123341_() != p_77932_ || mapBanner.m_77773_().m_123343_() != p_77933_ || mapBanner.equals(\u00e2\u02dc\u0192 = MapBanner.m_77774_(p_77931_, mapBanner.m_77773_()))) continue;
            iterator.remove();
            this.m_164799_(mapBanner.m_77787_());
        }
    }

    public Collection<MapBanner> m_164809_() {
        return this.f_77897_.values();
    }

    public void m_77947_(BlockPos p_77948_, int p_77949_) {
        this.m_164799_("frame-" + p_77949_);
        this.f_77898_.remove(MapFrame.m_77870_(p_77948_));
    }

    public boolean m_164792_(int p_164793_, int p_164794_, byte p_164795_) {
        byte by = this.f_77891_[p_164793_ + p_164794_ * 128];
        if (by != p_164795_) {
            this.m_164803_(p_164793_, p_164794_, p_164795_);
            return true;
        }
        return false;
    }

    public void m_164803_(int p_164804_, int p_164805_, byte p_164806_) {
        this.f_77891_[p_164804_ + p_164805_ * 128] = p_164806_;
        this.m_164789_(p_164804_, p_164805_);
    }

    public boolean m_164810_() {
        for (MapDecoration mapDecoration : this.f_77894_.values()) {
            if (mapDecoration.m_77803_() != MapDecoration.Type.MANSION && mapDecoration.m_77803_() != MapDecoration.Type.MONUMENT) continue;
            return true;
        }
        return false;
    }

    public void m_164801_(List<MapDecoration> p_164802_) {
        this.f_77894_.clear();
        this.f_181308_ = 0;
        for (int i = 0; i < p_164802_.size(); ++i) {
            MapDecoration mapDecoration = p_164802_.get(i);
            this.f_77894_.put("icon-" + i, mapDecoration);
            if (!mapDecoration.m_77803_().m_181306_()) continue;
            ++this.f_181308_;
        }
    }

    public Iterable<MapDecoration> m_164811_() {
        return this.f_77894_.values();
    }

    public boolean m_181312_(int p_181313_) {
        return this.f_181308_ >= p_181313_;
    }

    public class HoldingPlayer {
        public final Player f_77959_;
        private boolean f_77962_ = true;
        private int f_77963_;
        private int f_77964_;
        private int f_77965_ = 127;
        private int f_77966_ = 127;
        private boolean f_164813_ = true;
        private int f_77967_;
        public int f_77960_;

        HoldingPlayer(Player p_77970_) {
            this.f_77959_ = p_77970_;
        }

        private MapPatch m_164814_() {
            int n = this.f_77963_;
            \u00e2\u02dc\u0192 = this.f_77964_;
            \u00e2\u02dc\u0192 = this.f_77965_ + 1 - this.f_77963_;
            \u00e2\u02dc\u0192 = this.f_77966_ + 1 - this.f_77964_;
            byte[] \u00e2\u02dc\u01922 = new byte[\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192];
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u01922[\u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192] = MapItemSavedData.this.f_77891_[n + \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 + \u00e2\u02dc\u0192) * 128];
                }
            }
            return new MapPatch(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u01922);
        }

        @Nullable
        Packet<?> m_164815_(int p_164816_) {
            Collection<MapDecoration> collection;
            if (this.f_77962_) {
                this.f_77962_ = false;
                \u00e2\u02dc\u0192 = this.m_164814_();
            } else {
                \u00e2\u02dc\u0192 = null;
            }
            if (this.f_164813_ && this.f_77967_++ % 5 == 0) {
                this.f_164813_ = false;
                collection = MapItemSavedData.this.f_77894_.values();
            } else {
                collection = null;
            }
            if (collection != null || \u00e2\u02dc\u0192 != null) {
                return new ClientboundMapItemDataPacket(p_164816_, MapItemSavedData.this.f_77890_, MapItemSavedData.this.f_77892_, collection, \u00e2\u02dc\u0192);
            }
            return null;
        }

        void m_164817_(int p_164818_, int p_164819_) {
            if (this.f_77962_) {
                this.f_77963_ = Math.min(this.f_77963_, p_164818_);
                this.f_77964_ = Math.min(this.f_77964_, p_164819_);
                this.f_77965_ = Math.max(this.f_77965_, p_164818_);
                this.f_77966_ = Math.max(this.f_77966_, p_164819_);
            } else {
                this.f_77962_ = true;
                this.f_77963_ = p_164818_;
                this.f_77964_ = p_164819_;
                this.f_77965_ = p_164818_;
                this.f_77966_ = p_164819_;
            }
        }

        private void m_164820_() {
            this.f_164813_ = true;
        }
    }

    public static class MapPatch {
        public final int f_164821_;
        public final int f_164822_;
        public final int f_164823_;
        public final int f_164824_;
        public final byte[] f_164825_;

        public MapPatch(int p_164827_, int p_164828_, int p_164829_, int p_164830_, byte[] p_164831_) {
            this.f_164821_ = p_164827_;
            this.f_164822_ = p_164828_;
            this.f_164823_ = p_164829_;
            this.f_164824_ = p_164830_;
            this.f_164825_ = p_164831_;
        }

        public void m_164832_(MapItemSavedData p_164833_) {
            for (int i = 0; i < this.f_164823_; ++i) {
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < this.f_164824_; ++\u00e2\u02dc\u0192) {
                    p_164833_.m_164803_(this.f_164821_ + i, this.f_164822_ + \u00e2\u02dc\u0192, this.f_164825_[i + \u00e2\u02dc\u0192 * this.f_164823_]);
                }
            }
        }
    }
}

