/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionDataStorage {
    private static final Logger f_78143_ = LogManager.getLogger();
    private final Map<String, SavedData> f_78144_ = Maps.newHashMap();
    private final DataFixer f_78145_;
    private final File f_78146_;

    public DimensionDataStorage(File p_78149_, DataFixer p_78150_) {
        this.f_78145_ = p_78150_;
        this.f_78146_ = p_78149_;
    }

    private File m_78156_(String p_78157_) {
        return new File(this.f_78146_, p_78157_ + ".dat");
    }

    public <T extends SavedData> T m_164861_(Function<CompoundTag, T> p_164862_, Supplier<T> p_164863_, String p_164864_) {
        T t = this.m_164858_(p_164862_, p_164864_);
        if (t != null) {
            return t;
        }
        SavedData \u00e2\u02dc\u01922 = (SavedData)p_164863_.get();
        this.m_164855_(p_164864_, \u00e2\u02dc\u01922);
        return (T)\u00e2\u02dc\u01922;
    }

    @Nullable
    public <T extends SavedData> T m_164858_(Function<CompoundTag, T> p_164859_, String p_164860_) {
        SavedData savedData = this.f_78144_.get(p_164860_);
        if (savedData == null && !this.f_78144_.containsKey(p_164860_)) {
            savedData = this.m_164868_(p_164859_, p_164860_);
            this.f_78144_.put(p_164860_, savedData);
        }
        return (T)savedData;
    }

    @Nullable
    private <T extends SavedData> T m_164868_(Function<CompoundTag, T> p_164869_, String p_164870_) {
        try {
            File file = this.m_78156_(p_164870_);
            if (file.exists()) {
                CompoundTag compoundTag = this.m_78158_(p_164870_, SharedConstants.m_136187_().getWorldVersion());
                return (T)((SavedData)p_164869_.apply(compoundTag.m_128469_("data")));
            }
        }
        catch (Exception exception) {
            f_78143_.error("Error loading saved data: {}", (Object)p_164870_, (Object)exception);
        }
        return null;
    }

    public void m_164855_(String p_164856_, SavedData p_164857_) {
        this.f_78144_.put(p_164856_, p_164857_);
    }

    public CompoundTag m_78158_(String p_78159_, int p_78160_) throws IOException {
        File file = this.m_78156_(p_78159_);
        try (FileInputStream \u00e2\u02dc\u01922 = new FileInputStream(file);){
            CompoundTag compoundTag;
            try (PushbackInputStream pushbackInputStream = new PushbackInputStream(\u00e2\u02dc\u01922, 2);){
                CompoundTag compoundTag2;
                if (this.m_78154_(pushbackInputStream)) {
                    compoundTag2 = NbtIo.m_128939_(pushbackInputStream);
                } else {
                    try (DataInputStream \u00e2\u02dc\u01923 = new DataInputStream(pushbackInputStream);){
                        compoundTag2 = NbtIo.m_128928_(\u00e2\u02dc\u01923);
                    }
                }
                int \u00e2\u02dc\u01924 = compoundTag2.m_128425_("DataVersion", 99) ? compoundTag2.m_128451_("DataVersion") : 1343;
                compoundTag = NbtUtils.m_129218_(this.f_78145_, DataFixTypes.SAVED_DATA, compoundTag2, \u00e2\u02dc\u01924, p_78160_);
            }
            return compoundTag;
        }
    }

    private boolean m_78154_(PushbackInputStream p_78155_) throws IOException {
        byte[] byArray = new byte[2];
        boolean \u00e2\u02dc\u01922 = false;
        int \u00e2\u02dc\u01923 = p_78155_.read(byArray, 0, 2);
        if (\u00e2\u02dc\u01923 == 2 && (\u00e2\u02dc\u0192 = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF) == 35615) {
            \u00e2\u02dc\u01922 = true;
        }
        if (\u00e2\u02dc\u01923 != 0) {
            p_78155_.unread(byArray, 0, \u00e2\u02dc\u01923);
        }
        return \u00e2\u02dc\u01922;
    }

    public void m_78151_() {
        this.f_78144_.forEach((p_164866_, p_164867_) -> {
            if (p_164867_ != null) {
                p_164867_.m_77757_(this.m_78156_((String)p_164866_));
            }
        });
    }
}

