/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.McRegionUpgrader;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogManager.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String f_164908_ = "icon.png";
    private static final ImmutableList<String> f_78193_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;

    public LevelStorageSource(Path p_78199_, Path p_78200_, DataFixer p_78201_) {
        this.f_78196_ = p_78201_;
        try {
            Files.createDirectories(Files.exists(p_78199_, new LinkOption[0]) ? p_78199_.toRealPath(new LinkOption[0]) : p_78199_, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.f_78194_ = p_78199_;
        this.f_78195_ = p_78200_;
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), DataFixers.m_14512_());
    }

    private static <T> Pair<WorldGenSettings, Lifecycle> m_78204_(Dynamic<T> p_78205_, DataFixer p_78206_, int p_78207_) {
        String \u00e2\u02dc\u019232;
        Dynamic \u00e2\u02dc\u01922 = p_78205_.get("WorldGenSettings").orElseEmptyMap();
        for (String \u00e2\u02dc\u019232 : f_78193_) {
            Optional optional = p_78205_.get(\u00e2\u02dc\u019232).result();
            if (!optional.isPresent()) continue;
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.set(\u00e2\u02dc\u019232, (Dynamic)optional.get());
        }
        Dynamic dynamic = p_78206_.update(References.f_16795_, \u00e2\u02dc\u01922, p_78207_, SharedConstants.m_136187_().getWorldVersion());
        \u00e2\u02dc\u019232 = WorldGenSettings.f_64600_.parse(dynamic);
        return Pair.of((Object)\u00e2\u02dc\u019232.resultOrPartial(Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseGet(() -> {
            Registry registry = (Registry)RegistryLookupCodec.m_135622_(Registry.f_122818_).codec().parse(dynamic).resultOrPartial(Util.m_137489_("Dimension type registry: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get dimension registry"));
            \u00e2\u02dc\u0192 = (Registry)RegistryLookupCodec.m_135622_(Registry.f_122885_).codec().parse(dynamic).resultOrPartial(Util.m_137489_("Biome registry: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get biome registry"));
            \u00e2\u02dc\u0192 = (Registry)RegistryLookupCodec.m_135622_(Registry.f_122878_).codec().parse(dynamic).resultOrPartial(Util.m_137489_("Noise settings registry: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get noise settings registry"));
            return WorldGenSettings.m_64641_(registry, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }), (Object)\u00e2\u02dc\u019232.lifecycle());
    }

    private static DataPackConfig m_78202_(Dynamic<?> p_78203_) {
        return DataPackConfig.f_45843_.parse(p_78203_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(DataPackConfig.f_45842_);
    }

    public String m_164909_() {
        return "Anvil";
    }

    public List<LevelSummary> m_78244_() throws LevelStorageException {
        if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
            throw new LevelStorageException(new TranslatableComponent("selectWorld.load_folder_access").getString());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (File file : \u00e2\u02dc\u0192 = this.f_78194_.toFile().listFiles()) {
            if (!file.isDirectory()) continue;
            try {
                boolean bl = DirectoryLock.m_13642_(file.toPath());
            }
            catch (Exception exception) {
                f_78191_.warn("Failed to read {} lock", (Object)file, (Object)exception);
                continue;
            }
            try {
                LevelSummary levelSummary = this.m_78229_(file, this.m_78232_(file, bl));
                if (levelSummary == null) continue;
                arrayList.add(levelSummary);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                MemoryReserve.m_182328_();
                System.gc();
                f_78191_.fatal("Ran out of memory trying to read summary of {}", (Object)file);
                throw outOfMemoryError;
            }
        }
        return arrayList;
    }

    int m_78265_() {
        return 19133;
    }

    @Nullable
    <T> T m_78229_(File p_78230_, BiFunction<File, DataFixer, T> p_78231_) {
        if (!p_78230_.exists()) {
            return null;
        }
        File file = new File(p_78230_, "level.dat");
        if (file.exists() && (\u00e2\u02dc\u0192 = p_78231_.apply(file, this.f_78196_)) != null) {
            return \u00e2\u02dc\u0192;
        }
        file = new File(p_78230_, "level.dat_old");
        if (file.exists()) {
            return p_78231_.apply(file, this.f_78196_);
        }
        return null;
    }

    @Nullable
    private static DataPackConfig m_78252_(File p_78253_, DataFixer p_78254_) {
        try {
            CompoundTag compoundTag = NbtIo.m_128937_(p_78253_);
            \u00e2\u02dc\u0192 = compoundTag.m_128469_("Data");
            \u00e2\u02dc\u0192.m_128473_("Player");
            int \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.m_128425_("DataVersion", 99) ? \u00e2\u02dc\u0192.m_128451_("DataVersion") : -1;
            Dynamic \u00e2\u02dc\u01923 = p_78254_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)\u00e2\u02dc\u0192), \u00e2\u02dc\u01922, SharedConstants.m_136187_().getWorldVersion());
            return \u00e2\u02dc\u01923.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
        }
        catch (Exception exception) {
            f_78191_.error("Exception reading {}", (Object)p_78253_, (Object)exception);
            return null;
        }
    }

    static BiFunction<File, DataFixer, PrimaryLevelData> m_78247_(DynamicOps<Tag> p_78248_, DataPackConfig p_78249_) {
        return (p_78214_, p_78215_) -> {
            try {
                CompoundTag compoundTag = NbtIo.m_128937_(p_78214_);
                \u00e2\u02dc\u0192 = compoundTag.m_128469_("Data");
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_128425_("Player", 10) ? \u00e2\u02dc\u0192.m_128469_("Player") : null;
                \u00e2\u02dc\u0192.m_128473_("Player");
                int \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.m_128425_("DataVersion", 99) ? \u00e2\u02dc\u0192.m_128451_("DataVersion") : -1;
                Dynamic \u00e2\u02dc\u01923 = p_78215_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic(p_78248_, (Object)\u00e2\u02dc\u0192), \u00e2\u02dc\u01922, SharedConstants.m_136187_().getWorldVersion());
                Pair<WorldGenSettings, Lifecycle> \u00e2\u02dc\u01924 = LevelStorageSource.m_78204_(\u00e2\u02dc\u01923, p_78215_, \u00e2\u02dc\u01922);
                LevelVersion \u00e2\u02dc\u01925 = LevelVersion.m_78390_(\u00e2\u02dc\u01923);
                LevelSettings \u00e2\u02dc\u01926 = LevelSettings.m_46924_(\u00e2\u02dc\u01923, p_78249_);
                return PrimaryLevelData.m_78530_((Dynamic<Tag>)\u00e2\u02dc\u01923, p_78215_, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192, \u00e2\u02dc\u01926, \u00e2\u02dc\u01925, (WorldGenSettings)\u00e2\u02dc\u01924.getFirst(), (Lifecycle)\u00e2\u02dc\u01924.getSecond());
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", p_78214_, (Object)exception);
                return null;
            }
        };
    }

    BiFunction<File, DataFixer, LevelSummary> m_78232_(File p_78233_, boolean p_78234_) {
        return (p_78238_, p_78239_) -> {
            try {
                CompoundTag compoundTag = NbtIo.m_128937_(p_78238_);
                \u00e2\u02dc\u0192 = compoundTag.m_128469_("Data");
                \u00e2\u02dc\u0192.m_128473_("Player");
                int \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.m_128425_("DataVersion", 99) ? \u00e2\u02dc\u0192.m_128451_("DataVersion") : -1;
                Dynamic \u00e2\u02dc\u01923 = p_78239_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)\u00e2\u02dc\u0192), \u00e2\u02dc\u01922, SharedConstants.m_136187_().getWorldVersion());
                LevelVersion \u00e2\u02dc\u01924 = LevelVersion.m_78390_(\u00e2\u02dc\u01923);
                int \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_78389_();
                if (\u00e2\u02dc\u01925 == 19132 || \u00e2\u02dc\u01925 == 19133) {
                    boolean bl = \u00e2\u02dc\u01925 != this.m_78265_();
                    File \u00e2\u02dc\u01926 = new File(p_78233_, f_164908_);
                    DataPackConfig \u00e2\u02dc\u01927 = \u00e2\u02dc\u01923.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
                    LevelSettings \u00e2\u02dc\u01928 = LevelSettings.m_46924_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01927);
                    return new LevelSummary(\u00e2\u02dc\u01928, \u00e2\u02dc\u01924, p_78233_.getName(), bl, p_78234_, \u00e2\u02dc\u01926);
                }
                return null;
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", p_78238_, (Object)exception);
                return null;
            }
        };
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path path = this.f_78194_.resolve(p_78241_);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        return Files.isDirectory(this.f_78194_.resolve(p_78256_), new LinkOption[0]);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        return new LevelStorageAccess(p_78261_);
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        final Path f_78271_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();

        public LevelStorageAccess(String p_78276_) throws IOException {
            this.f_78272_ = p_78276_;
            this.f_78271_ = LevelStorageSource.this.f_78194_.resolve(p_78276_);
            this.f_78270_ = DirectoryLock.m_13640_(this.f_78271_);
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, p_78303_ -> this.f_78271_.resolve(p_78303_.m_78187_()));
        }

        public File m_78299_(ResourceKey<Level> p_78300_) {
            return DimensionType.m_63932_(p_78300_, this.f_78271_.toFile());
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        public boolean m_78306_() {
            LevelSummary levelSummary = this.m_78308_();
            return levelSummary != null && levelSummary.m_78371_().m_78389_() != LevelStorageSource.this.m_78265_();
        }

        public boolean m_78278_(ProgressListener p_78279_) {
            this.m_78313_();
            return McRegionUpgrader.m_78400_(this, p_78279_);
        }

        @Nullable
        public LevelSummary m_78308_() {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource.this.m_78232_(this.f_78271_.toFile(), false));
        }

        @Nullable
        public WorldData m_78280_(DynamicOps<Tag> p_78281_, DataPackConfig p_78282_) {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource.m_78247_(p_78281_, p_78282_));
        }

        @Nullable
        public DataPackConfig m_78309_() {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource::m_78252_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            File file = this.f_78271_.toFile();
            CompoundTag \u00e2\u02dc\u01922 = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag \u00e2\u02dc\u01923 = new CompoundTag();
            \u00e2\u02dc\u01923.m_128365_("Data", \u00e2\u02dc\u01922);
            try {
                \u00e2\u02dc\u0192 = File.createTempFile("level", ".dat", file);
                NbtIo.m_128944_(\u00e2\u02dc\u01923, \u00e2\u02dc\u0192);
                \u00e2\u02dc\u0192 = new File(file, "level.dat_old");
                \u00e2\u02dc\u0192 = new File(file, "level.dat");
                Util.m_137462_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
            catch (Exception \u00e2\u02dc\u01924) {
                f_78191_.error("Failed to save level {}", (Object)file, (Object)\u00e2\u02dc\u01924);
            }
        }

        public Optional<Path> m_182514_() {
            if (!this.f_78270_.m_13639_()) {
                return Optional.empty();
            }
            return Optional.of(this.f_78271_.resolve(LevelStorageSource.f_164908_));
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path path = this.f_78271_.resolve("session.lock");
            for (int i = 1; i <= 5; ++i) {
                f_78191_.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.f_78271_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals(path)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_78271_)) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException iOException) {
                    if (i < 5) {
                        f_78191_.warn("Failed to delete {}", (Object)this.f_78271_, (Object)iOException);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw iOException;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            this.m_78313_();
            File file = new File(LevelStorageSource.this.f_78194_.toFile(), this.f_78272_);
            if (!file.exists()) {
                return;
            }
            \u00e2\u02dc\u0192 = new File(file, "level.dat");
            if (\u00e2\u02dc\u0192.exists()) {
                CompoundTag compoundTag = NbtIo.m_128937_(\u00e2\u02dc\u0192);
                \u00e2\u02dc\u0192 = compoundTag.m_128469_("Data");
                \u00e2\u02dc\u0192.m_128359_("LevelName", p_78298_);
                NbtIo.m_128944_(compoundTag, \u00e2\u02dc\u0192);
            }
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String string = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path \u00e2\u02dc\u01922 = LevelStorageSource.this.m_78262_();
            try {
                Files.createDirectories(Files.exists(\u00e2\u02dc\u01922, new LinkOption[0]) ? \u00e2\u02dc\u01922.toRealPath(new LinkOption[0]) : \u00e2\u02dc\u01922, new FileAttribute[0]);
            }
            catch (IOException \u00e2\u02dc\u01923) {
                throw new RuntimeException(\u00e2\u02dc\u01923);
            }
            Path \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.resolve(FileUtil.m_133730_(\u00e2\u02dc\u01922, string, ".zip"));
            try (final ZipOutputStream \u00e2\u02dc\u01925 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(\u00e2\u02dc\u01924, new OpenOption[0])));){
                final Path path = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_78271_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String string = path.resolve(LevelStorageAccess.this.f_78271_.relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry \u00e2\u02dc\u01922 = new ZipEntry(string);
                        \u00e2\u02dc\u01925.putNextEntry(\u00e2\u02dc\u01922);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)\u00e2\u02dc\u01925);
                        \u00e2\u02dc\u01925.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size(\u00e2\u02dc\u01924);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }
    }
}

