/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.bridge.game.GameVersion;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelVersion;
import org.apache.commons.lang3.StringUtils;

public class LevelSummary
implements Comparable<LevelSummary> {
    private final LevelSettings f_78344_;
    private final LevelVersion f_78345_;
    private final String f_78346_;
    private final boolean f_78347_;
    private final boolean f_78348_;
    private final File f_78349_;
    @Nullable
    private Component f_78350_;

    public LevelSummary(LevelSettings p_78352_, LevelVersion p_78353_, String p_78354_, boolean p_78355_, boolean p_78356_, File p_78357_) {
        this.f_78344_ = p_78352_;
        this.f_78345_ = p_78353_;
        this.f_78346_ = p_78354_;
        this.f_78348_ = p_78356_;
        this.f_78349_ = p_78357_;
        this.f_78347_ = p_78355_;
    }

    public String m_78358_() {
        return this.f_78346_;
    }

    public String m_78361_() {
        return StringUtils.isEmpty((CharSequence)this.f_78344_.m_46917_()) ? this.f_78346_ : this.f_78344_.m_46917_();
    }

    public File m_78362_() {
        return this.f_78349_;
    }

    public boolean m_78365_() {
        return this.f_78347_;
    }

    public long m_78366_() {
        return this.f_78345_.m_78392_();
    }

    @Override
    public int compareTo(LevelSummary p_78360_) {
        if (this.f_78345_.m_78392_() < p_78360_.f_78345_.m_78392_()) {
            return 1;
        }
        if (this.f_78345_.m_78392_() > p_78360_.f_78345_.m_78392_()) {
            return -1;
        }
        return this.f_78346_.compareTo(p_78360_.f_78346_);
    }

    public LevelSettings m_164913_() {
        return this.f_78344_;
    }

    public GameType m_78367_() {
        return this.f_78344_.m_46929_();
    }

    public boolean m_78368_() {
        return this.f_78344_.m_46930_();
    }

    public boolean m_78369_() {
        return this.f_78344_.m_46932_();
    }

    public MutableComponent m_78370_() {
        if (StringUtil.m_14408_(this.f_78345_.m_78393_())) {
            return new TranslatableComponent("selectWorld.versionUnknown");
        }
        return new TextComponent(this.f_78345_.m_78393_());
    }

    public LevelVersion m_78371_() {
        return this.f_78345_;
    }

    public boolean m_78372_() {
        return this.m_78373_() || !SharedConstants.m_136187_().isStable() && !this.f_78345_.m_78395_() || this.m_164914_().m_164931_();
    }

    public boolean m_78373_() {
        return this.f_78345_.m_78394_() > SharedConstants.m_136187_().getWorldVersion();
    }

    public BackupStatus m_164914_() {
        GameVersion gameVersion = SharedConstants.m_136187_();
        int \u00e2\u02dc\u01922 = gameVersion.getWorldVersion();
        int \u00e2\u02dc\u01923 = this.f_78345_.m_78394_();
        if (!gameVersion.isStable() && \u00e2\u02dc\u01923 < \u00e2\u02dc\u01922) {
            return BackupStatus.UPGRADE_TO_SNAPSHOT;
        }
        if (\u00e2\u02dc\u01923 > \u00e2\u02dc\u01922) {
            return BackupStatus.DOWNGRADE;
        }
        return BackupStatus.NONE;
    }

    public boolean m_78375_() {
        return this.f_78348_;
    }

    public boolean m_164915_() {
        int n = this.f_78345_.m_78394_();
        boolean \u00e2\u02dc\u01922 = n > 2692 && n <= 2706;
        return false != \u00e2\u02dc\u01922;
    }

    public boolean m_164916_() {
        return this.m_78375_() || this.m_164915_();
    }

    public Component m_78376_() {
        if (this.f_78350_ == null) {
            this.f_78350_ = this.m_78377_();
        }
        return this.f_78350_;
    }

    private Component m_78377_() {
        TranslatableComponent translatableComponent;
        if (this.m_78375_()) {
            return new TranslatableComponent("selectWorld.locked").m_130940_(ChatFormatting.RED);
        }
        if (this.m_164915_()) {
            return new TranslatableComponent("selectWorld.pre_worldheight").m_130940_(ChatFormatting.RED);
        }
        if (this.m_78365_()) {
            return new TranslatableComponent("selectWorld.conversion");
        }
        MutableComponent mutableComponent = translatableComponent = this.m_78368_() ? new TextComponent("").m_7220_(new TranslatableComponent("gameMode.hardcore").m_130940_(ChatFormatting.DARK_RED)) : new TranslatableComponent("gameMode." + this.m_78367_().m_46405_());
        if (this.m_78369_()) {
            translatableComponent.m_130946_(", ").m_7220_(new TranslatableComponent("selectWorld.cheats"));
        }
        MutableComponent \u00e2\u02dc\u01922 = this.m_78370_();
        MutableComponent \u00e2\u02dc\u01923 = new TextComponent(", ").m_7220_(new TranslatableComponent("selectWorld.version")).m_130946_(" ");
        if (this.m_78372_()) {
            \u00e2\u02dc\u01923.m_7220_(\u00e2\u02dc\u01922.m_130940_(this.m_78373_() ? ChatFormatting.RED : ChatFormatting.ITALIC));
        } else {
            \u00e2\u02dc\u01923.m_7220_(\u00e2\u02dc\u01922);
        }
        translatableComponent.m_7220_(\u00e2\u02dc\u01923);
        return translatableComponent;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((LevelSummary)object);
    }

    public static final class BackupStatus
    extends Enum<BackupStatus> {
        public static final /* enum */ BackupStatus NONE = new BackupStatus(false, false, "");
        public static final /* enum */ BackupStatus DOWNGRADE = new BackupStatus(true, true, "downgrade");
        public static final /* enum */ BackupStatus UPGRADE_TO_SNAPSHOT = new BackupStatus(true, false, "snapshot");
        private final boolean f_164920_;
        private final boolean f_164921_;
        private final String f_164922_;
        private static final /* synthetic */ BackupStatus[] $VALUES;

        public static BackupStatus[] values() {
            return (BackupStatus[])$VALUES.clone();
        }

        public static BackupStatus valueOf(String p_164936_) {
            return Enum.valueOf(BackupStatus.class, p_164936_);
        }

        private BackupStatus(boolean p_164928_, boolean p_164929_, String p_164930_) {
            this.f_164920_ = p_164928_;
            this.f_164921_ = p_164929_;
            this.f_164922_ = p_164930_;
        }

        public boolean m_164931_() {
            return this.f_164920_;
        }

        public boolean m_164932_() {
            return this.f_164921_;
        }

        public String m_164933_() {
            return this.f_164922_;
        }

        private static /* synthetic */ BackupStatus[] m_164934_() {
            return new BackupStatus[]{NONE, DOWNGRADE, UPGRADE_TO_SNAPSHOT};
        }

        static {
            $VALUES = BackupStatus.m_164934_();
        }
    }
}

