/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.OverworldBiomeSource;
import net.minecraft.world.level.chunk.storage.OldChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class McRegionUpgrader {
    private static final Logger f_78396_ = LogManager.getLogger();
    private static final String f_164938_ = ".mcr";

    static boolean m_78400_(LevelStorageSource.LevelStorageAccess p_78401_, ProgressListener p_78402_) {
        p_78402_.m_6952_(0);
        ArrayList arrayList = Lists.newArrayList();
        \u00e2\u02dc\u0192 = Lists.newArrayList();
        \u00e2\u02dc\u0192 = Lists.newArrayList();
        File \u00e2\u02dc\u01922 = p_78401_.m_78299_(Level.f_46428_);
        File \u00e2\u02dc\u01923 = p_78401_.m_78299_(Level.f_46429_);
        File \u00e2\u02dc\u01924 = p_78401_.m_78299_(Level.f_46430_);
        f_78396_.info("Scanning folders...");
        McRegionUpgrader.m_78422_(\u00e2\u02dc\u01922, arrayList);
        if (\u00e2\u02dc\u01923.exists()) {
            McRegionUpgrader.m_78422_(\u00e2\u02dc\u01923, \u00e2\u02dc\u0192);
        }
        if (\u00e2\u02dc\u01924.exists()) {
            McRegionUpgrader.m_78422_(\u00e2\u02dc\u01924, \u00e2\u02dc\u0192);
        }
        int \u00e2\u02dc\u01925 = arrayList.size() + \u00e2\u02dc\u0192.size() + \u00e2\u02dc\u0192.size();
        f_78396_.info("Total conversion count is {}", (Object)\u00e2\u02dc\u01925);
        RegistryAccess.RegistryHolder \u00e2\u02dc\u01926 = RegistryAccess.m_123086_();
        RegistryReadOps<Tag> \u00e2\u02dc\u01927 = RegistryReadOps.m_179866_(NbtOps.f_128958_, ResourceManager.Empty.INSTANCE, \u00e2\u02dc\u01926);
        WorldData \u00e2\u02dc\u01928 = p_78401_.m_78280_(\u00e2\u02dc\u01927, DataPackConfig.f_45842_);
        long \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928 != null ? \u00e2\u02dc\u01928.m_5961_().m_64619_() : 0L;
        Registry<Biome> \u00e2\u02dc\u019210 = \u00e2\u02dc\u01926.m_175515_(Registry.f_122885_);
        BiomeSource \u00e2\u02dc\u019211 = \u00e2\u02dc\u01928 != null && \u00e2\u02dc\u01928.m_5961_().m_64669_() ? new FixedBiomeSource(\u00e2\u02dc\u019210.m_123013_(Biomes.f_48202_)) : new OverworldBiomeSource(\u00e2\u02dc\u01929, false, false, \u00e2\u02dc\u019210);
        McRegionUpgrader.m_78411_(\u00e2\u02dc\u01926, new File(\u00e2\u02dc\u01922, "region"), arrayList, \u00e2\u02dc\u019211, 0, \u00e2\u02dc\u01925, p_78402_);
        McRegionUpgrader.m_78411_(\u00e2\u02dc\u01926, new File(\u00e2\u02dc\u01923, "region"), \u00e2\u02dc\u0192, new FixedBiomeSource(\u00e2\u02dc\u019210.m_123013_(Biomes.f_48209_)), arrayList.size(), \u00e2\u02dc\u01925, p_78402_);
        McRegionUpgrader.m_78411_(\u00e2\u02dc\u01926, new File(\u00e2\u02dc\u01924, "region"), \u00e2\u02dc\u0192, new FixedBiomeSource(\u00e2\u02dc\u019210.m_123013_(Biomes.f_48210_)), arrayList.size() + \u00e2\u02dc\u0192.size(), \u00e2\u02dc\u01925, p_78402_);
        McRegionUpgrader.m_78398_(p_78401_);
        p_78401_.m_78287_(\u00e2\u02dc\u01926, \u00e2\u02dc\u01928);
        return true;
    }

    private static void m_78398_(LevelStorageSource.LevelStorageAccess p_78399_) {
        File file = p_78399_.m_78283_(LevelResource.f_78178_).toFile();
        if (!file.exists()) {
            f_78396_.warn("Unable to create level.dat_mcr backup");
            return;
        }
        \u00e2\u02dc\u0192 = new File(file.getParent(), "level.dat_mcr");
        if (!file.renameTo(\u00e2\u02dc\u0192)) {
            f_78396_.warn("Unable to create level.dat_mcr backup");
        }
    }

    private static void m_78411_(RegistryAccess.RegistryHolder p_78412_, File p_78413_, Iterable<File> p_78414_, BiomeSource p_78415_, int p_78416_, int p_78417_, ProgressListener p_78418_) {
        for (File file : p_78414_) {
            McRegionUpgrader.m_78403_(p_78412_, p_78413_, file, p_78415_, p_78416_, p_78417_, p_78418_);
            int n = (int)Math.round(100.0 * (double)(++p_78416_) / (double)p_78417_);
            p_78418_.m_6952_(n);
        }
    }

    private static void m_78403_(RegistryAccess.RegistryHolder p_78404_, File p_78405_, File p_78406_, BiomeSource p_78407_, int p_78408_, int p_78409_, ProgressListener p_78410_) {
        String string = p_78406_.getName();
        try (RegionFile regionFile = new RegionFile(p_78406_, p_78405_, true);){
            regionFile2 = new RegionFile(new File(p_78405_, string.substring(0, string.length() - f_164938_.length()) + ".mca"), p_78405_, true);
            try {
                for (int i = 0; i < 32; ++i) {
                    for (n = 0; n < 32; ++n) {
                        Object object;
                        ChunkPos chunkPos = new ChunkPos(i, n);
                        if (!regionFile.m_63682_(chunkPos) || regionFile2.m_63682_(chunkPos)) continue;
                        try {
                            object = regionFile.m_63645_(chunkPos);
                            try {
                                if (object == null) {
                                    f_78396_.warn("Failed to fetch input stream for chunk {}", (Object)chunkPos);
                                    continue;
                                }
                                CompoundTag compoundTag = NbtIo.m_128928_((DataInput)object);
                            }
                            finally {
                                if (object != null) {
                                    ((FilterInputStream)object).close();
                                }
                            }
                        }
                        catch (IOException iOException) {
                            f_78396_.warn("Failed to read data for chunk {}", (Object)chunkPos, (Object)iOException);
                            continue;
                        }
                        object = compoundTag.m_128469_("Level");
                        OldChunkStorage.OldLevelChunk \u00e2\u02dc\u01922 = OldChunkStorage.m_63591_((CompoundTag)object);
                        CompoundTag \u00e2\u02dc\u01923 = new CompoundTag();
                        CompoundTag \u00e2\u02dc\u01924 = new CompoundTag();
                        \u00e2\u02dc\u01923.m_128365_("Level", \u00e2\u02dc\u01924);
                        OldChunkStorage.m_63586_(p_78404_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924, p_78407_);
                        try (DataOutputStream \u00e2\u02dc\u01925 = regionFile2.m_63678_(chunkPos);){
                            NbtIo.m_128941_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01925);
                            continue;
                        }
                    }
                    int n = (int)Math.round(100.0 * (double)(p_78408_ * 1024) / (double)(p_78409_ * 1024));
                    \u00e2\u02dc\u0192 = (int)Math.round(100.0 * (double)((i + 1) * 32 + p_78408_ * 1024) / (double)(p_78409_ * 1024));
                    if (\u00e2\u02dc\u0192 <= n) continue;
                    p_78410_.m_6952_(\u00e2\u02dc\u0192);
                }
            }
            finally {
                RegionFile regionFile2;
                regionFile2.close();
            }
        }
        catch (IOException iOException) {
            f_78396_.error("Failed to upgrade region file {}", (Object)p_78406_, (Object)iOException);
        }
    }

    private static void m_78422_(File p_78423_, Collection<File> p_78424_) {
        File file = new File(p_78423_, "region");
        File[] \u00e2\u02dc\u01922 = file.listFiles((p_78420_, p_78421_) -> p_78421_.endsWith(f_164938_));
        if (\u00e2\u02dc\u01922 != null) {
            Collections.addAll(p_78424_, \u00e2\u02dc\u01922);
        }
    }
}

