/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerDataStorage {
    private static final Logger f_78426_ = LogManager.getLogger();
    private final File f_78427_;
    protected final DataFixer f_78425_;

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess p_78430_, DataFixer p_78431_) {
        this.f_78425_ = p_78431_;
        this.f_78427_ = p_78430_.m_78283_(LevelResource.f_78176_).toFile();
        this.f_78427_.mkdirs();
    }

    public void m_78433_(Player p_78434_) {
        try {
            CompoundTag compoundTag = p_78434_.m_20240_(new CompoundTag());
            File \u00e2\u02dc\u01922 = File.createTempFile(p_78434_.m_20149_() + "-", ".dat", this.f_78427_);
            NbtIo.m_128944_(compoundTag, \u00e2\u02dc\u01922);
            File \u00e2\u02dc\u01923 = new File(this.f_78427_, p_78434_.m_20149_() + ".dat");
            File \u00e2\u02dc\u01924 = new File(this.f_78427_, p_78434_.m_20149_() + ".dat_old");
            Util.m_137462_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924);
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to save player data for {}", (Object)p_78434_.m_7755_().getString());
        }
    }

    @Nullable
    public CompoundTag m_78435_(Player p_78436_) {
        CompoundTag compoundTag = null;
        try {
            File file = new File(this.f_78427_, p_78436_.m_20149_() + ".dat");
            if (file.exists() && file.isFile()) {
                compoundTag = NbtIo.m_128937_(file);
            }
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to load player data for {}", (Object)p_78436_.m_7755_().getString());
        }
        if (compoundTag != null) {
            int n = compoundTag.m_128425_("DataVersion", 3) ? compoundTag.m_128451_("DataVersion") : -1;
            p_78436_.m_20258_(NbtUtils.m_129213_(this.f_78425_, DataFixTypes.PLAYER, compoundTag, n));
        }
        return compoundTag;
    }

    public String[] m_78432_() {
        String[] stringArray = this.f_78427_.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".dat")) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 4);
        }
        return stringArray;
    }
}

