/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTable {
    static final Logger f_79107_ = LogManager.getLogger();
    public static final LootTable f_79105_ = new LootTable(LootContextParamSets.f_81410_, new LootPool[0], new LootItemFunction[0]);
    public static final LootContextParamSet f_79106_ = LootContextParamSets.f_81420_;
    final LootContextParamSet f_79108_;
    final LootPool[] f_79109_;
    final LootItemFunction[] f_79110_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79111_;

    LootTable(LootContextParamSet p_79114_, LootPool[] p_79115_, LootItemFunction[] p_79116_) {
        this.f_79108_ = p_79114_;
        this.f_79109_ = p_79115_;
        this.f_79110_ = p_79116_;
        this.f_79111_ = LootItemFunctions.m_80770_(p_79116_);
    }

    public static Consumer<ItemStack> m_79142_(Consumer<ItemStack> p_79143_) {
        return p_79146_ -> {
            if (p_79146_.m_41613_() < p_79146_.m_41741_()) {
                p_79143_.accept((ItemStack)p_79146_);
            } else {
                ItemStack itemStack;
                for (int \u00e2\u02dc\u01922 = p_79146_.m_41613_(); \u00e2\u02dc\u01922 > 0; \u00e2\u02dc\u01922 -= itemStack.m_41613_()) {
                    itemStack = p_79146_.m_41777_();
                    itemStack.m_41764_(Math.min(p_79146_.m_41741_(), \u00e2\u02dc\u01922));
                    p_79143_.accept(itemStack);
                }
            }
        };
    }

    public void m_79131_(LootContext p_79132_, Consumer<ItemStack> p_79133_) {
        if (p_79132_.m_78934_(this)) {
            Consumer<ItemStack> consumer = LootItemFunction.m_80724_(this.f_79111_, p_79133_, p_79132_);
            for (LootPool lootPool : this.f_79109_) {
                lootPool.m_79053_(consumer, p_79132_);
            }
            p_79132_.m_78946_(this);
        } else {
            f_79107_.warn("Detected infinite loop in loot tables");
        }
    }

    public void m_79148_(LootContext p_79149_, Consumer<ItemStack> p_79150_) {
        this.m_79131_(p_79149_, LootTable.m_79142_(p_79150_));
    }

    public List<ItemStack> m_79129_(LootContext p_79130_) {
        ArrayList arrayList = Lists.newArrayList();
        this.m_79148_(p_79130_, arrayList::add);
        return arrayList;
    }

    public LootContextParamSet m_79122_() {
        return this.f_79108_;
    }

    public void m_79136_(ValidationContext p_79137_) {
        int n;
        for (n = 0; n < this.f_79109_.length; ++n) {
            this.f_79109_[n].m_79051_(p_79137_.m_79365_(".pools[" + n + "]"));
        }
        for (n = 0; n < this.f_79110_.length; ++n) {
            this.f_79110_[n].m_6169_(p_79137_.m_79365_(".functions[" + n + "]"));
        }
    }

    public void m_79123_(Container p_79124_, LootContext p_79125_) {
        List<ItemStack> list = this.m_79129_(p_79125_);
        Random \u00e2\u02dc\u01922 = p_79125_.m_78933_();
        List<Integer> \u00e2\u02dc\u01923 = this.m_79126_(p_79124_, \u00e2\u02dc\u01922);
        this.m_79138_(list, \u00e2\u02dc\u01923.size(), \u00e2\u02dc\u01922);
        for (ItemStack itemStack : list) {
            if (\u00e2\u02dc\u01923.isEmpty()) {
                f_79107_.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.m_41619_()) {
                p_79124_.m_6836_(\u00e2\u02dc\u01923.remove(\u00e2\u02dc\u01923.size() - 1), ItemStack.f_41583_);
                continue;
            }
            p_79124_.m_6836_(\u00e2\u02dc\u01923.remove(\u00e2\u02dc\u01923.size() - 1), itemStack);
        }
    }

    private void m_79138_(List<ItemStack> p_79139_, int p_79140_, Random p_79141_) {
        ArrayList arrayList = Lists.newArrayList();
        Object \u00e2\u02dc\u01922 = p_79139_.iterator();
        while (\u00e2\u02dc\u01922.hasNext()) {
            ItemStack itemStack = \u00e2\u02dc\u01922.next();
            if (itemStack.m_41619_()) {
                \u00e2\u02dc\u01922.remove();
                continue;
            }
            if (itemStack.m_41613_() <= 1) continue;
            arrayList.add(itemStack);
            \u00e2\u02dc\u01922.remove();
        }
        while (p_79140_ - p_79139_.size() - arrayList.size() > 0 && !arrayList.isEmpty()) {
            \u00e2\u02dc\u01922 = (ItemStack)arrayList.remove(Mth.m_14072_(p_79141_, 0, arrayList.size() - 1));
            int n = Mth.m_14072_(p_79141_, 1, ((ItemStack)\u00e2\u02dc\u01922).m_41613_() / 2);
            ItemStack \u00e2\u02dc\u01923 = ((ItemStack)\u00e2\u02dc\u01922).m_41620_(n);
            if (((ItemStack)\u00e2\u02dc\u01922).m_41613_() > 1 && p_79141_.nextBoolean()) {
                arrayList.add(\u00e2\u02dc\u01922);
            } else {
                p_79139_.add((ItemStack)\u00e2\u02dc\u01922);
            }
            if (\u00e2\u02dc\u01923.m_41613_() > 1 && p_79141_.nextBoolean()) {
                arrayList.add(\u00e2\u02dc\u01923);
                continue;
            }
            p_79139_.add(\u00e2\u02dc\u01923);
        }
        p_79139_.addAll(arrayList);
        Collections.shuffle(p_79139_, p_79141_);
    }

    private List<Integer> m_79126_(Container p_79127_, Random p_79128_) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < p_79127_.m_6643_(); ++i) {
            if (!p_79127_.m_8020_(i).m_41619_()) continue;
            arrayList.add(i);
        }
        Collections.shuffle(arrayList, p_79128_);
        return arrayList;
    }

    public static Builder m_79147_() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final List<LootPool> f_79156_ = Lists.newArrayList();
        private final List<LootItemFunction> f_79157_ = Lists.newArrayList();
        private LootContextParamSet f_79158_ = f_79106_;

        public Builder m_79161_(LootPool.Builder p_79162_) {
            this.f_79156_.add(p_79162_.m_79082_());
            return this;
        }

        public Builder m_79165_(LootContextParamSet p_79166_) {
            this.f_79158_ = p_79166_;
            return this;
        }

        @Override
        public Builder m_5577_(LootItemFunction.Builder p_79164_) {
            this.f_79157_.add(p_79164_.m_7453_());
            return this;
        }

        @Override
        public Builder m_5476_() {
            return this;
        }

        public LootTable m_79167_() {
            return new LootTable(this.f_79158_, this.f_79156_.toArray(new LootPool[0]), this.f_79157_.toArray(new LootItemFunction[0]));
        }

        @Override
        public /* synthetic */ Object m_5476_() {
            return this.m_5476_();
        }

        @Override
        public /* synthetic */ Object m_5577_(LootItemFunction.Builder builder) {
            return this.m_5577_(builder);
        }
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement p_79173_, Type p_79174_, JsonDeserializationContext p_79175_) throws JsonParseException {
            LootItemFunction[] \u00e2\u02dc\u01924;
            JsonObject jsonObject = GsonHelper.m_13918_(p_79173_, "loot table");
            LootPool[] \u00e2\u02dc\u01922 = GsonHelper.m_13845_(jsonObject, "pools", new LootPool[0], p_79175_, LootPool[].class);
            LootContextParamSet \u00e2\u02dc\u01923 = null;
            if (jsonObject.has("type")) {
                \u00e2\u02dc\u01924 = GsonHelper.m_13906_(jsonObject, "type");
                \u00e2\u02dc\u01923 = LootContextParamSets.m_81431_(new ResourceLocation((String)\u00e2\u02dc\u01924));
            }
            \u00e2\u02dc\u01924 = GsonHelper.m_13845_(jsonObject, "functions", new LootItemFunction[0], p_79175_, LootItemFunction[].class);
            return new LootTable(\u00e2\u02dc\u01923 != null ? \u00e2\u02dc\u01923 : LootContextParamSets.f_81420_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924);
        }

        public JsonElement serialize(LootTable p_79177_, Type p_79178_, JsonSerializationContext p_79179_) {
            JsonObject jsonObject = new JsonObject();
            if (p_79177_.f_79108_ != f_79106_) {
                ResourceLocation resourceLocation = LootContextParamSets.m_81426_(p_79177_.f_79108_);
                if (resourceLocation != null) {
                    jsonObject.addProperty("type", resourceLocation.toString());
                } else {
                    f_79107_.warn("Failed to find id for param set {}", (Object)p_79177_.f_79108_);
                }
            }
            if (p_79177_.f_79109_.length > 0) {
                jsonObject.add("pools", p_79179_.serialize((Object)p_79177_.f_79109_));
            }
            if (!ArrayUtils.isEmpty((Object[])p_79177_.f_79110_)) {
                jsonObject.add("functions", p_79179_.serialize((Object)p_79177_.f_79110_));
            }
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootTable)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

