/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SetStewEffectFunction
extends LootItemConditionalFunction {
    final Map<MobEffect, NumberProvider> f_81214_;

    SetStewEffectFunction(LootItemCondition[] p_81216_, Map<MobEffect, NumberProvider> p_81217_) {
        super(p_81216_);
        this.f_81214_ = ImmutableMap.copyOf(p_81217_);
    }

    @Override
    public LootItemFunctionType m_7162_() {
        return LootItemFunctions.f_80746_;
    }

    @Override
    public Set<LootContextParam<?>> m_6231_() {
        return (Set)this.f_81214_.values().stream().flatMap(p_165470_ -> p_165470_.m_6231_().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack m_7372_(ItemStack p_81223_, LootContext p_81224_) {
        if (!p_81223_.m_150930_(Items.f_42718_) || this.f_81214_.isEmpty()) {
            return p_81223_;
        }
        Random random = p_81224_.m_78933_();
        int \u00e2\u02dc\u01922 = random.nextInt(this.f_81214_.size());
        Map.Entry \u00e2\u02dc\u01923 = (Map.Entry)Iterables.get(this.f_81214_.entrySet(), (int)\u00e2\u02dc\u01922);
        MobEffect \u00e2\u02dc\u01924 = (MobEffect)\u00e2\u02dc\u01923.getKey();
        int \u00e2\u02dc\u01925 = ((NumberProvider)\u00e2\u02dc\u01923.getValue()).m_142683_(p_81224_);
        if (!\u00e2\u02dc\u01924.m_8093_()) {
            \u00e2\u02dc\u01925 *= 20;
        }
        SuspiciousStewItem.m_43258_(p_81223_, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
        return p_81223_;
    }

    public static Builder m_81228_() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Map<MobEffect, NumberProvider> f_81229_ = Maps.newHashMap();

        @Override
        protected Builder m_6477_() {
            return this;
        }

        public Builder m_165472_(MobEffect p_165473_, NumberProvider p_165474_) {
            this.f_81229_.put(p_165473_, p_165474_);
            return this;
        }

        @Override
        public LootItemFunction m_7453_() {
            return new SetStewEffectFunction(this.m_80699_(), this.f_81229_);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder m_6477_() {
            return this.m_6477_();
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetStewEffectFunction> {
        @Override
        public void m_6170_(JsonObject p_81247_, SetStewEffectFunction p_81248_, JsonSerializationContext p_81249_) {
            super.m_6170_(p_81247_, p_81248_, p_81249_);
            if (!p_81248_.f_81214_.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (MobEffect mobEffect : p_81248_.f_81214_.keySet()) {
                    JsonObject jsonObject = new JsonObject();
                    ResourceLocation \u00e2\u02dc\u01922 = Registry.f_122823_.m_7981_(mobEffect);
                    if (\u00e2\u02dc\u01922 == null) {
                        throw new IllegalArgumentException("Don't know how to serialize mob effect " + mobEffect);
                    }
                    jsonObject.add("type", (JsonElement)new JsonPrimitive(\u00e2\u02dc\u01922.toString()));
                    jsonObject.add("duration", p_81249_.serialize((Object)p_81248_.f_81214_.get(mobEffect)));
                    jsonArray.add((JsonElement)jsonObject);
                }
                p_81247_.add("effects", (JsonElement)jsonArray);
            }
        }

        @Override
        public SetStewEffectFunction m_6821_(JsonObject p_81239_, JsonDeserializationContext p_81240_, LootItemCondition[] p_81241_) {
            HashMap hashMap = Maps.newHashMap();
            if (p_81239_.has("effects")) {
                JsonArray jsonArray = GsonHelper.m_13933_(p_81239_, "effects");
                for (JsonElement jsonElement : jsonArray) {
                    String string = GsonHelper.m_13906_(jsonElement.getAsJsonObject(), "type");
                    MobEffect \u00e2\u02dc\u01922 = Registry.f_122823_.m_6612_(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Unknown mob effect '" + string + "'"));
                    NumberProvider \u00e2\u02dc\u01923 = GsonHelper.m_13836_(jsonElement.getAsJsonObject(), "duration", p_81240_, NumberProvider.class);
                    hashMap.put(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
                }
            }
            return new SetStewEffectFunction(p_81241_, hashMap);
        }

        @Override
        public /* synthetic */ LootItemConditionalFunction m_6821_(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.m_6821_(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

