/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IdenticalMerger;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.IndirectMerger;
import net.minecraft.world.phys.shapes.NonOverlappingMerger;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    public static final double f_166025_ = 1.0E-7;
    public static final double f_166026_ = 1.0E-6;
    private static final VoxelShape f_83037_ = Util.m_137537_(() -> {
        BitSetDiscreteVoxelShape bitSetDiscreteVoxelShape = new BitSetDiscreteVoxelShape(1, 1, 1);
        ((DiscreteVoxelShape)bitSetDiscreteVoxelShape).m_142703_(0, 0, 0);
        return new CubeVoxelShape(bitSetDiscreteVoxelShape);
    });
    public static final VoxelShape f_83036_ = Shapes.m_83048_(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape f_83038_ = new ArrayVoxelShape((DiscreteVoxelShape)new BitSetDiscreteVoxelShape(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape m_83040_() {
        return f_83038_;
    }

    public static VoxelShape m_83144_() {
        return f_83037_;
    }

    public static VoxelShape m_83048_(double p_83049_, double p_83050_, double p_83051_, double p_83052_, double p_83053_, double p_83054_) {
        if (p_83049_ > p_83052_ || p_83050_ > p_83053_ || p_83051_ > p_83054_) {
            throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
        }
        return Shapes.m_166049_(p_83049_, p_83050_, p_83051_, p_83052_, p_83053_, p_83054_);
    }

    public static VoxelShape m_166049_(double p_166050_, double p_166051_, double p_166052_, double p_166053_, double p_166054_, double p_166055_) {
        if (p_166053_ - p_166050_ < 1.0E-7 || p_166054_ - p_166051_ < 1.0E-7 || p_166055_ - p_166052_ < 1.0E-7) {
            return Shapes.m_83040_();
        }
        int n = Shapes.m_83041_(p_166050_, p_166053_);
        \u00e2\u02dc\u0192 = Shapes.m_83041_(p_166051_, p_166054_);
        \u00e2\u02dc\u0192 = Shapes.m_83041_(p_166052_, p_166055_);
        if (n < 0 || \u00e2\u02dc\u0192 < 0 || \u00e2\u02dc\u0192 < 0) {
            return new ArrayVoxelShape(Shapes.f_83037_.f_83211_, (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166050_, p_166053_}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166051_, p_166054_}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{p_166052_, p_166055_}));
        }
        if (n == 0 && \u00e2\u02dc\u0192 == 0 && \u00e2\u02dc\u0192 == 0) {
            return Shapes.m_83144_();
        }
        \u00e2\u02dc\u0192 = 1 << n;
        \u00e2\u02dc\u0192 = 1 << \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = 1 << \u00e2\u02dc\u0192;
        BitSetDiscreteVoxelShape \u00e2\u02dc\u01922 = BitSetDiscreteVoxelShape.m_165932_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, (int)Math.round(p_166050_ * (double)\u00e2\u02dc\u0192), (int)Math.round(p_166051_ * (double)\u00e2\u02dc\u0192), (int)Math.round(p_166052_ * (double)\u00e2\u02dc\u0192), (int)Math.round(p_166053_ * (double)\u00e2\u02dc\u0192), (int)Math.round(p_166054_ * (double)\u00e2\u02dc\u0192), (int)Math.round(p_166055_ * (double)\u00e2\u02dc\u0192));
        return new CubeVoxelShape(\u00e2\u02dc\u01922);
    }

    public static VoxelShape m_83064_(AABB p_83065_) {
        return Shapes.m_166049_(p_83065_.f_82288_, p_83065_.f_82289_, p_83065_.f_82290_, p_83065_.f_82291_, p_83065_.f_82292_, p_83065_.f_82293_);
    }

    @VisibleForTesting
    protected static int m_83041_(double p_83042_, double p_83043_) {
        if (p_83042_ < -1.0E-7 || p_83043_ > 1.0000001) {
            return -1;
        }
        for (int i = 0; i <= 3; ++i) {
            \u00e2\u02dc\u0192 = 1 << i;
            double d = p_83042_ * (double)\u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = p_83043_ * (double)\u00e2\u02dc\u0192;
            boolean \u00e2\u02dc\u01922 = Math.abs(d - (double)Math.round(d)) < 1.0E-7 * (double)\u00e2\u02dc\u0192;
            boolean bl = \u00e2\u02dc\u0192 = Math.abs(\u00e2\u02dc\u0192 - (double)Math.round(\u00e2\u02dc\u0192)) < 1.0E-7 * (double)\u00e2\u02dc\u0192;
            if (!\u00e2\u02dc\u01922 || !\u00e2\u02dc\u0192) continue;
            return i;
        }
        return -1;
    }

    protected static long m_83055_(int p_83056_, int p_83057_) {
        return (long)p_83056_ * (long)(p_83057_ / IntMath.gcd((int)p_83056_, (int)p_83057_));
    }

    public static VoxelShape m_83110_(VoxelShape p_83111_, VoxelShape p_83112_) {
        return Shapes.m_83113_(p_83111_, p_83112_, BooleanOp.f_82695_);
    }

    public static VoxelShape m_83124_(VoxelShape p_83125_, VoxelShape ... p_83126_) {
        return Arrays.stream(p_83126_).reduce(p_83125_, Shapes::m_83110_);
    }

    public static VoxelShape m_83113_(VoxelShape p_83114_, VoxelShape p_83115_, BooleanOp p_83116_) {
        return Shapes.m_83148_(p_83114_, p_83115_, p_83116_).m_83296_();
    }

    public static VoxelShape m_83148_(VoxelShape p_83149_, VoxelShape p_83150_, BooleanOp p_83151_) {
        if (p_83151_.m_82701_(false, false)) {
            throw Util.m_137570_(new IllegalArgumentException());
        }
        if (p_83149_ == p_83150_) {
            return p_83151_.m_82701_(true, true) ? p_83149_ : Shapes.m_83040_();
        }
        boolean bl = p_83151_.m_82701_(true, false);
        \u00e2\u02dc\u0192 = p_83151_.m_82701_(false, true);
        if (p_83149_.m_83281_()) {
            return \u00e2\u02dc\u0192 ? p_83150_ : Shapes.m_83040_();
        }
        if (p_83150_.m_83281_()) {
            return bl ? p_83149_ : Shapes.m_83040_();
        }
        IndexMerger \u00e2\u02dc\u01922 = Shapes.m_83058_(1, p_83149_.m_7700_(Direction.Axis.X), p_83150_.m_7700_(Direction.Axis.X), bl, \u00e2\u02dc\u0192);
        IndexMerger \u00e2\u02dc\u01923 = Shapes.m_83058_(\u00e2\u02dc\u01922.size() - 1, p_83149_.m_7700_(Direction.Axis.Y), p_83150_.m_7700_(Direction.Axis.Y), bl, \u00e2\u02dc\u0192);
        IndexMerger \u00e2\u02dc\u01924 = Shapes.m_83058_((\u00e2\u02dc\u01922.size() - 1) * (\u00e2\u02dc\u01923.size() - 1), p_83149_.m_7700_(Direction.Axis.Z), p_83150_.m_7700_(Direction.Axis.Z), bl, \u00e2\u02dc\u0192);
        BitSetDiscreteVoxelShape \u00e2\u02dc\u01925 = BitSetDiscreteVoxelShape.m_82641_(p_83149_.f_83211_, p_83150_.f_83211_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, p_83151_);
        if (\u00e2\u02dc\u01922 instanceof DiscreteCubeMerger && \u00e2\u02dc\u01923 instanceof DiscreteCubeMerger && \u00e2\u02dc\u01924 instanceof DiscreteCubeMerger) {
            return new CubeVoxelShape(\u00e2\u02dc\u01925);
        }
        return new ArrayVoxelShape((DiscreteVoxelShape)\u00e2\u02dc\u01925, \u00e2\u02dc\u01922.m_6241_(), \u00e2\u02dc\u01923.m_6241_(), \u00e2\u02dc\u01924.m_6241_());
    }

    public static boolean m_83157_(VoxelShape p_83158_, VoxelShape p_83159_, BooleanOp p_83160_) {
        boolean bl;
        if (p_83160_.m_82701_(false, false)) {
            throw Util.m_137570_(new IllegalArgumentException());
        }
        boolean bl2 = p_83158_.m_83281_();
        \u00e2\u02dc\u0192 = p_83159_.m_83281_();
        if (bl2 || \u00e2\u02dc\u0192) {
            return p_83160_.m_82701_(!bl2, !\u00e2\u02dc\u0192);
        }
        if (p_83158_ == p_83159_) {
            return p_83160_.m_82701_(true, true);
        }
        bl = p_83160_.m_82701_(true, false);
        \u00e2\u02dc\u0192 = p_83160_.m_82701_(false, true);
        for (Direction.Axis axis : AxisCycle.f_121783_) {
            if (p_83158_.m_83297_(axis) < p_83159_.m_83288_(axis) - 1.0E-7) {
                return bl || \u00e2\u02dc\u0192;
            }
            if (!(p_83159_.m_83297_(axis) < p_83158_.m_83288_(axis) - 1.0E-7)) continue;
            return bl || \u00e2\u02dc\u0192;
        }
        IndexMerger \u00e2\u02dc\u01922 = Shapes.m_83058_(1, p_83158_.m_7700_(Direction.Axis.X), p_83159_.m_7700_(Direction.Axis.X), bl, \u00e2\u02dc\u0192);
        IndexMerger \u00e2\u02dc\u01923 = Shapes.m_83058_(\u00e2\u02dc\u01922.size() - 1, p_83158_.m_7700_(Direction.Axis.Y), p_83159_.m_7700_(Direction.Axis.Y), bl, \u00e2\u02dc\u0192);
        IndexMerger \u00e2\u02dc\u01924 = Shapes.m_83058_((\u00e2\u02dc\u01922.size() - 1) * (\u00e2\u02dc\u01923.size() - 1), p_83158_.m_7700_(Direction.Axis.Z), p_83159_.m_7700_(Direction.Axis.Z), bl, \u00e2\u02dc\u0192);
        return Shapes.m_83103_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, p_83158_.f_83211_, p_83159_.f_83211_, p_83160_);
    }

    private static boolean m_83103_(IndexMerger p_83104_, IndexMerger p_83105_, IndexMerger p_83106_, DiscreteVoxelShape p_83107_, DiscreteVoxelShape p_83108_, BooleanOp p_83109_) {
        return !p_83104_.m_6200_((p_83100_, p_83101_, p_83102_) -> p_83105_.m_6200_((p_166046_, p_166047_, p_166048_) -> p_83106_.m_6200_((p_166036_, p_166037_, p_166038_) -> !p_83109_.m_82701_(p_83107_.m_82846_(p_83100_, p_166046_, p_166036_), p_83108_.m_82846_(p_83101_, p_166047_, p_166037_)))));
    }

    public static double m_83134_(Direction.Axis p_83135_, AABB p_83136_, Stream<VoxelShape> p_83137_, double p_83138_) {
        Iterator iterator = p_83137_.iterator();
        while (iterator.hasNext()) {
            if (Math.abs(p_83138_) < 1.0E-7) {
                return 0.0;
            }
            p_83138_ = ((VoxelShape)iterator.next()).m_83259_(p_83135_, p_83136_, p_83138_);
        }
        return p_83138_;
    }

    public static double m_83127_(Direction.Axis p_83128_, AABB p_83129_, LevelReader p_83130_, double p_83131_, CollisionContext p_83132_, Stream<VoxelShape> p_83133_) {
        return Shapes.m_83066_(p_83129_, p_83130_, p_83131_, p_83132_, AxisCycle.m_121799_(p_83128_, Direction.Axis.Z), p_83133_);
    }

    private static double m_83066_(AABB p_83067_, LevelReader p_83068_, double p_83069_, CollisionContext p_83070_, AxisCycle p_83071_, Stream<VoxelShape> p_83072_) {
        if (p_83067_.m_82362_() < 1.0E-6 || p_83067_.m_82376_() < 1.0E-6 || p_83067_.m_82385_() < 1.0E-6) {
            return p_83069_;
        }
        if (Math.abs(p_83069_) < 1.0E-7) {
            return 0.0;
        }
        AxisCycle axisCycle = p_83071_.m_7634_();
        Direction.Axis \u00e2\u02dc\u01922 = axisCycle.m_7314_(Direction.Axis.X);
        Direction.Axis \u00e2\u02dc\u01923 = axisCycle.m_7314_(Direction.Axis.Y);
        Direction.Axis \u00e2\u02dc\u01924 = axisCycle.m_7314_(Direction.Axis.Z);
        BlockPos.MutableBlockPos \u00e2\u02dc\u01925 = new BlockPos.MutableBlockPos();
        int \u00e2\u02dc\u01926 = Mth.m_14107_(p_83067_.m_82340_(\u00e2\u02dc\u01922) - 1.0E-7) - 1;
        int \u00e2\u02dc\u01927 = Mth.m_14107_(p_83067_.m_82374_(\u00e2\u02dc\u01922) + 1.0E-7) + 1;
        int \u00e2\u02dc\u01928 = Mth.m_14107_(p_83067_.m_82340_(\u00e2\u02dc\u01923) - 1.0E-7) - 1;
        int \u00e2\u02dc\u01929 = Mth.m_14107_(p_83067_.m_82374_(\u00e2\u02dc\u01923) + 1.0E-7) + 1;
        double \u00e2\u02dc\u019210 = p_83067_.m_82340_(\u00e2\u02dc\u01924) - 1.0E-7;
        double \u00e2\u02dc\u019211 = p_83067_.m_82374_(\u00e2\u02dc\u01924) + 1.0E-7;
        boolean \u00e2\u02dc\u019212 = p_83069_ > 0.0;
        int \u00e2\u02dc\u019213 = \u00e2\u02dc\u019212 ? Mth.m_14107_(p_83067_.m_82374_(\u00e2\u02dc\u01924) - 1.0E-7) - 1 : Mth.m_14107_(p_83067_.m_82340_(\u00e2\u02dc\u01924) + 1.0E-7) + 1;
        int \u00e2\u02dc\u019214 = Shapes.m_83044_(p_83069_, \u00e2\u02dc\u019210, \u00e2\u02dc\u019211);
        int \u00e2\u02dc\u019215 = \u00e2\u02dc\u019212 ? 1 : -1;
        int \u00e2\u02dc\u019216 = \u00e2\u02dc\u019213;
        while (\u00e2\u02dc\u019212 ? \u00e2\u02dc\u019216 <= \u00e2\u02dc\u019214 : \u00e2\u02dc\u019216 >= \u00e2\u02dc\u019214) {
            for (int i = \u00e2\u02dc\u01926; i <= \u00e2\u02dc\u01927; ++i) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01928; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u01929; ++\u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u0192 = 0;
                    if (i == \u00e2\u02dc\u01926 || i == \u00e2\u02dc\u01927) {
                        ++\u00e2\u02dc\u0192;
                    }
                    if (\u00e2\u02dc\u0192 == \u00e2\u02dc\u01928 || \u00e2\u02dc\u0192 == \u00e2\u02dc\u01929) {
                        ++\u00e2\u02dc\u0192;
                    }
                    if (\u00e2\u02dc\u019216 == \u00e2\u02dc\u019213 || \u00e2\u02dc\u019216 == \u00e2\u02dc\u019214) {
                        ++\u00e2\u02dc\u0192;
                    }
                    if (\u00e2\u02dc\u0192 >= 3) continue;
                    \u00e2\u02dc\u01925.m_122139_(axisCycle, i, \u00e2\u02dc\u0192, \u00e2\u02dc\u019216);
                    BlockState blockState = p_83068_.m_8055_(\u00e2\u02dc\u01925);
                    if (\u00e2\u02dc\u0192 == 1 && !blockState.m_60779_() || \u00e2\u02dc\u0192 == 2 && !blockState.m_60713_(Blocks.f_50110_)) continue;
                    p_83069_ = blockState.m_60742_(p_83068_, \u00e2\u02dc\u01925, p_83070_).m_83259_(\u00e2\u02dc\u01924, p_83067_.m_82386_(-\u00e2\u02dc\u01925.m_123341_(), -\u00e2\u02dc\u01925.m_123342_(), -\u00e2\u02dc\u01925.m_123343_()), p_83069_);
                    if (Math.abs(p_83069_) < 1.0E-7) {
                        return 0.0;
                    }
                    \u00e2\u02dc\u019214 = Shapes.m_83044_(p_83069_, \u00e2\u02dc\u019210, \u00e2\u02dc\u019211);
                }
            }
            \u00e2\u02dc\u019216 += \u00e2\u02dc\u019215;
        }
        double[] dArray = new double[]{p_83069_};
        p_83072_.forEach(p_83143_ -> {
            p_83140_[0] = p_83143_.m_83259_(\u00e2\u02dc\u01924, p_83067_, dArray[0]);
        });
        return dArray[0];
    }

    private static int m_83044_(double p_83045_, double p_83046_, double p_83047_) {
        return p_83045_ > 0.0 ? Mth.m_14107_(p_83047_ + p_83045_) + 1 : Mth.m_14107_(p_83046_ + p_83045_) - 1;
    }

    public static boolean m_83117_(VoxelShape p_83118_, VoxelShape p_83119_, Direction p_83120_) {
        if (p_83118_ == Shapes.m_83144_() && p_83119_ == Shapes.m_83144_()) {
            return true;
        }
        if (p_83119_.m_83281_()) {
            return false;
        }
        Direction.Axis axis = p_83120_.m_122434_();
        Direction.AxisDirection \u00e2\u02dc\u01922 = p_83120_.m_122421_();
        VoxelShape \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922 == Direction.AxisDirection.POSITIVE ? p_83118_ : p_83119_;
        VoxelShape \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922 == Direction.AxisDirection.POSITIVE ? p_83119_ : p_83118_;
        BooleanOp \u00e2\u02dc\u01925 = \u00e2\u02dc\u01922 == Direction.AxisDirection.POSITIVE ? BooleanOp.f_82685_ : BooleanOp.f_82683_;
        return DoubleMath.fuzzyEquals((double)\u00e2\u02dc\u01923.m_83297_(axis), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)\u00e2\u02dc\u01924.m_83288_(axis), (double)0.0, (double)1.0E-7) && !Shapes.m_83157_(new SliceShape(\u00e2\u02dc\u01923, axis, \u00e2\u02dc\u01923.f_83211_.m_82850_(axis) - 1), new SliceShape(\u00e2\u02dc\u01924, axis, 0), \u00e2\u02dc\u01925);
    }

    public static VoxelShape m_83121_(VoxelShape p_83122_, Direction p_83123_) {
        int \u00e2\u02dc\u01922;
        if (p_83122_ == Shapes.m_83144_()) {
            return Shapes.m_83144_();
        }
        Direction.Axis axis = p_83123_.m_122434_();
        if (p_83123_.m_122421_() == Direction.AxisDirection.POSITIVE) {
            boolean bl = DoubleMath.fuzzyEquals((double)p_83122_.m_83297_(axis), (double)1.0, (double)1.0E-7);
            \u00e2\u02dc\u01922 = p_83122_.f_83211_.m_82850_(axis) - 1;
        } else {
            bl = DoubleMath.fuzzyEquals((double)p_83122_.m_83288_(axis), (double)0.0, (double)1.0E-7);
            \u00e2\u02dc\u01922 = 0;
        }
        if (!bl) {
            return Shapes.m_83040_();
        }
        return new SliceShape(p_83122_, axis, \u00e2\u02dc\u01922);
    }

    public static boolean m_83152_(VoxelShape p_83153_, VoxelShape p_83154_, Direction p_83155_) {
        if (p_83153_ == Shapes.m_83144_() || p_83154_ == Shapes.m_83144_()) {
            return true;
        }
        Direction.Axis axis = p_83155_.m_122434_();
        Direction.AxisDirection \u00e2\u02dc\u01922 = p_83155_.m_122421_();
        VoxelShape \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922 == Direction.AxisDirection.POSITIVE ? p_83153_ : p_83154_;
        VoxelShape voxelShape = voxelShape2 = \u00e2\u02dc\u01922 == Direction.AxisDirection.POSITIVE ? p_83154_ : p_83153_;
        if (!DoubleMath.fuzzyEquals((double)\u00e2\u02dc\u01923.m_83297_(axis), (double)1.0, (double)1.0E-7)) {
            \u00e2\u02dc\u01923 = Shapes.m_83040_();
        }
        if (!DoubleMath.fuzzyEquals((double)voxelShape2.m_83288_(axis), (double)0.0, (double)1.0E-7)) {
            VoxelShape voxelShape2 = Shapes.m_83040_();
        }
        return !Shapes.m_83157_(Shapes.m_83144_(), Shapes.m_83148_(new SliceShape(\u00e2\u02dc\u01923, axis, \u00e2\u02dc\u01923.f_83211_.m_82850_(axis) - 1), new SliceShape(voxelShape2, axis, 0), BooleanOp.f_82695_), BooleanOp.f_82685_);
    }

    public static boolean m_83145_(VoxelShape p_83146_, VoxelShape p_83147_) {
        if (p_83146_ == Shapes.m_83144_() || p_83147_ == Shapes.m_83144_()) {
            return true;
        }
        if (p_83146_.m_83281_() && p_83147_.m_83281_()) {
            return false;
        }
        return !Shapes.m_83157_(Shapes.m_83144_(), Shapes.m_83148_(p_83146_, p_83147_, BooleanOp.f_82695_), BooleanOp.f_82685_);
    }

    @VisibleForTesting
    protected static IndexMerger m_83058_(int p_83059_, DoubleList p_83060_, DoubleList p_83061_, boolean p_83062_, boolean p_83063_) {
        int n = p_83060_.size() - 1;
        \u00e2\u02dc\u0192 = p_83061_.size() - 1;
        if (p_83060_ instanceof CubePointRange && p_83061_ instanceof CubePointRange && (long)p_83059_ * (\u00e2\u02dc\u0192 = Shapes.m_83055_(n, \u00e2\u02dc\u0192)) <= 256L) {
            return new DiscreteCubeMerger(n, \u00e2\u02dc\u0192);
        }
        if (p_83060_.getDouble(n) < p_83061_.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(p_83060_, p_83061_, false);
        }
        if (p_83061_.getDouble(\u00e2\u02dc\u0192) < p_83060_.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(p_83061_, p_83060_, true);
        }
        if (n == \u00e2\u02dc\u0192 && Objects.equals(p_83060_, p_83061_)) {
            return new IdenticalMerger(p_83060_);
        }
        return new IndirectMerger(p_83060_, p_83061_, p_83062_, p_83063_);
    }

    public static interface DoubleLineConsumer {
        public void m_83161_(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

