/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.OffsetDoubleList;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;

public abstract class VoxelShape {
    protected final DiscreteVoxelShape f_83211_;
    @Nullable
    private VoxelShape[] f_83212_;

    VoxelShape(DiscreteVoxelShape p_83214_) {
        this.f_83211_ = p_83214_;
    }

    public double m_83288_(Direction.Axis p_83289_) {
        int n = this.f_83211_.m_6538_(p_83289_);
        if (n >= this.f_83211_.m_82850_(p_83289_)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.m_83256_(p_83289_, n);
    }

    public double m_83297_(Direction.Axis p_83298_) {
        int n = this.f_83211_.m_6536_(p_83298_);
        if (n <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.m_83256_(p_83298_, n);
    }

    public AABB m_83215_() {
        if (this.m_83281_()) {
            throw Util.m_137570_(new UnsupportedOperationException("No bounds for empty shape."));
        }
        return new AABB(this.m_83288_(Direction.Axis.X), this.m_83288_(Direction.Axis.Y), this.m_83288_(Direction.Axis.Z), this.m_83297_(Direction.Axis.X), this.m_83297_(Direction.Axis.Y), this.m_83297_(Direction.Axis.Z));
    }

    protected double m_83256_(Direction.Axis p_83257_, int p_83258_) {
        return this.m_7700_(p_83257_).getDouble(p_83258_);
    }

    protected abstract DoubleList m_7700_(Direction.Axis var1);

    public boolean m_83281_() {
        return this.f_83211_.m_6224_();
    }

    public VoxelShape m_83216_(double p_83217_, double p_83218_, double p_83219_) {
        if (this.m_83281_()) {
            return Shapes.m_83040_();
        }
        return new ArrayVoxelShape(this.f_83211_, (DoubleList)new OffsetDoubleList(this.m_7700_(Direction.Axis.X), p_83217_), (DoubleList)new OffsetDoubleList(this.m_7700_(Direction.Axis.Y), p_83218_), (DoubleList)new OffsetDoubleList(this.m_7700_(Direction.Axis.Z), p_83219_));
    }

    public VoxelShape m_83296_() {
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Shapes.m_83040_()};
        this.m_83286_((p_83275_, p_83276_, p_83277_, p_83278_, p_83279_, p_83280_) -> {
            p_83274_[0] = Shapes.m_83148_(voxelShapeArray[0], Shapes.m_83048_(p_83275_, p_83276_, p_83277_, p_83278_, p_83279_, p_83280_), BooleanOp.f_82695_);
        });
        return voxelShapeArray[0];
    }

    public void m_83224_(Shapes.DoubleLineConsumer p_83225_) {
        this.f_83211_.m_82819_((p_83228_, p_83229_, p_83230_, p_83231_, p_83232_, p_83233_) -> p_83225_.m_83161_(this.m_83256_(Direction.Axis.X, p_83228_), this.m_83256_(Direction.Axis.Y, p_83229_), this.m_83256_(Direction.Axis.Z, p_83230_), this.m_83256_(Direction.Axis.X, p_83231_), this.m_83256_(Direction.Axis.Y, p_83232_), this.m_83256_(Direction.Axis.Z, p_83233_)), true);
    }

    public void m_83286_(Shapes.DoubleLineConsumer p_83287_) {
        DoubleList doubleList = this.m_7700_(Direction.Axis.X);
        \u00e2\u02dc\u0192 = this.m_7700_(Direction.Axis.Y);
        \u00e2\u02dc\u0192 = this.m_7700_(Direction.Axis.Z);
        this.f_83211_.m_82832_((p_83239_, p_83240_, p_83241_, p_83242_, p_83243_, p_83244_) -> p_83287_.m_83161_(doubleList.getDouble(p_83239_), \u00e2\u02dc\u0192.getDouble(p_83240_), \u00e2\u02dc\u0192.getDouble(p_83241_), doubleList.getDouble(p_83242_), \u00e2\u02dc\u0192.getDouble(p_83243_), \u00e2\u02dc\u0192.getDouble(p_83244_)), true);
    }

    public List<AABB> m_83299_() {
        ArrayList arrayList = Lists.newArrayList();
        this.m_83286_((p_83267_, p_83268_, p_83269_, p_83270_, p_83271_, p_83272_) -> arrayList.add(new AABB(p_83267_, p_83268_, p_83269_, p_83270_, p_83271_, p_83272_)));
        return arrayList;
    }

    public double m_166078_(Direction.Axis p_166079_, double p_166080_, double p_166081_) {
        Direction.Axis axis = AxisCycle.FORWARD.m_7314_(p_166079_);
        \u00e2\u02dc\u0192 = AxisCycle.BACKWARD.m_7314_(p_166079_);
        int \u00e2\u02dc\u01922 = this.m_6595_(axis, p_166080_);
        int \u00e2\u02dc\u01923 = this.f_83211_.m_165994_(p_166079_, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192 = this.m_6595_(\u00e2\u02dc\u0192, p_166081_));
        if (\u00e2\u02dc\u01923 >= this.f_83211_.m_82850_(p_166079_)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.m_83256_(p_166079_, \u00e2\u02dc\u01923);
    }

    public double m_83290_(Direction.Axis p_83291_, double p_83292_, double p_83293_) {
        Direction.Axis axis = AxisCycle.FORWARD.m_7314_(p_83291_);
        \u00e2\u02dc\u0192 = AxisCycle.BACKWARD.m_7314_(p_83291_);
        int \u00e2\u02dc\u01922 = this.m_6595_(axis, p_83292_);
        int \u00e2\u02dc\u01923 = this.f_83211_.m_82841_(p_83291_, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192 = this.m_6595_(\u00e2\u02dc\u0192, p_83293_));
        if (\u00e2\u02dc\u01923 <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.m_83256_(p_83291_, \u00e2\u02dc\u01923);
    }

    protected int m_6595_(Direction.Axis p_83250_, double p_83251_) {
        return Mth.m_14049_(0, this.f_83211_.m_82850_(p_83250_) + 1, p_166066_ -> p_83251_ < this.m_83256_(p_83250_, p_166066_)) - 1;
    }

    @Nullable
    public BlockHitResult m_83220_(Vec3 p_83221_, Vec3 p_83222_, BlockPos p_83223_) {
        if (this.m_83281_()) {
            return null;
        }
        Vec3 vec3 = p_83222_.m_82546_(p_83221_);
        if (vec3.m_82556_() < 1.0E-7) {
            return null;
        }
        \u00e2\u02dc\u0192 = p_83221_.m_82549_(vec3.m_82490_(0.001));
        if (this.f_83211_.m_82846_(this.m_6595_(Direction.Axis.X, \u00e2\u02dc\u0192.f_82479_ - (double)p_83223_.m_123341_()), this.m_6595_(Direction.Axis.Y, \u00e2\u02dc\u0192.f_82480_ - (double)p_83223_.m_123342_()), this.m_6595_(Direction.Axis.Z, \u00e2\u02dc\u0192.f_82481_ - (double)p_83223_.m_123343_()))) {
            return new BlockHitResult(\u00e2\u02dc\u0192, Direction.m_122366_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_).m_122424_(), p_83223_, true);
        }
        return AABB.m_82342_(this.m_83299_(), p_83221_, p_83222_, p_83223_);
    }

    public Optional<Vec3> m_166067_(Vec3 p_166068_) {
        if (this.m_83281_()) {
            return Optional.empty();
        }
        Vec3[] vec3Array = new Vec3[1];
        this.m_83286_((p_166072_, p_166073_, p_166074_, p_166075_, p_166076_, p_166077_) -> {
            double d = Mth.m_14008_(p_166068_.m_7096_(), p_166072_, p_166075_);
            \u00e2\u02dc\u0192 = Mth.m_14008_(p_166068_.m_7098_(), p_166073_, p_166076_);
            \u00e2\u02dc\u0192 = Mth.m_14008_(p_166068_.m_7094_(), p_166074_, p_166077_);
            if (vec3Array[0] == null || p_166068_.m_82531_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192) < p_166068_.m_82557_(vec3Array[0])) {
                p_166071_[0] = new Vec3(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
        });
        return Optional.of(vec3Array[0]);
    }

    public VoxelShape m_83263_(Direction p_83264_) {
        VoxelShape voxelShape;
        if (this.m_83281_() || this == Shapes.m_83144_()) {
            return this;
        }
        if (this.f_83212_ != null) {
            voxelShape = this.f_83212_[p_83264_.ordinal()];
            if (voxelShape != null) {
                return voxelShape;
            }
        } else {
            this.f_83212_ = new VoxelShape[6];
        }
        this.f_83212_[p_83264_.ordinal()] = voxelShape = this.m_83294_(p_83264_);
        return voxelShape;
    }

    private VoxelShape m_83294_(Direction p_83295_) {
        Direction.Axis axis = p_83295_.m_122434_();
        DoubleList \u00e2\u02dc\u01922 = this.m_7700_(axis);
        if (\u00e2\u02dc\u01922.size() == 2 && DoubleMath.fuzzyEquals((double)\u00e2\u02dc\u01922.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)\u00e2\u02dc\u01922.getDouble(1), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        Direction.AxisDirection \u00e2\u02dc\u01923 = p_83295_.m_122421_();
        int \u00e2\u02dc\u01924 = this.m_6595_(axis, \u00e2\u02dc\u01923 == Direction.AxisDirection.POSITIVE ? 0.9999999 : 1.0E-7);
        return new SliceShape(this, axis, \u00e2\u02dc\u01924);
    }

    public double m_83259_(Direction.Axis p_83260_, AABB p_83261_, double p_83262_) {
        return this.m_83245_(AxisCycle.m_121799_(p_83260_, Direction.Axis.X), p_83261_, p_83262_);
    }

    protected double m_83245_(AxisCycle p_83246_, AABB p_83247_, double p_83248_) {
        block11: {
            int \u00e2\u02dc\u019212;
            int \u00e2\u02dc\u019210;
            double \u00e2\u02dc\u01926;
            Direction.Axis \u00e2\u02dc\u01922;
            block10: {
                if (this.m_83281_()) {
                    return p_83248_;
                }
                if (Math.abs(p_83248_) < 1.0E-7) {
                    return 0.0;
                }
                AxisCycle axisCycle = p_83246_.m_7634_();
                \u00e2\u02dc\u01922 = axisCycle.m_7314_(Direction.Axis.X);
                Direction.Axis \u00e2\u02dc\u01923 = axisCycle.m_7314_(Direction.Axis.Y);
                Direction.Axis \u00e2\u02dc\u01924 = axisCycle.m_7314_(Direction.Axis.Z);
                double \u00e2\u02dc\u01925 = p_83247_.m_82374_(\u00e2\u02dc\u01922);
                \u00e2\u02dc\u01926 = p_83247_.m_82340_(\u00e2\u02dc\u01922);
                int \u00e2\u02dc\u01927 = this.m_6595_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01926 + 1.0E-7);
                int \u00e2\u02dc\u01928 = this.m_6595_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01925 - 1.0E-7);
                int \u00e2\u02dc\u01929 = Math.max(0, this.m_6595_(\u00e2\u02dc\u01923, p_83247_.m_82340_(\u00e2\u02dc\u01923) + 1.0E-7));
                \u00e2\u02dc\u019210 = Math.min(this.f_83211_.m_82850_(\u00e2\u02dc\u01923), this.m_6595_(\u00e2\u02dc\u01923, p_83247_.m_82374_(\u00e2\u02dc\u01923) - 1.0E-7) + 1);
                int \u00e2\u02dc\u019211 = Math.max(0, this.m_6595_(\u00e2\u02dc\u01924, p_83247_.m_82340_(\u00e2\u02dc\u01924) + 1.0E-7));
                \u00e2\u02dc\u019212 = Math.min(this.f_83211_.m_82850_(\u00e2\u02dc\u01924), this.m_6595_(\u00e2\u02dc\u01924, p_83247_.m_82374_(\u00e2\u02dc\u01924) - 1.0E-7) + 1);
                int \u00e2\u02dc\u019213 = this.f_83211_.m_82850_(\u00e2\u02dc\u01922);
                if (!(p_83248_ > 0.0)) break block10;
                for (int i = \u00e2\u02dc\u01928 + 1; i < \u00e2\u02dc\u019213; ++i) {
                    for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01929; \u00e2\u02dc\u0192 < \u00e2\u02dc\u019210; ++\u00e2\u02dc\u0192) {
                        for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u019211; \u00e2\u02dc\u0192 < \u00e2\u02dc\u019212; ++\u00e2\u02dc\u0192) {
                            if (!this.f_83211_.m_82822_(axisCycle, i, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)) continue;
                            double d = this.m_83256_(\u00e2\u02dc\u01922, i) - \u00e2\u02dc\u01925;
                            if (d >= -1.0E-7) {
                                p_83248_ = Math.min(p_83248_, d);
                            }
                            return p_83248_;
                        }
                    }
                }
                break block11;
            }
            if (!(p_83248_ < 0.0)) break block11;
            for (int i = \u00e2\u02dc\u01927 - 1; i >= 0; --i) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01929; \u00e2\u02dc\u0192 < \u00e2\u02dc\u019210; ++\u00e2\u02dc\u0192) {
                    for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u019211; \u00e2\u02dc\u0192 < \u00e2\u02dc\u019212; ++\u00e2\u02dc\u0192) {
                        if (!this.f_83211_.m_82822_(axisCycle, i, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192)) continue;
                        double d = this.m_83256_(\u00e2\u02dc\u01922, i + 1) - \u00e2\u02dc\u01926;
                        if (d <= 1.0E-7) {
                            p_83248_ = Math.max(p_83248_, d);
                        }
                        return p_83248_;
                    }
                }
            }
        }
        return p_83248_;
    }

    public String toString() {
        return this.m_83281_() ? "EMPTY" : "VoxelShape[" + this.m_83215_() + "]";
    }
}

