/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ScoreboardSaveData
extends SavedData {
    public static final String f_166099_ = "scoreboard";
    private final Scoreboard f_83509_;

    public ScoreboardSaveData(Scoreboard p_166101_) {
        this.f_83509_ = p_166101_;
    }

    public ScoreboardSaveData m_166102_(CompoundTag p_166103_) {
        this.m_83528_(p_166103_.m_128437_("Objectives", 10));
        this.f_83509_.m_83445_(p_166103_.m_128437_("PlayerScores", 10));
        if (p_166103_.m_128425_("DisplaySlots", 10)) {
            this.m_83530_(p_166103_.m_128469_("DisplaySlots"));
        }
        if (p_166103_.m_128425_("Teams", 9)) {
            this.m_83524_(p_166103_.m_128437_("Teams", 10));
        }
        return this;
    }

    private void m_83524_(ListTag p_83525_) {
        for (int i = 0; i < p_83525_.size(); ++i) {
            Team.CollisionRule collisionRule;
            Team.Visibility visibility;
            Team.Visibility visibility2;
            MutableComponent mutableComponent;
            MutableComponent mutableComponent2;
            CompoundTag compoundTag = p_83525_.m_128728_(i);
            String \u00e2\u02dc\u01922 = compoundTag.m_128461_("Name");
            if (\u00e2\u02dc\u01922.length() > 16) {
                \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.substring(0, 16);
            }
            PlayerTeam \u00e2\u02dc\u01923 = this.f_83509_.m_83492_(\u00e2\u02dc\u01922);
            MutableComponent \u00e2\u02dc\u01924 = Component.Serializer.m_130701_(compoundTag.m_128461_("DisplayName"));
            if (\u00e2\u02dc\u01924 != null) {
                \u00e2\u02dc\u01923.m_83353_(\u00e2\u02dc\u01924);
            }
            if (compoundTag.m_128425_("TeamColor", 8)) {
                \u00e2\u02dc\u01923.m_83351_(ChatFormatting.m_126657_(compoundTag.m_128461_("TeamColor")));
            }
            if (compoundTag.m_128425_("AllowFriendlyFire", 99)) {
                \u00e2\u02dc\u01923.m_83355_(compoundTag.m_128471_("AllowFriendlyFire"));
            }
            if (compoundTag.m_128425_("SeeFriendlyInvisibles", 99)) {
                \u00e2\u02dc\u01923.m_83362_(compoundTag.m_128471_("SeeFriendlyInvisibles"));
            }
            if (compoundTag.m_128425_("MemberNamePrefix", 8) && (mutableComponent2 = Component.Serializer.m_130701_(compoundTag.m_128461_("MemberNamePrefix"))) != null) {
                \u00e2\u02dc\u01923.m_83360_(mutableComponent2);
            }
            if (compoundTag.m_128425_("MemberNameSuffix", 8) && (mutableComponent = Component.Serializer.m_130701_(compoundTag.m_128461_("MemberNameSuffix"))) != null) {
                \u00e2\u02dc\u01923.m_83365_(mutableComponent);
            }
            if (compoundTag.m_128425_("NameTagVisibility", 8) && (visibility2 = Team.Visibility.m_83579_(compoundTag.m_128461_("NameTagVisibility"))) != null) {
                \u00e2\u02dc\u01923.m_83346_(visibility2);
            }
            if (compoundTag.m_128425_("DeathMessageVisibility", 8) && (visibility = Team.Visibility.m_83579_(compoundTag.m_128461_("DeathMessageVisibility"))) != null) {
                \u00e2\u02dc\u01923.m_83358_(visibility);
            }
            if (compoundTag.m_128425_("CollisionRule", 8) && (collisionRule = Team.CollisionRule.m_83555_(compoundTag.m_128461_("CollisionRule"))) != null) {
                \u00e2\u02dc\u01923.m_83344_(collisionRule);
            }
            this.m_83514_(\u00e2\u02dc\u01923, compoundTag.m_128437_("Players", 8));
        }
    }

    private void m_83514_(PlayerTeam p_83515_, ListTag p_83516_) {
        for (int i = 0; i < p_83516_.size(); ++i) {
            this.f_83509_.m_6546_(p_83516_.m_128778_(i), p_83515_);
        }
    }

    private void m_83530_(CompoundTag p_83531_) {
        for (int i = 0; i < 19; ++i) {
            if (!p_83531_.m_128425_("slot_" + i, 8)) continue;
            String string = p_83531_.m_128461_("slot_" + i);
            Objective \u00e2\u02dc\u01922 = this.f_83509_.m_83477_(string);
            this.f_83509_.m_7136_(i, \u00e2\u02dc\u01922);
        }
    }

    private void m_83528_(ListTag p_83529_) {
        for (int i = 0; i < p_83529_.size(); ++i) {
            CompoundTag compoundTag = p_83529_.m_128728_(i);
            ObjectiveCriteria.m_83614_(compoundTag.m_128461_("CriteriaName")).ifPresent(p_83523_ -> {
                String string = compoundTag.m_128461_("Name");
                if (string.length() > 16) {
                    string = string.substring(0, 16);
                }
                MutableComponent \u00e2\u02dc\u01922 = Component.Serializer.m_130701_(compoundTag.m_128461_("DisplayName"));
                ObjectiveCriteria.RenderType \u00e2\u02dc\u01923 = ObjectiveCriteria.RenderType.m_83634_(compoundTag.m_128461_("RenderType"));
                this.f_83509_.m_83436_(string, (ObjectiveCriteria)p_83523_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
            });
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag p_83527_) {
        p_83527_.m_128365_("Objectives", this.m_83534_());
        p_83527_.m_128365_("PlayerScores", this.f_83509_.m_83497_());
        p_83527_.m_128365_("Teams", this.m_83513_());
        this.m_83532_(p_83527_);
        return p_83527_;
    }

    private ListTag m_83513_() {
        ListTag listTag = new ListTag();
        Collection<PlayerTeam> \u00e2\u02dc\u01922 = this.f_83509_.m_83491_();
        for (PlayerTeam playerTeam : \u00e2\u02dc\u01922) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("Name", playerTeam.m_5758_());
            compoundTag.m_128359_("DisplayName", Component.Serializer.m_130703_(playerTeam.m_83364_()));
            if (playerTeam.m_7414_().m_126656_() >= 0) {
                compoundTag.m_128359_("TeamColor", playerTeam.m_7414_().m_126666_());
            }
            compoundTag.m_128379_("AllowFriendlyFire", playerTeam.m_6260_());
            compoundTag.m_128379_("SeeFriendlyInvisibles", playerTeam.m_6259_());
            compoundTag.m_128359_("MemberNamePrefix", Component.Serializer.m_130703_(playerTeam.m_83370_()));
            compoundTag.m_128359_("MemberNameSuffix", Component.Serializer.m_130703_(playerTeam.m_83371_()));
            compoundTag.m_128359_("NameTagVisibility", playerTeam.m_7470_().f_83567_);
            compoundTag.m_128359_("DeathMessageVisibility", playerTeam.m_7468_().f_83567_);
            compoundTag.m_128359_("CollisionRule", playerTeam.m_7156_().f_83543_);
            ListTag \u00e2\u02dc\u01923 = new ListTag();
            for (String string : playerTeam.m_6809_()) {
                \u00e2\u02dc\u01923.add(StringTag.m_129297_(string));
            }
            compoundTag.m_128365_("Players", \u00e2\u02dc\u01923);
            listTag.add(compoundTag);
        }
        return listTag;
    }

    private void m_83532_(CompoundTag p_83533_) {
        CompoundTag compoundTag = new CompoundTag();
        boolean \u00e2\u02dc\u01922 = false;
        for (int i = 0; i < 19; ++i) {
            Objective objective = this.f_83509_.m_83416_(i);
            if (objective == null) continue;
            compoundTag.m_128359_("slot_" + i, objective.m_83320_());
            \u00e2\u02dc\u01922 = true;
        }
        if (\u00e2\u02dc\u01922) {
            p_83533_.m_128365_("DisplaySlots", compoundTag);
        }
    }

    private ListTag m_83534_() {
        ListTag listTag = new ListTag();
        Collection<Objective> \u00e2\u02dc\u01922 = this.f_83509_.m_83466_();
        for (Objective objective : \u00e2\u02dc\u01922) {
            if (objective.m_83321_() == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("Name", objective.m_83320_());
            compoundTag.m_128359_("CriteriaName", objective.m_83321_().m_83620_());
            compoundTag.m_128359_("DisplayName", Component.Serializer.m_130703_(objective.m_83322_()));
            compoundTag.m_128359_("RenderType", objective.m_83324_().m_83633_());
            listTag.add(compoundTag);
        }
        return listTag;
    }
}

