/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.bootstraplauncher;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class BootstrapLauncher {
    private static final boolean DEBUG = System.getProperties().containsKey("bsl.debug");

    public static void main(String[] args) {
        List<String> legacyCP = BootstrapLauncher.loadLegacyClassPath();
        System.setProperty("legacyClassPath", String.join((CharSequence)File.pathSeparator, legacyCP));
        String ignoreList = System.getProperty("ignoreList", "asm,securejarhandler");
        String[] ignores = ignoreList.split(",");
        HashSet previousPkgs = new HashSet();
        ArrayList<SecureJar> jars = new ArrayList<SecureJar>();
        Map<String, Integer> filenameMap = BootstrapLauncher.getMergeFilenameMap();
        HashMap<Integer, List> mergeMap = new HashMap<Integer, List>();
        block0: for (String legacy : legacyCP) {
            Path path = Paths.get(legacy, new String[0]);
            String filename = path.getFileName().toString();
            for (String filter : ignores) {
                if (!filename.startsWith(filter)) continue;
                if (!DEBUG) continue block0;
                System.out.println(legacy + " IGNORED: " + filter);
                continue block0;
            }
            if (DEBUG) {
                System.out.println(path);
            }
            if (filenameMap.containsKey(filename)) {
                mergeMap.computeIfAbsent(filenameMap.get(filename), k -> new ArrayList()).add(path);
                continue;
            }
            SecureJar jar = SecureJar.from((BiPredicate)new PkgTracker(Set.copyOf(previousPkgs), path), (Path[])new Path[]{path});
            Set pkgs = jar.getPackages();
            if (DEBUG) {
                pkgs.forEach(p -> System.out.println("  " + p));
            }
            previousPkgs.addAll(pkgs);
            jars.add(jar);
        }
        mergeMap.forEach((idx, paths) -> {
            Path[] pathsArray = (Path[])paths.toArray(Path[]::new);
            SecureJar jar = SecureJar.from((BiPredicate)new PkgTracker(Set.copyOf(previousPkgs), pathsArray), (Path[])pathsArray);
            Set pkgs = jar.getPackages();
            if (DEBUG) {
                paths.forEach(System.out::println);
                pkgs.forEach(p -> System.out.println("  " + p));
            }
            previousPkgs.addAll(pkgs);
            jars.add(jar);
        });
        SecureJar[] finder = (SecureJar[])jars.toArray(SecureJar[]::new);
        List<String> alltargets = Arrays.stream(finder).map(SecureJar::name).toList();
        JarModuleFinder jf = JarModuleFinder.of((SecureJar[])finder);
        Configuration cf = ModuleLayer.boot().configuration();
        Configuration newcf = cf.resolveAndBind((ModuleFinder)jf, ModuleFinder.ofSystem(), alltargets);
        ModuleClassLoader mycl = new ModuleClassLoader("MC-BOOTSTRAP", newcf, List.of(ModuleLayer.boot()));
        ModuleLayer.Controller layer = ModuleLayer.defineModules(newcf, List.of(ModuleLayer.boot()), m -> mycl);
        Thread.currentThread().setContextClassLoader((ClassLoader)mycl);
        ServiceLoader<Consumer> loader = ServiceLoader.load(layer.layer(), Consumer.class);
        loader.stream().findFirst().orElseThrow().get().accept(args);
    }

    private static Map<String, Integer> getMergeFilenameMap() {
        String mergeModules = System.getProperty("mergeModules");
        if (mergeModules == null) {
            return Map.of();
        }
        HashMap<String, Integer> filenameMap = new HashMap<String, Integer>();
        int i = 0;
        for (String merge : mergeModules.split(";")) {
            String[] targets;
            for (String target : targets = merge.split(",")) {
                filenameMap.put(target, i);
            }
            ++i;
        }
        return filenameMap;
    }

    private static List<String> loadLegacyClassPath() {
        Path legacyCPFileCandidatePath;
        String legacyCpPath = System.getProperty("legacyClassPath.file");
        if (legacyCpPath != null && Files.exists(legacyCPFileCandidatePath = Paths.get(legacyCpPath, new String[0]), new LinkOption[0]) && Files.isRegularFile(legacyCPFileCandidatePath, new LinkOption[0])) {
            try {
                return Files.readAllLines(legacyCPFileCandidatePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load the legacy class path from the specified file: " + legacyCpPath, e);
            }
        }
        return Arrays.asList(Objects.requireNonNull(System.getProperty("legacyClassPath", System.getProperty("java.class.path")), "Missing legacyClassPath, cannot bootstrap").split(File.pathSeparator));
    }

    private record PkgTracker(Set<String> packages, Path[] paths) implements BiPredicate<String, String>
    {
        @Override
        public boolean test(String path, String basePath) {
            if (this.packages.isEmpty() || path.startsWith("META-INF/")) {
                return true;
            }
            int idx = path.lastIndexOf(47);
            return idx < 0 || idx == path.length() - 1 || !this.packages.contains(path.substring(0, idx).replace('/', '.'));
        }
    }
}

