/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.ClassTransformer;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformerAuditTrail;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.lang.module.Configuration;
import java.util.List;

public class TransformingClassLoader
extends ModuleClassLoader {
    private final ClassTransformer classTransformer;

    public TransformingClassLoader(TransformStore transformStore, LaunchPluginHandler pluginHandler, ModuleLayerHandler moduleLayerHandler) {
        super("TRANSFORMER", moduleLayerHandler.getLayer(IModuleLayerManager.Layer.GAME).orElseThrow().configuration(), List.of(moduleLayerHandler.getLayer(IModuleLayerManager.Layer.SERVICE).orElseThrow()));
        this.classTransformer = new ClassTransformer(transformStore, pluginHandler, this);
    }

    TransformingClassLoader(TransformStore transformStore, LaunchPluginHandler pluginHandler, TransformingClassLoaderBuilder builder, Environment environment, Configuration configuration, List<ModuleLayer> parentLayers) {
        super("TRANSFORMER", configuration, parentLayers);
        TransformerAuditTrail tat = new TransformerAuditTrail();
        environment.computePropertyIfAbsent(IEnvironment.Keys.AUDITTRAIL.get(), v -> tat);
        this.classTransformer = new ClassTransformer(transformStore, pluginHandler, this, tat);
    }

    protected byte[] maybeTransformClassBytes(byte[] bytes, String name, String context) {
        return this.classTransformer.transform(bytes, name, context != null ? context : "classloading");
    }

    public Class<?> getLoadedClass(String name) {
        return this.findLoadedClass(name);
    }

    byte[] buildTransformedClassNodeFor(String className, String reason) throws ClassNotFoundException {
        return super.getMaybeTransformedClassBytes(className, reason);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

