/*
 * Decompiled with CFR 0.152.
 */
package argo.saj;

import argo.saj.InvalidSyntaxException;
import argo.saj.JsonListener;
import argo.saj.PositionTrackingPushbackReader;
import argo.saj.ThingWithPosition;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public final class SajParser {
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACK_SLASH = '\\';
    private static final char BACKSPACE = '\b';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char FORM_FEED = '\f';

    public void parse(Reader in2, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        PositionTrackingPushbackReader pushbackReader = new PositionTrackingPushbackReader(in2);
        char nextChar = (char)pushbackReader.read();
        switch (nextChar) {
            case '{': {
                pushbackReader.unread(nextChar);
                jsonListener.startDocument();
                this.objectString(pushbackReader, jsonListener);
                break;
            }
            case '[': {
                pushbackReader.unread(nextChar);
                jsonListener.startDocument();
                this.arrayString(pushbackReader, jsonListener);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected either [ or { but got [" + nextChar + "].", pushbackReader);
            }
        }
        int trailingCharacter = this.readNextNonWhitespaceChar(pushbackReader);
        if (trailingCharacter != -1) {
            throw new InvalidSyntaxException("Got unexpected trailing character [" + (char)trailingCharacter + "].", pushbackReader);
        }
        jsonListener.endDocument();
    }

    private void arrayString(PositionTrackingPushbackReader pushbackReader, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        char firstChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        if (firstChar != '[') {
            throw new InvalidSyntaxException("Expected object to start with [ but got [" + firstChar + "].", pushbackReader);
        }
        jsonListener.startArray();
        char secondChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        pushbackReader.unread(secondChar);
        if (secondChar != ']') {
            this.aJsonValue(pushbackReader, jsonListener);
        }
        boolean gotEndOfArray = false;
        block4: while (!gotEndOfArray) {
            char nextChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
            switch (nextChar) {
                case ',': {
                    this.aJsonValue(pushbackReader, jsonListener);
                    continue block4;
                }
                case ']': {
                    gotEndOfArray = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or ] but got [" + nextChar + "].", pushbackReader);
        }
        jsonListener.endArray();
    }

    private void objectString(PositionTrackingPushbackReader pushbackReader, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        char firstChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        if (firstChar != '{') {
            throw new InvalidSyntaxException("Expected object to start with { but got [" + firstChar + "].", pushbackReader);
        }
        jsonListener.startObject();
        char secondChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        pushbackReader.unread(secondChar);
        if (secondChar != '}') {
            this.aFieldToken(pushbackReader, jsonListener);
        }
        boolean gotEndOfObject = false;
        block4: while (!gotEndOfObject) {
            char nextChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
            switch (nextChar) {
                case ',': {
                    this.aFieldToken(pushbackReader, jsonListener);
                    continue block4;
                }
                case '}': {
                    gotEndOfObject = true;
                    continue block4;
                }
            }
            throw new InvalidSyntaxException("Expected either , or } but got [" + nextChar + "].", pushbackReader);
        }
        jsonListener.endObject();
    }

    private void aFieldToken(PositionTrackingPushbackReader pushbackReader, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        char nextChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        if ('\"' != nextChar) {
            throw new InvalidSyntaxException("Expected object identifier to begin with [\"] but got [" + nextChar + "].", pushbackReader);
        }
        pushbackReader.unread(nextChar);
        jsonListener.startField(this.stringToken(pushbackReader));
        char separatorChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        if (separatorChar != ':') {
            throw new InvalidSyntaxException("Expected object identifier to be followed by : but got [" + separatorChar + "].", pushbackReader);
        }
        this.aJsonValue(pushbackReader, jsonListener);
        jsonListener.endField();
    }

    private void aJsonValue(PositionTrackingPushbackReader pushbackReader, JsonListener jsonListener) throws IOException, InvalidSyntaxException {
        char nextChar = (char)this.readNextNonWhitespaceChar(pushbackReader);
        switch (nextChar) {
            case '\"': {
                pushbackReader.unread(nextChar);
                jsonListener.stringValue(this.stringToken(pushbackReader));
                break;
            }
            case 't': {
                char[] remainingTrueTokenCharacters = new char[3];
                int trueTokenCharactersRead = pushbackReader.read(remainingTrueTokenCharacters);
                if (trueTokenCharactersRead != 3 || remainingTrueTokenCharacters[0] != 'r' || remainingTrueTokenCharacters[1] != 'u' || remainingTrueTokenCharacters[2] != 'e') {
                    pushbackReader.uncount(remainingTrueTokenCharacters);
                    throw new InvalidSyntaxException("Expected 't' to be followed by [[r, u, e]], but got [" + Arrays.toString(remainingTrueTokenCharacters) + "].", pushbackReader);
                }
                jsonListener.trueValue();
                break;
            }
            case 'f': {
                char[] remainingFalseTokenCharacters = new char[4];
                int falseTokenCharactersRead = pushbackReader.read(remainingFalseTokenCharacters);
                if (falseTokenCharactersRead != 4 || remainingFalseTokenCharacters[0] != 'a' || remainingFalseTokenCharacters[1] != 'l' || remainingFalseTokenCharacters[2] != 's' || remainingFalseTokenCharacters[3] != 'e') {
                    pushbackReader.uncount(remainingFalseTokenCharacters);
                    throw new InvalidSyntaxException("Expected 'f' to be followed by [[a, l, s, e]], but got [" + Arrays.toString(remainingFalseTokenCharacters) + "].", pushbackReader);
                }
                jsonListener.falseValue();
                break;
            }
            case 'n': {
                char[] remainingNullTokenCharacters = new char[3];
                int nullTokenCharactersRead = pushbackReader.read(remainingNullTokenCharacters);
                if (nullTokenCharactersRead != 3 || remainingNullTokenCharacters[0] != 'u' || remainingNullTokenCharacters[1] != 'l' || remainingNullTokenCharacters[2] != 'l') {
                    pushbackReader.uncount(remainingNullTokenCharacters);
                    throw new InvalidSyntaxException("Expected 'n' to be followed by [[u, l, l]], but got [" + Arrays.toString(remainingNullTokenCharacters) + "].", pushbackReader);
                }
                jsonListener.nullValue();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                pushbackReader.unread(nextChar);
                jsonListener.numberValue(this.numberToken(pushbackReader));
                break;
            }
            case '{': {
                pushbackReader.unread(nextChar);
                this.objectString(pushbackReader, jsonListener);
                break;
            }
            case '[': {
                pushbackReader.unread(nextChar);
                this.arrayString(pushbackReader, jsonListener);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Invalid character at start of value [" + nextChar + "].", pushbackReader);
            }
        }
    }

    private String numberToken(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)in2.read();
        if ('-' == firstChar) {
            result.append('-');
        } else {
            in2.unread(firstChar);
        }
        result.append(this.nonNegativeNumberToken(in2));
        return result.toString();
    }

    private String nonNegativeNumberToken(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)in2.read();
        if ('0' == firstChar) {
            result.append('0');
            result.append(this.possibleFractionalComponent(in2));
            result.append(this.possibleExponent(in2));
        } else {
            in2.unread(firstChar);
            result.append(this.nonZeroDigitToken(in2));
            result.append(this.digitString(in2));
            result.append(this.possibleFractionalComponent(in2));
            result.append(this.possibleExponent(in2));
        }
        return result.toString();
    }

    private char nonZeroDigitToken(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        char result;
        char nextChar = (char)in2.read();
        switch (nextChar) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = nextChar;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + nextChar + "].", in2);
            }
        }
        return result;
    }

    private char digitToken(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        char result;
        char nextChar = (char)in2.read();
        switch (nextChar) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = nextChar;
                break;
            }
            default: {
                throw new InvalidSyntaxException("Expected a digit 1 - 9 but got [" + nextChar + "].", in2);
            }
        }
        return result;
    }

    private String digitString(PositionTrackingPushbackReader in2) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean gotANonDigit = false;
        block3: while (!gotANonDigit) {
            char nextChar = (char)in2.read();
            switch (nextChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result.append(nextChar);
                    continue block3;
                }
            }
            gotANonDigit = true;
            in2.unread(nextChar);
        }
        return result.toString();
    }

    private String possibleFractionalComponent(PositionTrackingPushbackReader pushbackReader) throws IOException, InvalidSyntaxException {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)pushbackReader.read();
        if (firstChar == '.') {
            result.append('.');
            result.append(this.digitToken(pushbackReader));
            result.append(this.digitString(pushbackReader));
        } else {
            pushbackReader.unread(firstChar);
        }
        return result.toString();
    }

    private String possibleExponent(PositionTrackingPushbackReader pushbackReader) throws IOException, InvalidSyntaxException {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)pushbackReader.read();
        switch (firstChar) {
            case '.': 
            case 'E': {
                result.append('E');
                result.append(this.possibleSign(pushbackReader));
                result.append(this.digitToken(pushbackReader));
                result.append(this.digitString(pushbackReader));
                break;
            }
            case 'e': {
                result.append('e');
                result.append(this.possibleSign(pushbackReader));
                result.append(this.digitToken(pushbackReader));
                result.append(this.digitString(pushbackReader));
                break;
            }
            default: {
                pushbackReader.unread(firstChar);
            }
        }
        return result.toString();
    }

    private String possibleSign(PositionTrackingPushbackReader pushbackReader) throws IOException {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)pushbackReader.read();
        if (firstChar == '+' || firstChar == '-') {
            result.append(firstChar);
        } else {
            pushbackReader.unread(firstChar);
        }
        return result.toString();
    }

    private String stringToken(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        StringBuilder result = new StringBuilder();
        char firstChar = (char)in2.read();
        if ('\"' != firstChar) {
            throw new InvalidSyntaxException("Expected [\"] but got [" + firstChar + "].", in2);
        }
        ThingWithPosition openDoubleQuotesPosition = in2.snapshotOfPosition();
        boolean stringClosed = false;
        block5: while (!stringClosed) {
            char nextChar = (char)in2.read();
            switch (nextChar) {
                case '\uffff': {
                    throw new InvalidSyntaxException("Got opening [\"] without matching closing [\"]", openDoubleQuotesPosition);
                }
                case '\"': {
                    stringClosed = true;
                    continue block5;
                }
                case '\\': {
                    char escapedChar = this.escapedStringChar(in2);
                    result.append(escapedChar);
                    continue block5;
                }
            }
            result.append(nextChar);
        }
        return result.toString();
    }

    private char escapedStringChar(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        char result;
        char firstChar = (char)in2.read();
        switch (firstChar) {
            case '\"': {
                result = '\"';
                break;
            }
            case '\\': {
                result = '\\';
                break;
            }
            case '/': {
                result = '/';
                break;
            }
            case 'b': {
                result = '\b';
                break;
            }
            case 'f': {
                result = '\f';
                break;
            }
            case 'n': {
                result = '\n';
                break;
            }
            case 'r': {
                result = '\r';
                break;
            }
            case 't': {
                result = '\t';
                break;
            }
            case 'u': {
                result = (char)this.hexadecimalNumber(in2);
                break;
            }
            default: {
                throw new InvalidSyntaxException("Unrecognised escape character [" + firstChar + "].", in2);
            }
        }
        return result;
    }

    private int hexadecimalNumber(PositionTrackingPushbackReader in2) throws IOException, InvalidSyntaxException {
        int result;
        char[] resultCharArray = new char[4];
        int readSize = in2.read(resultCharArray);
        if (readSize != 4) {
            throw new InvalidSyntaxException("Expected a 4 digit hexadecimal number but got only [" + readSize + "], namely [" + String.valueOf(resultCharArray, 0, readSize) + "].", in2);
        }
        try {
            result = Integer.parseInt(String.valueOf(resultCharArray), 16);
        }
        catch (NumberFormatException e2) {
            in2.uncount(resultCharArray);
            throw new InvalidSyntaxException("Unable to parse [" + String.valueOf(resultCharArray) + "] as a hexadecimal number.", e2, in2);
        }
        return result;
    }

    private int readNextNonWhitespaceChar(PositionTrackingPushbackReader in2) throws IOException {
        int nextChar;
        boolean gotNonWhitespace = false;
        do {
            nextChar = in2.read();
            switch (nextChar) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    gotNonWhitespace = true;
                }
            }
        } while (!gotNonWhitespace);
        return nextChar;
    }
}

