/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Map;

public class TextureFXManager {
    private static final TextureFXManager INSTANCE = new TextureFXManager();
    private atv client;
    private Map<Integer, TextureHolder> texturesById = Maps.newHashMap();
    private Map<String, TextureHolder> texturesByName = Maps.newHashMap();

    void setClient(atv client) {
        this.client = client;
    }

    public static TextureFXManager instance() {
        return INSTANCE;
    }

    public void fixTransparency(BufferedImage loadedImage, String textureName) {
        if (textureName.matches("^/mob/.*_eyes.*.png$")) {
            for (int x = 0; x < loadedImage.getWidth(); ++x) {
                for (int y = 0; y < loadedImage.getHeight(); ++y) {
                    int argb = loadedImage.getRGB(x, y);
                    if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                    loadedImage.setRGB(x, y, 0);
                }
            }
        }
    }

    public void bindTextureToName(String name, int index) {
        TextureHolder holder = new TextureHolder();
        holder.textureId = index;
        holder.textureName = name;
        this.texturesById.put(index, holder);
        this.texturesByName.put(name, holder);
    }

    public void setTextureDimensions(int index, int j, int k) {
        TextureHolder holder = this.texturesById.get(index);
        if (holder == null) {
            return;
        }
        holder.x = j;
        holder.y = k;
    }

    public Dimension getTextureDimensions(String texture) {
        return this.texturesByName.containsKey(texture) ? new Dimension(this.texturesByName.get(texture).x, this.texturesByName.get(texture).y) : new Dimension(1, 1);
    }

    private class TextureHolder {
        private int textureId;
        private String textureName;
        private int x;
        private int y;

        private TextureHolder() {
        }
    }
}

