/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraftforge.client.settings.KeyModifier;

public class KeyBindingMap {
    private static final EnumMap<KeyModifier, oi<Collection<bca>>> map = new EnumMap(KeyModifier.class);

    public bca lookupActive(int keyCode) {
        bca binding;
        KeyModifier activeModifier = KeyModifier.getActiveModifier();
        if (!activeModifier.matches(keyCode) && (binding = this.getBinding(keyCode, activeModifier)) != null) {
            return binding;
        }
        return this.getBinding(keyCode, KeyModifier.NONE);
    }

    private bca getBinding(int keyCode, KeyModifier keyModifier) {
        Collection bindings = (Collection)map.get((Object)keyModifier).a(keyCode);
        if (bindings != null) {
            for (bca binding : bindings) {
                if (!binding.isActiveAndMatches(keyCode)) continue;
                return binding;
            }
        }
        return null;
    }

    public List<bca> lookupAll(int keyCode) {
        ArrayList<bca> matchingBindings = new ArrayList<bca>();
        for (oi<Collection<bca>> bindingsMap : map.values()) {
            Collection bindings = (Collection)bindingsMap.a(keyCode);
            if (bindings == null) continue;
            matchingBindings.addAll(bindings);
        }
        return matchingBindings;
    }

    public void addKey(int keyCode, bca keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        oi<Collection<bca>> bindingsMap = map.get((Object)keyModifier);
        ArrayList<bca> bindingsForKey = (ArrayList<bca>)bindingsMap.a(keyCode);
        if (bindingsForKey == null) {
            bindingsForKey = new ArrayList<bca>();
            bindingsMap.a(keyCode, bindingsForKey);
        }
        bindingsForKey.add(keyBinding);
    }

    public void removeKey(bca keyBinding) {
        KeyModifier keyModifier = keyBinding.getKeyModifier();
        int keyCode = keyBinding.j();
        oi<Collection<bca>> bindingsMap = map.get((Object)keyModifier);
        Collection bindingsForKey = (Collection)bindingsMap.a(keyCode);
        if (bindingsForKey != null) {
            bindingsForKey.remove(keyBinding);
            if (bindingsForKey.isEmpty()) {
                bindingsMap.d(keyCode);
            }
        }
    }

    public void clearMap() {
        for (oi<Collection<bca>> bindings : map.values()) {
            bindings.c();
        }
    }

    static {
        for (KeyModifier modifier : KeyModifier.values()) {
            map.put(modifier, (oi<Collection<bca>>)new oi());
        }
    }
}

