/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends ado
implements IFluidContainerItem {
    private final int capacity;
    private final adq empty;
    private final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, new adq(ads.ay), false);
    }

    public UniversalBucket(int capacity, adq empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.d(1);
        this.a(acq.f);
        aku.c.a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    @SideOnly(value=Side.CLIENT)
    public void a(ado itemIn, acq tab, List<adq> subItems) {
        Iterator<Fluid> iterator = FluidRegistry.getRegisteredFluids().values().iterator();
        while (iterator.hasNext()) {
            adq stack = new adq((ado)this);
            Fluid fluid = iterator.next();
            FluidStack fs = new FluidStack(fluid, this.getCapacity());
            if (this.fill(stack, fs, true) != fs.amount) continue;
            subItems.add(stack);
        }
    }

    public String a(adq stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (this.getEmpty() != null) {
                return this.getEmpty().q();
            }
            return super.a(stack);
        }
        String unloc = this.j(stack);
        if (dk.c((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return dk.a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return dk.a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public qp<adq> a(adq itemstack, aht world, zj player, qm hand) {
        cl targetPos;
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return qp.newResult((qo)qo.b, (Object)itemstack);
        }
        bbg mop = this.a(world, player, false);
        if (mop == null || mop.a != bbg.a.b) {
            return qp.newResult((qo)qo.b, (Object)itemstack);
        }
        cl clickPos = mop.a();
        if (world.a(player, clickPos) && player.a(targetPos = clickPos.a(mop.b), mop.b, itemstack) && FluidUtil.tryPlaceFluid(player, player.e(), fluidStack, targetPos) && !player.bK.d) {
            adq emptyStack;
            player.b(nu.b((ado)this));
            --itemstack.b;
            adq adq2 = emptyStack = this.getEmpty() != null ? this.getEmpty().k() : new adq((ado)this);
            if (itemstack.b <= 0) {
                return qp.newResult((qo)qo.a, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return qp.newResult((qo)qo.a, (Object)itemstack);
        }
        return qp.newResult((qo)qo.c, (Object)itemstack);
    }

    @Deprecated
    public boolean tryPlaceFluid(ajt block, aht worldIn, cl pos) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return FluidUtil.tryPlaceFluid(null, worldIn, new FluidStack(fluidBlock.getFluid(), 1000), pos);
        }
        if (block.u().a() == axe.h) {
            FluidUtil.tryPlaceFluid(null, worldIn, new FluidStack(FluidRegistry.WATER, 1000), pos);
        } else if (block.u().a() == axe.i) {
            FluidUtil.tryPlaceFluid(null, worldIn, new FluidStack(FluidRegistry.LAVA, 1000), pos);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        adq emptyBucket = event.getEmptyBucket();
        if (emptyBucket == null || !emptyBucket.a(this.getEmpty()) || this.isNbtSensitive() && adq.a((adq)emptyBucket, (adq)this.getEmpty())) {
            return;
        }
        bbg target = event.getTarget();
        if (target == null || target.a != bbg.a.b) {
            return;
        }
        aht world = event.getWorld();
        cl pos = target.a();
        adq singleBucket = emptyBucket.k();
        singleBucket.b = 1;
        adq filledBucket = FluidUtil.tryPickUpFluid(singleBucket, event.getEntityPlayer(), world, pos, target.b);
        if (filledBucket != null) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledBucket);
        } else {
            event.setCanceled(true);
        }
    }

    public static adq getFilledBucket(UniversalBucket item, Fluid fluid) {
        adq stack = new adq((ado)item);
        item.fill(stack, new FluidStack(fluid, item.getCapacity()), true);
        return stack;
    }

    @Override
    public FluidStack getFluid(adq container) {
        return FluidStack.loadFluidStackFromNBT(container.o());
    }

    @Override
    public int getCapacity(adq container) {
        return this.getCapacity();
    }

    @Override
    public int fill(adq container, FluidStack resource, boolean doFill) {
        if (container.b != 1) {
            return 0;
        }
        if (resource == null || resource.amount < this.getCapacity()) {
            return 0;
        }
        if (this.getFluid(container) != null) {
            return 0;
        }
        if (FluidRegistry.getBucketFluids().contains(resource.getFluid())) {
            if (doFill) {
                dq tag = container.o();
                if (tag == null) {
                    tag = new dq();
                }
                resource.writeToNBT(tag);
                container.d(tag);
            }
            return this.getCapacity();
        }
        if (resource.getFluid() == FluidRegistry.WATER) {
            if (doFill) {
                container.deserializeNBT(new adq(ads.az).serializeNBT());
            }
            return this.getCapacity();
        }
        if (resource.getFluid() == FluidRegistry.LAVA) {
            if (doFill) {
                container.deserializeNBT(new adq(ads.aA).serializeNBT());
            }
            return this.getCapacity();
        }
        return 0;
    }

    @Override
    public FluidStack drain(adq container, int maxDrain, boolean doDrain) {
        if (container.b != 1) {
            return null;
        }
        if (maxDrain < this.getCapacity(container)) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (doDrain && fluidStack != null) {
            if (this.getEmpty() != null) {
                container.deserializeNBT(this.getEmpty().serializeNBT());
            } else {
                container.b = 0;
            }
        }
        return fluidStack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public adq getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }

    public ICapabilityProvider initCapabilities(adq stack, dq nbt) {
        return new FluidBucketWrapper(stack);
    }
}

