/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Throwables;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import org.apache.logging.log4j.Level;

public class EntitySpawnHandler
extends SimpleChannelInboundHandler<FMLMessage.EntityMessage> {
    protected void channelRead0(ChannelHandlerContext ctx, final FMLMessage.EntityMessage msg) throws Exception {
        qc thread = FMLCommonHandler.instance().getWorldThread((er)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        if (thread.aE()) {
            this.process(msg);
        } else {
            thread.a(new Runnable(){

                @Override
                public void run() {
                    EntitySpawnHandler.this.process(msg);
                }
            });
        }
    }

    private void process(FMLMessage.EntityMessage msg) {
        if (msg.getClass().equals(FMLMessage.EntitySpawnMessage.class)) {
            this.spawnEntity((FMLMessage.EntitySpawnMessage)msg);
        }
    }

    private void spawnEntity(FMLMessage.EntitySpawnMessage spawnMsg) {
        ModContainer mc2 = Loader.instance().getIndexedModList().get(spawnMsg.modId);
        EntityRegistry.EntityRegistration er2 = EntityRegistry.instance().lookupModSpawn(mc2, spawnMsg.modEntityTypeId);
        if (er2 == null) {
            throw new RuntimeException("Could not spawn mod entity ModID: " + spawnMsg.modId + " EntityID: " + spawnMsg.modEntityTypeId + " at ( " + spawnMsg.rawX + "," + spawnMsg.rawY + ", " + spawnMsg.rawZ + ") Please contact mod author or server admin.");
        }
        bks wc = FMLClientHandler.instance().getWorldClient();
        Class<? extends rr> cls = er2.getEntityClass();
        try {
            rr entity;
            if (er2.hasCustomSpawning()) {
                entity = er2.doCustomSpawning(spawnMsg);
            } else {
                rr[] parts;
                entity = cls.getConstructor(aht.class).newInstance(wc);
                int offset = spawnMsg.entityId - entity.O();
                entity.f(spawnMsg.entityId);
                entity.a(spawnMsg.entityUUID);
                entity.b(spawnMsg.rawX, spawnMsg.rawY, spawnMsg.rawZ, spawnMsg.scaledYaw, spawnMsg.scaledPitch);
                if (entity instanceof sb) {
                    ((sb)entity).aP = spawnMsg.scaledHeadYaw;
                }
                if ((parts = entity.aR()) != null) {
                    for (int j2 = 0; j2 < parts.length; ++j2) {
                        parts[j2].f(parts[j2].O() + offset);
                    }
                }
            }
            ln.a((rr)entity, (double)spawnMsg.rawX, (double)spawnMsg.rawY, (double)spawnMsg.rawZ);
            bmr clientPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (entity instanceof IThrowableEntity) {
                bmr thrower = clientPlayer.O() == spawnMsg.throwerId ? clientPlayer : wc.a(spawnMsg.throwerId);
                ((IThrowableEntity)entity).setThrower((rr)thrower);
            }
            if (spawnMsg.dataWatcherList != null) {
                entity.R().a(spawnMsg.dataWatcherList);
            }
            if (spawnMsg.throwerId > 0) {
                entity.i(spawnMsg.speedScaledX, spawnMsg.speedScaledY, spawnMsg.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)entity).readSpawnData(spawnMsg.dataStream);
            }
            wc.a(spawnMsg.entityId, entity);
        }
        catch (Exception e2) {
            FMLLog.log(Level.ERROR, e2, "A severe problem occurred during the spawning of an entity at ( " + spawnMsg.rawX + "," + spawnMsg.rawY + ", " + spawnMsg.rawZ + ")", new Object[0]);
            throw Throwables.propagate((Throwable)e2);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "EntitySpawnHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

