/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.EntitySpawnHandler;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.network.internal.FMLRuntimeCodec;
import net.minecraftforge.fml.common.network.internal.HandshakeCompletionHandler;
import net.minecraftforge.fml.common.network.internal.NetworkModHolder;
import net.minecraftforge.fml.common.network.internal.OpenGuiHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.core.helpers.Integers;

public class FMLNetworkHandler {
    public static final int READ_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.readTimeout", "30"), (int)30);
    public static final int LOGIN_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.loginTimeout", "600"), (int)600);
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void fmlServerHandshake(mn scm, em manager, ls player) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(manager, scm);
        dispatcher.serverToClientHandshake(player);
    }

    public static void fmlClientHandshake(em networkManager) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(networkManager);
        dispatcher.clientToServerHandshake();
    }

    public static void openGui(zj entityPlayer, Object mod, int modGuiId, aht world, int x, int y, int z) {
        ModContainer mc2 = FMLCommonHandler.instance().findContainerFor(mod);
        if (entityPlayer instanceof ls && !(entityPlayer instanceof FakePlayer)) {
            ls entityPlayerMP = (ls)entityPlayer;
            aau remoteGuiContainer = NetworkRegistry.INSTANCE.getRemoteGuiContainer(mc2, entityPlayerMP, modGuiId, world, x, y, z);
            if (remoteGuiContainer != null) {
                entityPlayerMP.de();
                entityPlayerMP.s();
                int windowId = entityPlayerMP.cl;
                FMLMessage.OpenGui openGui = new FMLMessage.OpenGui(windowId, mc2.getModId(), modGuiId, x, y, z);
                EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayerMP);
                embeddedChannel.writeOutbound(new Object[]{openGui});
                entityPlayerMP.bu = remoteGuiContainer;
                entityPlayerMP.bu.d = windowId;
                entityPlayerMP.bu.a((aba)entityPlayerMP);
            }
        } else if (!(entityPlayer instanceof FakePlayer)) {
            if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
                Object guiContainer = NetworkRegistry.INSTANCE.getLocalGuiContainer(mc2, entityPlayer, modGuiId, world, x, y, z);
                FMLCommonHandler.instance().showGuiScreen(guiContainer);
            } else {
                FMLLog.fine("Invalid attempt to open a local GUI on a dedicated server. This is likely a bug. GUI ID: %s,%d", mc2.getModId(), modGuiId);
            }
        }
    }

    public static fh<?> getEntitySpawningPacket(rr entity) {
        EntityRegistry.EntityRegistration er2 = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er2 == null) {
            return null;
        }
        if (er2.usesVanillaSpawning()) {
            return null;
        }
        return channelPair.get((Object)Side.SERVER).generatePacketFrom(new FMLMessage.EntitySpawnMessage(er2, entity, er2.getContainer()));
    }

    public static String checkModList(FMLHandshakeMessage.ModList modListPacket, Side side) {
        Map<String, String> modList = modListPacket.modList();
        return FMLNetworkHandler.checkModList(modList, side);
    }

    public static String checkModList(Map<String, String> listData, Side side) {
        ArrayList rejects = Lists.newArrayList();
        for (Map.Entry<ModContainer, NetworkModHolder> networkMod : NetworkRegistry.INSTANCE.registry().entrySet()) {
            boolean result = networkMod.getValue().check(listData, side);
            if (result) continue;
            rejects.add(networkMod.getKey());
        }
        if (rejects.isEmpty()) {
            return null;
        }
        FMLLog.info("Rejecting connection %s: %s", new Object[]{side, rejects});
        return String.format("Mod rejections %s", rejects);
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        ChannelPipeline pipeline = channelPair.get((Object)Side.CLIENT).pipeline();
        String targetName = channelPair.get((Object)Side.CLIENT).findChannelHandlerNameForType(FMLRuntimeCodec.class);
        pipeline.addAfter(targetName, "GuiHandler", (ChannelHandler)new OpenGuiHandler());
        pipeline.addAfter(targetName, "EntitySpawnHandler", (ChannelHandler)new EntitySpawnHandler());
    }

    public static void registerChannel(FMLContainer container, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(container, "FML", new ChannelHandler[]{new FMLRuntimeCodec(), new HandshakeCompletionHandler()});
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        if (side == Side.CLIENT) {
            FMLNetworkHandler.addClientHandlers();
        }
    }

    public static List<FMLProxyPacket> forwardHandshake(FMLMessage.CompleteHandshake push, NetworkDispatcher target, Side side) {
        channelPair.get((Object)side).attr(NetworkDispatcher.FML_DISPATCHER).set((Object)target);
        channelPair.get((Object)side).writeOutbound(new Object[]{push});
        ArrayList<FMLProxyPacket> list = new ArrayList<FMLProxyPacket>();
        for (Object o : channelPair.get((Object)side).outboundMessages()) {
            list.add((FMLProxyPacket)o);
        }
        channelPair.get((Object)side).outboundMessages().clear();
        return list;
    }

    public static void enhanceStatusQuery(JsonObject jsonobject) {
        JsonObject fmlData = new JsonObject();
        fmlData.addProperty("type", "FML");
        JsonArray modList = new JsonArray();
        for (ModContainer mc2 : Loader.instance().getActiveModList()) {
            JsonObject modData = new JsonObject();
            modData.addProperty("modid", mc2.getModId());
            modData.addProperty("version", mc2.getVersion());
            modList.add((JsonElement)modData);
        }
        fmlData.add("modList", (JsonElement)modList);
        jsonobject.add("modinfo", (JsonElement)fmlData);
    }
}

