/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class VanillaDoubleChestItemHandler
extends WeakReference<apx>
implements IItemHandlerModifiable {
    public static final VanillaDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new VanillaDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final apx mainChest;
    private final int hashCode;

    public VanillaDoubleChestItemHandler(apx mainChest, apx other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    public static VanillaDoubleChestItemHandler get(apx chest) {
        aht world = chest.D();
        cl pos = chest.v();
        if (world == null || pos == null || !world.e(pos)) {
            return null;
        }
        ajt blockType = chest.w();
        cs[] horizontals = cs.o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            apv otherTE;
            cs enumfacing = horizontals[i];
            cl blockpos = pos.a(enumfacing);
            ajt block = world.o(blockpos).t();
            if (block != blockType || !((otherTE = world.r(blockpos)) instanceof apx)) continue;
            apx otherChest = (apx)otherTE;
            return new VanillaDoubleChestItemHandler(chest, otherChest, enumfacing != cs.e && enumfacing != cs.c);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public apx getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    private apx getOtherChest() {
        apx tileEntityChest = (apx)this.get();
        return tileEntityChest != null && !tileEntityChest.x() ? tileEntityChest : null;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public adq getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        apx chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.a(targetSlot) : null;
    }

    @Override
    public void setStackInSlot(int slot, adq stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        apx chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
    }

    @Override
    public adq insertItem(int slot, adq stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        apx chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate) : stack;
    }

    @Override
    public adq extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        apx chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanillaDoubleChestItemHandler that = (VanillaDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        apx otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)this.mainChest, (Object)that.mainChest) && Objects.equal((Object)otherChest, (Object)that.getOtherChest());
        }
        return Objects.equal((Object)this.mainChest, (Object)that.getOtherChest()) && Objects.equal((Object)otherChest, (Object)that.mainChest);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        apx tileEntityChest = (apx)this.get();
        return tileEntityChest == null || tileEntityChest.x();
    }
}

