/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ApiUtils {
    public static final SetRestrictedField<Consumer<TileEntity>> disableTicking = new SetRestrictedField();

    @Deprecated
    public static boolean compareToOreName(ItemStack stack, ResourceLocation oreName) {
        return TagUtils.isInBlockOrItemTag(stack, oreName);
    }

    @Deprecated
    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return ItemUtils.stackMatchesObject(stack, o);
    }

    @Deprecated
    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        return ItemUtils.stackMatchesObject(stack, o, checkNBT);
    }

    @Deprecated
    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
    }

    @Deprecated
    public static boolean stacksMatchIngredientList(List<Ingredient> list, NonNullList<ItemStack> stacks) {
        return IngredientUtils.stacksMatchIngredientList(list, stacks);
    }

    @Deprecated
    public static boolean stacksMatchIngredientWithSizeList(List<IngredientWithSize> list, NonNullList<ItemStack> stacks) {
        return IngredientUtils.stacksMatchIngredientWithSizeList(list, stacks);
    }

    @Deprecated
    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return IngredientUtils.createIngredientFromList(list);
    }

    @Deprecated
    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy) {
        return ComparableItemStack.create(stack, copy);
    }

    @Deprecated
    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy, boolean useNbt) {
        return ComparableItemStack.create(stack, copy, useNbt);
    }

    public static JsonElement jsonSerializeFluidStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", fluidStack.getFluid().getRegistryName().toString());
        jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
        if (fluidStack.hasTag()) {
            jsonObject.addProperty("tag", fluidStack.getTag().toString());
        }
        return jsonObject;
    }

    public static FluidStack jsonDeserializeFluidStack(JsonObject jsonObject) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid")));
        int amount = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount");
        FluidStack fluidStack = new FluidStack(fluid, amount);
        if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"tag")) {
            fluidStack.setTag(JsonUtils.readNBT((JsonObject)jsonObject, (String)"tag"));
        }
        return fluidStack;
    }

    public static int getComponentIngotWorth(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String key = TagUtils.getMatchingPrefix(stack, keys);
        if (key != null && (relation = IEApi.prefixToIngotMap.get(key)) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return (int)val;
        }
        return 0;
    }

    public static ItemStack breakStackIntoIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String[] type = TagUtils.getMatchingPrefixAndRemaining(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return ApiUtils.copyStackWithAmount(IEApi.getPreferredTagStack(IETags.getIngot(type[1])), (int)val);
        }
        return ItemStack.field_190927_a;
    }

    public static Pair<ItemStack, Double> breakStackIntoPreciseIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String[] type = TagUtils.getMatchingPrefixAndRemaining(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return new ImmutablePair((Object)IEApi.getPreferredTagStack(IETags.getIngot(type[1])), (Object)val);
        }
        return null;
    }

    public static double getDim(Vector3d vec, int dim) {
        return dim == 0 ? vec.field_72450_a : (dim == 1 ? vec.field_72448_b : vec.field_72449_c);
    }

    public static <T extends Comparable<T>> Map<T, Integer> sortMap(Map<T, Integer> map, boolean inverse) {
        TreeMap<T, Integer> sortedMap = new TreeMap<T, Integer>(new ValueComparator<T>(map, inverse));
        sortedMap.putAll(map);
        return sortedMap;
    }

    public static <T extends TileEntity> void checkForNeedlessTicking(T te, Predicate<T> shouldDisable) {
        if (!te.func_145831_w().field_72995_K && shouldDisable.test(te)) {
            disableTicking.getValue().accept(te);
        }
    }

    public static void knockbackNoSource(LivingEntity entity, double strength, double xRatio, double zRatio) {
        entity.field_70160_al = true;
        Vector3d motionOld = entity.func_213322_ci();
        Vector3d toAdd = new Vector3d(xRatio, 0.0, zRatio).func_72432_b().func_186678_a(strength);
        entity.func_213293_j(motionOld.field_72450_a / 2.0 - toAdd.field_72450_a, entity.func_233570_aj_() ? Math.min(0.4, motionOld.field_72448_b / 2.0 + strength) : motionOld.field_72448_b, motionOld.field_72449_c / 2.0 - toAdd.field_72449_c);
    }

    public static void addFutureServerTask(World world, Runnable task, boolean forceFuture) {
        LogicalSide side = world.field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER;
        ThreadTaskExecutor tmp = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(side);
        if (forceFuture) {
            int tick = world.field_72995_K ? 0 : ((MinecraftServer)tmp).func_71259_af();
            tmp.func_212871_a_((Runnable)new TickDelayedTask(tick, task));
        } else {
            tmp.func_213165_a(task);
        }
    }

    public static void addFutureServerTask(World world, Runnable task) {
        ApiUtils.addFutureServerTask(world, task, false);
    }

    public static class ValueComparator<T extends Comparable<T>>
    implements Comparator<T> {
        Map<T, Integer> base;
        boolean inverse;

        public ValueComparator(Map<T, Integer> base, boolean inverse) {
            this.base = base;
            this.inverse = inverse;
        }

        @Override
        public int compare(T s0, T s1) {
            int v1;
            int v0 = this.base.get(s0);
            int ret = v0 > (v1 = this.base.get(s1).intValue()) ? -1 : (v0 < v1 ? 1 : s0.compareTo(s1));
            return ret * (this.inverse ? -1 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ValueComparator)) {
                return false;
            }
            ValueComparator other = (ValueComparator)obj;
            return other.base == this.base && other.inverse == this.inverse;
        }
    }
}

