/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;

public class IEFinishedRecipe<R extends IEFinishedRecipe<R>>
implements IFinishedRecipe {
    private final IERecipeSerializer<?> serializer;
    private final List<Consumer<JsonObject>> writerFunctions;
    private ResourceLocation id;
    protected JsonArray inputArray = null;
    protected int inputCount = 0;
    protected int maxInputCount = 1;
    protected JsonArray resultArray = null;
    protected int resultCount = 0;
    protected int maxResultCount = 1;
    protected JsonArray conditions = null;

    protected IEFinishedRecipe(IERecipeSerializer<?> serializer) {
        this.serializer = serializer;
        this.writerFunctions = new ArrayList<Consumer<JsonObject>>();
    }

    protected boolean isComplete() {
        return true;
    }

    public void build(Consumer<IFinishedRecipe> out, ResourceLocation id) {
        Preconditions.checkArgument((boolean)this.isComplete(), (Object)"This recipe is incomplete");
        this.id = id;
        out.accept(this);
    }

    public R addWriter(Consumer<JsonObject> writer) {
        Preconditions.checkArgument((this.id == null ? 1 : 0) != 0, (Object)"This recipe has already been finalized");
        this.writerFunctions.add(writer);
        return (R)this;
    }

    public R addCondition(ICondition condition) {
        if (this.conditions == null) {
            this.conditions = new JsonArray();
            this.addWriter(jsonObject -> jsonObject.add("conditions", (JsonElement)this.conditions));
        }
        this.conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        return (R)this;
    }

    public R setTime(int time) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("time", (Number)time));
    }

    public R setEnergy(int energy) {
        return this.addWriter(jsonObject -> jsonObject.addProperty("energy", (Number)energy));
    }

    public R setMultipleResults(int maxResultCount) {
        this.resultArray = new JsonArray();
        this.maxResultCount = maxResultCount;
        return this.addWriter(jsonObject -> jsonObject.add("results", (JsonElement)this.resultArray));
    }

    public R addMultiResult(JsonElement obj) {
        Preconditions.checkArgument((this.maxResultCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple results");
        Preconditions.checkArgument((this.resultCount < this.maxResultCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxResultCount + " results"));
        this.resultArray.add(obj);
        ++this.resultCount;
        return (R)this;
    }

    public R addResult(IItemProvider itemProvider) {
        return this.addResult(new ItemStack(itemProvider));
    }

    public R addResult(ItemStack itemStack) {
        if (this.resultArray != null) {
            return this.addMultiResult((JsonElement)this.serializeItemStack(itemStack));
        }
        return this.addItem("result", itemStack);
    }

    public R addResult(Ingredient ingredient) {
        if (this.resultArray != null) {
            return this.addMultiResult(ingredient.func_200304_c());
        }
        return this.addWriter(jsonObject -> jsonObject.add("result", ingredient.func_200304_c()));
    }

    public R addResult(IngredientWithSize ingredientWithSize) {
        if (this.resultArray != null) {
            return this.addMultiResult(ingredientWithSize.serialize());
        }
        return this.addWriter(jsonObject -> jsonObject.add("result", ingredientWithSize.serialize()));
    }

    public R setUseInputArray(int maxInputCount, String key) {
        this.inputArray = new JsonArray();
        this.maxInputCount = maxInputCount;
        return this.addWriter(jsonObject -> jsonObject.add(key, (JsonElement)this.inputArray));
    }

    public R setUseInputArray(int maxInputCount) {
        return this.setUseInputArray(maxInputCount, "inputs");
    }

    public R addMultiInput(JsonElement obj) {
        Preconditions.checkArgument((this.maxInputCount > 1 ? 1 : 0) != 0, (Object)"This recipe does not support multiple inputs");
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxInputCount + " inputs"));
        this.inputArray.add(obj);
        ++this.inputCount;
        return (R)this;
    }

    public R addMultiInput(Ingredient ingredient) {
        return this.addMultiInput(ingredient.func_200304_c());
    }

    public R addMultiInput(IngredientWithSize ingredient) {
        return this.addMultiInput(ingredient.serialize());
    }

    protected String generateSafeInputKey() {
        Preconditions.checkArgument((this.inputCount < this.maxInputCount ? 1 : 0) != 0, (Object)("Recipe can only have " + this.maxInputCount + " inputs"));
        String key = this.maxInputCount == 1 ? "input" : "input" + this.inputCount;
        ++this.inputCount;
        return key;
    }

    public R addInput(IItemProvider ... itemProviders) {
        if (this.inputArray != null) {
            return this.addMultiInput(Ingredient.func_199804_a((IItemProvider[])itemProviders));
        }
        return this.addIngredient(this.generateSafeInputKey(), itemProviders);
    }

    public R addInput(ItemStack ... itemStacks) {
        if (this.inputArray != null) {
            return this.addMultiInput(Ingredient.func_193369_a((ItemStack[])itemStacks));
        }
        return this.addIngredient(this.generateSafeInputKey(), itemStacks);
    }

    public R addInput(ITag<Item> tag) {
        if (this.inputArray != null) {
            return this.addMultiInput(Ingredient.func_199805_a(tag));
        }
        return this.addIngredient(this.generateSafeInputKey(), tag);
    }

    public R addInput(Ingredient input) {
        if (this.inputArray != null) {
            return this.addMultiInput(input);
        }
        return this.addIngredient(this.generateSafeInputKey(), input);
    }

    public R addInput(IngredientWithSize input) {
        if (this.inputArray != null) {
            return this.addMultiInput(input);
        }
        return this.addIngredient(this.generateSafeInputKey(), input);
    }

    public JsonObject serializeItemStack(ItemStack stack) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", stack.func_77973_b().getRegistryName().toString());
        if (stack.func_190916_E() > 1) {
            obj.addProperty("count", (Number)stack.func_190916_E());
        }
        if (stack.func_77942_o()) {
            obj.addProperty("nbt", stack.func_77978_p().toString());
        }
        return obj;
    }

    public R addItem(String key, IItemProvider item) {
        return this.addItem(key, new ItemStack(item));
    }

    public R addItem(String key, ItemStack stack) {
        Preconditions.checkArgument((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"May not add empty ItemStack to recipe");
        return this.addWriter(jsonObject -> jsonObject.add(key, (JsonElement)this.serializeItemStack(stack)));
    }

    public R addIngredient(String key, IItemProvider ... itemProviders) {
        return this.addIngredient(key, Ingredient.func_199804_a((IItemProvider[])itemProviders));
    }

    public R addIngredient(String key, ItemStack ... itemStacks) {
        return this.addIngredient(key, Ingredient.func_193369_a((ItemStack[])itemStacks));
    }

    public R addIngredient(String key, ITag<Item> tag) {
        return this.addIngredient(key, Ingredient.func_199805_a(tag));
    }

    public R addIngredient(String key, Ingredient ingredient) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ingredient.func_200304_c()));
    }

    public R addIngredient(String key, IngredientWithSize ingredient) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ingredient.serialize()));
    }

    public R addFluid(String key, FluidStack fluidStack) {
        return this.addWriter(jsonObject -> jsonObject.add(key, ApiUtils.jsonSerializeFluidStack(fluidStack)));
    }

    public R addFluid(FluidStack fluidStack) {
        return this.addFluid("fluid", fluidStack);
    }

    public R addFluid(Fluid fluid, int amount) {
        return this.addFluid("fluid", new FluidStack(fluid, amount));
    }

    public R addFluidTag(String key, FluidTagInput fluidTag) {
        return this.addWriter(jsonObject -> jsonObject.add(key, fluidTag.serialize()));
    }

    public R addFluidTag(String key, ITag.INamedTag<Fluid> fluidTag, int amount) {
        return this.addFluidTag(key, new FluidTagInput((ITag<Fluid>)fluidTag, amount));
    }

    public R addFluidTag(ITag.INamedTag<Fluid> fluidTag, int amount) {
        return this.addFluidTag("fluid", new FluidTagInput((ITag<Fluid>)fluidTag, amount));
    }

    public void func_218610_a(JsonObject jsonObject) {
        for (Consumer<JsonObject> writer : this.writerFunctions) {
            writer.accept(jsonObject);
        }
    }

    public ResourceLocation func_200442_b() {
        return this.id;
    }

    public IRecipeSerializer<?> func_218609_c() {
        return this.serializer;
    }

    @Nullable
    public JsonObject func_200440_c() {
        return null;
    }

    @Nullable
    public ResourceLocation func_200443_d() {
        return null;
    }
}

