/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.utils.LazyMirroringTagCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class TagUtils {
    @Deprecated
    public static ITagCollection<Item> ITEM_TAG_COLLECTION;
    @Deprecated
    public static ITagCollection<Block> BLOCK_TAG_COLLECTION;
    public static Supplier<ITagCollection<Item>> GET_ITEM_TAG_COLLECTION;
    public static Supplier<ITagCollection<Block>> GET_BLOCK_TAG_COLLECTION;

    public static void setTagCollectionGetters(Supplier<ITagCollection<Item>> items, Supplier<ITagCollection<Block>> blocks) {
        GET_ITEM_TAG_COLLECTION = items;
        GET_BLOCK_TAG_COLLECTION = blocks;
        ITEM_TAG_COLLECTION = new LazyMirroringTagCollection<Item>(items);
        BLOCK_TAG_COLLECTION = new LazyMirroringTagCollection<Block>(blocks);
    }

    public static ITag<Item> getItemTag(ResourceLocation key) {
        return GET_ITEM_TAG_COLLECTION.get().func_199910_a(key);
    }

    public static ITag<Block> getBlockTag(ResourceLocation key) {
        return GET_BLOCK_TAG_COLLECTION.get().func_199910_a(key);
    }

    public static Collection<ResourceLocation> getTagsForItem(Item item) {
        return GET_ITEM_TAG_COLLECTION.get().func_199913_a((Object)item);
    }

    public static Collection<ResourceLocation> getTagsForBlock(Block block) {
        return GET_BLOCK_TAG_COLLECTION.get().func_199913_a((Object)block);
    }

    public static boolean isInBlockOrItemTag(ItemStack stack, ResourceLocation oreName) {
        if (!TagUtils.isNonemptyBlockOrItemTag(oreName)) {
            return false;
        }
        ITag<Item> itemTag = TagUtils.getItemTag(oreName);
        if (itemTag != null && itemTag.func_230236_b_().contains(stack.func_77973_b())) {
            return true;
        }
        ITag<Block> blockTag = TagUtils.getBlockTag(oreName);
        return blockTag != null && blockTag.func_230236_b_().stream().map(IItemProvider::func_199767_j).anyMatch(i -> stack.func_77973_b() == i);
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        ITag<Item> t = TagUtils.getItemTag(name);
        return t != null && !t.func_230236_b_().isEmpty();
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        ITag<Block> t = TagUtils.getBlockTag(name);
        return t != null && !t.func_230236_b_().isEmpty();
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return TagUtils.isNonemptyBlockTag(name) || TagUtils.isNonemptyItemTag(name);
    }

    public static NonNullList<ItemStack> getItemsInTag(ResourceLocation name) {
        NonNullList ret = NonNullList.func_191196_a();
        TagUtils.addItemsInTag((NonNullList<ItemStack>)ret, TagUtils.getItemTag(name));
        TagUtils.addItemsInTag((NonNullList<ItemStack>)ret, TagUtils.getBlockTag(name));
        return ret;
    }

    private static <T extends IItemProvider> void addItemsInTag(NonNullList<ItemStack> out, ITag<T> in) {
        if (in != null) {
            in.func_230236_b_().stream().map(ItemStack::new).forEach(arg_0 -> out.add(arg_0));
        }
    }

    public static boolean isInPrefixedTag(ItemStack stack, String componentType) {
        return TagUtils.getMatchingPrefix(stack, componentType) != null;
    }

    public static String getMatchingPrefix(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static Collection<ResourceLocation> getMatchingTagNames(ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(TagUtils.getTagsForItem(stack.func_77973_b()));
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b != Blocks.field_150350_a) {
            ret.addAll(TagUtils.getTagsForBlock(b));
        }
        return ret;
    }

    public static String[] getMatchingPrefixAndRemaining(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                String material = name.func_110623_a().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return TagUtils.getItemTag(Tags.Items.INGOTS.func_230234_a_()).func_230235_a_((Object)stack.func_77973_b());
    }

    public static boolean isPlate(ItemStack stack) {
        return TagUtils.isInPrefixedTag(stack, "plates/");
    }

    public static ITag.INamedTag<Item> createItemWrapper(ResourceLocation name) {
        return ItemTags.func_199901_a((String)name.toString());
    }

    public static ITag.INamedTag<Block> createBlockWrapper(ResourceLocation name) {
        return BlockTags.func_199894_a((String)name.toString());
    }

    public static ITag.INamedTag<Fluid> createFluidWrapper(ResourceLocation name) {
        return FluidTags.func_206956_a((String)name.toString());
    }

    static {
        TagUtils.setTagCollectionGetters(() -> TagCollectionManager.func_242178_a().func_241836_b(), () -> TagCollectionManager.func_242178_a().func_241835_a());
    }
}

