/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class WirecoilUtils {
    public static ActionResultType doCoilUse(IWireCoil coil, PlayerEntity player, World world, BlockPos pos, Hand hand, Direction side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            ItemStack stack = player.func_184586_b(hand);
            TargetingInfo targetHere = new TargetingInfo(side, hitX - (float)pos.func_177958_n(), hitY - (float)pos.func_177956_o(), hitZ - (float)pos.func_177952_p());
            WireType wire = coil.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, targetHere);
            BlockPos offsetHere = pos.func_177973_b((Vector3i)masterPos);
            tileEntity = world.func_175625_s(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return ActionResultType.PASS;
            }
            IImmersiveConnectable iicHere = (IImmersiveConnectable)tileEntity;
            ConnectionPoint cpHere = iicHere.getTargetedPoint(targetHere, (Vector3i)offsetHere);
            if (cpHere == null || !((IImmersiveConnectable)tileEntity).canConnectCable(wire, cpHere, (Vector3i)offsetHere) || !coil.canConnectCable(stack, tileEntity)) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.wrongCable"), true);
                }
                return ActionResultType.FAIL;
            }
            if (!world.field_72995_K) {
                if (!WirecoilUtils.hasWireLink(stack)) {
                    WireLink link = WireLink.create(cpHere, world, offsetHere, targetHere);
                    link.writeToItem(stack);
                } else {
                    WireLink otherLink = WireLink.readFromItem(stack);
                    TileEntity tileEntityLinkingPos = world.func_175625_s(otherLink.cp.getPosition());
                    int distanceSq = (int)Math.ceil(otherLink.cp.getPosition().func_177951_i((Vector3i)masterPos));
                    int maxLengthSq = coil.getMaxLength(stack);
                    maxLengthSq *= maxLengthSq;
                    if (!otherLink.dimension.equals((Object)world.func_234923_W_())) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.wrongDimension"), true);
                    } else if (otherLink.cp.getPosition().equals((Object)masterPos)) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.sameConnection"), true);
                    } else if (distanceSq > maxLengthSq) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.tooFar"), true);
                    } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.invalidPoint"), true);
                    } else {
                        IImmersiveConnectable iicLink = (IImmersiveConnectable)tileEntityLinkingPos;
                        if (!(((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(wire, otherLink.cp, (Vector3i)otherLink.offset) && ((IImmersiveConnectable)tileEntityLinkingPos).getConnectionMaster(wire, otherLink.target).equals((Object)otherLink.cp.getPosition()) && coil.canConnectCable(stack, tileEntityLinkingPos))) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.invalidPoint"), true);
                        } else {
                            Collection<Connection> outputs;
                            LocalWireNetwork localB;
                            GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                            boolean connectionExists = false;
                            LocalWireNetwork localA = net.getLocalNet(cpHere);
                            if (localA == (localB = net.getLocalNet(otherLink.cp)) && (outputs = localA.getConnections(cpHere)) != null) {
                                for (Connection con : outputs) {
                                    if (con.isInternal() || !con.getOtherEnd(cpHere).equals(otherLink.cp)) continue;
                                    connectionExists = true;
                                }
                            }
                            if (connectionExists) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.connectionExists"), true);
                            } else {
                                HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                                ignore.addAll(iicHere.getIgnored(iicLink));
                                ignore.addAll(iicLink.getIgnored(iicHere));
                                Connection tempConn = new Connection(wire, cpHere, otherLink.cp);
                                Set<BlockPos> failedReasons = WireUtils.findObstructingBlocks(world, tempConn, ignore);
                                if (failedReasons.isEmpty()) {
                                    Connection conn = new Connection(wire, cpHere, otherLink.cp);
                                    net.addConnection(conn);
                                    iicHere.connectCable(wire, cpHere, iicLink, otherLink.cp);
                                    iicLink.connectCable(wire, otherLink.cp, iicHere, cpHere);
                                    Utils.unlockIEAdvancement(player, "main/connect_wire");
                                    if (!player.field_71075_bZ.field_75098_d) {
                                        coil.consumeWire(stack, (int)Math.sqrt(distanceSq));
                                    }
                                    ((TileEntity)iicHere).func_70296_d();
                                    world.func_175641_c(masterPos, ((TileEntity)iicHere).func_195044_w().func_177230_c(), -1, 0);
                                    BlockState state = world.func_180495_p(masterPos);
                                    world.func_184138_a(masterPos, state, state, 3);
                                    ((TileEntity)iicLink).func_70296_d();
                                    world.func_175641_c(otherLink.cp.getPosition(), tileEntityLinkingPos.func_195044_w().func_177230_c(), -1, 0);
                                    state = world.func_180495_p(otherLink.cp.getPosition());
                                    world.func_184138_a(otherLink.cp.getPosition(), state, state, 3);
                                } else {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.cantSee"), true);
                                    ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f((BlockPos)failedReasons.iterator().next())), (Object)new MessageObstructedConnection(tempConn, failedReasons));
                                }
                            }
                        }
                    }
                    WirecoilUtils.clearWireLink(stack);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void clearWireLink(ItemStack stack) {
        ItemNBTHelper.remove(stack, "linkingDim");
        ItemNBTHelper.remove(stack, "linkingPos");
        ItemNBTHelper.remove(stack, "linkingOffset");
        ItemNBTHelper.remove(stack, "linkingTarget");
    }

    public static boolean hasWireLink(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, "linkingDim", 8);
    }

    public static class WireLink {
        public final ConnectionPoint cp;
        public final RegistryKey<World> dimension;
        public final BlockPos offset;
        public final TargetingInfo target;

        public WireLink(ConnectionPoint cp, RegistryKey<World> dimension, BlockPos offset, TargetingInfo info) {
            this.cp = cp;
            this.dimension = dimension;
            this.offset = offset.func_185334_h();
            this.target = info;
        }

        public static WireLink create(ConnectionPoint cp, World world, BlockPos offset, TargetingInfo info) {
            return new WireLink(cp, (RegistryKey<World>)world.func_234923_W_(), offset, info);
        }

        public void writeToItem(ItemStack stack) {
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74778_a("linkingDim", this.dimension.func_240901_a_().toString());
            nbt.func_218657_a("linkingPos", (INBT)this.cp.createTag());
            nbt.func_218657_a("linkingOffset", (INBT)NBTUtil.func_186859_a((BlockPos)this.offset));
            CompoundNBT targetNBT = new CompoundNBT();
            this.target.writeToNBT(targetNBT);
            nbt.func_218657_a("linkingTarget", (INBT)targetNBT);
        }

        public static WireLink readFromItem(ItemStack stack) {
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_196082_o() : new CompoundNBT();
            ConnectionPoint cp = new ConnectionPoint(nbt.func_74775_l("linkingPos"));
            ResourceLocation dim = new ResourceLocation(nbt.func_74779_i("linkingDim"));
            BlockPos offset = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("linkingOffset"));
            TargetingInfo info = TargetingInfo.readFromNBT(nbt.func_74775_l("linkingTarget"));
            return new WireLink(cp, (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dim), offset, info);
        }
    }
}

