/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ShaderManualElement
extends SpecialManualElements {
    final ShaderRegistry.ShaderRegistryEntry shader;
    ItemStack shaderItem;
    ItemStack[] exampleItems;
    IngredientWithSize replicationCost;
    int example = 0;
    boolean unlocked;
    IFormattableTextComponent name;
    IFormattableTextComponent text;

    public ShaderManualElement(ManualInstance manual, ShaderRegistry.ShaderRegistryEntry shader) {
        super(manual);
        this.shader = shader;
    }

    @Override
    public int getPixelsTaken() {
        return 47;
    }

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> buttons) {
        ClientPlayerEntity player = ManualUtils.mc().field_71439_g;
        UUID uuid = player.func_110124_au();
        this.unlocked = ShaderRegistry.receivedShaders.get((Object)uuid).contains(this.shader.getName());
        this.shaderItem = new ItemStack((IItemProvider)ShaderRegistry.itemShader);
        this.shaderItem.func_196082_o().func_74778_a("shader_name", this.shader.getName().toString());
        this.replicationCost = this.shader.replicationCost.get();
        if (this.unlocked) {
            ArrayList list = new ArrayList();
            for (ItemStack is : ShaderRegistry.itemExamples) {
                ItemStack s = is.func_77946_l();
                s.getCapability(CapabilityShader.SHADER_CAPABILITY).ifPresent(wrapper -> {
                    wrapper.setShaderItem(this.shaderItem);
                    list.add(s);
                });
            }
            this.exampleItems = list.toArray(new ItemStack[0]);
            this.example = 0;
            if (this.exampleItems.length > 1) {
                buttons.add(new GuiButtonManualNavigation(gui, x + 50, y, 10, 16, 0, btn -> {
                    --this.example;
                    if (this.example < 0) {
                        this.example = this.exampleItems.length - 1;
                    }
                }));
                buttons.add(new GuiButtonManualNavigation(gui, x + 100, y, 10, 16, 1, btn -> {
                    this.example = (this.example + 1) % this.exampleItems.length;
                }));
            }
        } else {
            this.exampleItems = null;
        }
        this.name = ClientUtils.applyFormat(this.shaderItem.func_200301_q(), TextFormatting.BOLD);
        StringTextComponent textAssembly = new StringTextComponent("");
        textAssembly.func_230529_a_((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.level"), TextFormatting.BOLD));
        textAssembly.func_230529_a_((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.rarity." + this.shader.rarity.name().toLowerCase(Locale.US)));
        if (this.unlocked) {
            String details;
            String set = this.shader.info_set == null || this.shader.info_set.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.set.%s", this.shader.info_set);
            String reference = this.shader.info_reference == null || this.shader.info_reference.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.reference.%s", this.shader.info_reference);
            String string = details = this.shader.info_details == null || this.shader.info_details.isEmpty() ? null : ManualUtils.attemptStringTranslation("desc.immersiveengineering.info.shader.details.%s", this.shader.info_details);
            if (set != null) {
                textAssembly.func_240702_b_("\n").func_230529_a_((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.set"), TextFormatting.BOLD)).func_240702_b_(" " + set);
            }
            if (reference != null) {
                textAssembly.func_240702_b_("\n").func_230529_a_((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.reference"), TextFormatting.BOLD)).func_240702_b_("\n" + reference);
            }
            if (details != null) {
                textAssembly.func_240702_b_("\n").func_230529_a_((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.shader.details"), TextFormatting.BOLD)).func_240702_b_("\n" + details);
            }
            String cost = Integer.toString(this.replicationCost.getCount());
            if (!IngredientUtils.hasPlayerIngredient((PlayerEntity)ManualUtils.mc().field_71439_g, this.replicationCost) && !ManualUtils.mc().field_71439_g.field_71075_bZ.field_75098_d) {
                cost = TextFormatting.RED + cost;
            }
            buttons.add(new GuiButtonManual(gui, x + 50, y + 120, 70, 12, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"ie.manual.entry.shaderList.order", (Object[])new Object[0]) + " " + cost + "x   ").func_240699_a_(TextFormatting.BOLD), btn -> {
                if (IngredientUtils.hasPlayerIngredient((PlayerEntity)ManualUtils.mc().field_71439_g, this.replicationCost) || ManualUtils.mc().field_71439_g.field_71075_bZ.field_75098_d) {
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.SPAWN, this.shader.getName()));
                }
                gui.fullInit();
            }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
        } else {
            textAssembly.func_240702_b_("\n\n").func_230529_a_((ITextComponent)new TranslationTextComponent("ie.manual.entry.shaderList.noInfo"));
            if (player.field_71075_bZ.field_75098_d) {
                buttons.add(new GuiButtonManual(gui, x + 10, y + 120, 100, 16, (ITextComponent)new TranslationTextComponent("ie.manual.entry.shaderList.unlock"), btn -> {
                    UUID playerId = ManualUtils.mc().field_71439_g.func_110124_au();
                    ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.UNLOCK, this.shader.getName()));
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.shader.getName());
                    gui.fullInit();
                }).setTextColour(gui.getManual().getTextColour(), gui.getManual().getHighlightColour()));
            }
        }
        this.text = textAssembly;
    }

    @Override
    public void render(MatrixStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        RenderHelper.func_227780_a_();
        float scale = 2.0f;
        transform.func_227860_a_();
        transform.func_227862_a_(scale, scale, scale);
        boolean examples = this.exampleItems != null && this.exampleItems.length > 0;
        ManualUtils.renderItemStack(transform, this.shaderItem, (int)((float)(x + 10 + (examples ? 0 : 34)) / scale), (int)((float)(y - 8) / scale), false);
        if (examples && this.example >= 0 && this.example < this.exampleItems.length) {
            ManualUtils.renderItemStack(transform, this.exampleItems[this.example], (int)((float)(x + 63) / scale), (int)((float)(y - 8) / scale), false);
        }
        transform.func_227862_a_(1.0f / scale, 1.0f / scale, 1.0f / scale);
        if (this.unlocked) {
            ManualUtils.renderItemStack(transform, this.replicationCost.getRandomizedExampleStack(ManualUtils.mc().field_71439_g.field_70173_aa), x + 102, y + 118, false);
        }
        RenderHelper.func_74518_a();
        int w = this.manual.fontRenderer().func_78256_a(this.name.getString());
        this.manual.fontRenderer().func_238418_a_((ITextProperties)this.name, x + 60 - w / 2, y + 24, 120, this.manual.getTextColour());
        if (this.text != null && !this.text.getString().isEmpty()) {
            this.manual.fontRenderer().func_238418_a_((ITextProperties)this.text, x, y + 38, 120, this.manual.getTextColour());
        }
        transform.func_227865_b_();
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }

    @Override
    public void recalculateCraftingRecipes() {
    }
}

