/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class PostTransformerTileEntity
extends ImmersiveConnectableTileEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds {
    private static final int RIGHT_INDEX = 0;
    private static final int LEFT_INDEX = 1;
    private WireType leftType;
    private WireType rightType;
    protected Set<String> acceptableLowerWires = ImmutableSet.of((Object)"LV");

    public PostTransformerTileEntity() {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)((TileEntityType)IETileTypes.POST_TRANSFORMER.get()));
    }

    public PostTransformerTileEntity(TileEntityType<? extends PostTransformerTileEntity> type) {
        super((TileEntityType<? extends ImmersiveConnectableTileEntity>)type);
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.leftType != null) {
            nbt.func_74778_a("leftType", this.leftType.getUniqueName());
        }
        if (this.rightType != null) {
            nbt.func_74778_a("rightType", this.rightType.getUniqueName());
        }
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.leftType = nbt.func_74764_b("leftType") ? WireUtils.getWireTypeFromNBT(nbt, "leftType") : null;
        this.rightType = nbt.func_74764_b("rightType") ? WireUtils.getWireTypeFromNBT(nbt, "rightType") : null;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        switch (target.getIndex()) {
            case 1: {
                return this.canAttach(cableType, this.leftType, this.rightType);
            }
            case 0: {
                return this.canAttach(cableType, this.rightType, this.leftType);
            }
        }
        return false;
    }

    private boolean canAttach(WireType toAttach, @Nullable WireType atConn, @Nullable WireType other) {
        boolean isOtherHigher;
        if (atConn != null) {
            return false;
        }
        String higherCat = this.getHigherWiretype();
        String attachCat = toAttach.getCategory();
        if (other == null) {
            return higherCat.equals(attachCat) || this.acceptableLowerWires.contains(attachCat);
        }
        boolean isHigher = higherCat.equals(toAttach.getCategory());
        if (isHigher ^ (isOtherHigher = higherCat.equals(other.getCategory()))) {
            if (isHigher) {
                return true;
            }
            return this.acceptableLowerWires.contains(attachCat);
        }
        return false;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        switch (target.getIndex()) {
            case 1: {
                this.leftType = cableType;
                break;
            }
            case 0: {
                this.rightType = cableType;
            }
        }
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        WireType type;
        WireType wireType = type = connection != null ? connection.type : null;
        if (type == null) {
            this.rightType = null;
            this.leftType = null;
        } else {
            switch (connection.getEndFor(this.field_174879_c).getIndex()) {
                case 1: {
                    this.leftType = null;
                    break;
                }
                case 0: {
                    this.rightType = null;
                }
            }
        }
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        return this.getConnectionOffset(con, con.getEndFor(this.field_174879_c).getIndex() == 0);
    }

    private Vector3d getConnectionOffset(Connection con, boolean right) {
        if (right) {
            return new Vector3d(0.5 + (this.getFacing() == Direction.EAST ? 0.4375 : (this.getFacing() == Direction.WEST ? -0.4375 : 0.0)), 1.4375, 0.5 + (this.getFacing() == Direction.SOUTH ? 0.4375 : (this.getFacing() == Direction.NORTH ? -0.4375 : 0.0)));
        }
        return new Vector3d(0.5 + (this.getFacing() == Direction.EAST ? -0.0625 : (this.getFacing() == Direction.WEST ? 0.0625 : 0.0)), 0.25, 0.5 + (this.getFacing() == Direction.SOUTH ? -0.0625 : (this.getFacing() == Direction.NORTH ? 0.0625 : 0.0)));
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo target, Vector3i offset) {
        if ((double)target.hitY >= 0.5) {
            return new ConnectionPoint(this.field_174879_c, 0);
        }
        return new ConnectionPoint(this.field_174879_c, 1);
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197873_a((double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.25 : (this.getFacing() == Direction.WEST ? -0.375 : 0.6875)), (double)0.0, (double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.25 : (this.getFacing() == Direction.NORTH ? -0.375 : 0.6875)), (double)(this.getFacing().func_176740_k() == Direction.Axis.Z ? 0.75 : (this.getFacing() == Direction.EAST ? 1.375 : 0.3125)), (double)1.0, (double)(this.getFacing().func_176740_k() == Direction.Axis.X ? 0.75 : (this.getFacing() == Direction.SOUTH ? 1.375 : 0.3125)));
    }

    public String getHigherWiretype() {
        return "MV";
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.field_174879_c, 0), (Object)new ConnectionPoint(this.field_174879_c, 1));
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of((Object)new Connection(this.field_174879_c, 1, 0));
    }
}

