/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public abstract class IETemplateMultiblock
extends TemplateMultiblock {
    private final Supplier<BlockState> baseState;
    private final BlockPos size;

    public IETemplateMultiblock(ResourceLocation loc, BlockPos masterFromOrigin, BlockPos triggerFromOrigin, BlockPos size, Supplier<BlockState> baseState) {
        super(loc, masterFromOrigin, triggerFromOrigin, (Map<Block, ITag<Block>>)ImmutableMap.of());
        this.size = size;
        this.baseState = baseState;
    }

    @Override
    protected void replaceStructureBlock(Template.BlockInfo info, World world, BlockPos actualPos, boolean mirrored, Direction clickDirection, Vector3i offsetFromMaster) {
        BlockState state = this.baseState.get();
        if (!offsetFromMaster.equals((Object)Vector3i.field_177959_e)) {
            state = (BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        }
        world.func_175656_a(actualPos, state);
        TileEntity curr = world.func_175625_s(actualPos);
        if (curr instanceof MultiblockPartTileEntity) {
            MultiblockPartTileEntity tile = (MultiblockPartTileEntity)curr;
            tile.formed = true;
            tile.offsetToMaster = new BlockPos(offsetFromMaster);
            tile.posInMultiblock = info.field_186242_a;
            if (state.func_235901_b_((Property)IEProperties.MIRRORED)) {
                tile.setMirrored(mirrored);
            }
            tile.setFacing(this.transformDirection(clickDirection.func_176734_d()));
            tile.func_70296_d();
            world.func_175641_c(actualPos, world.func_180495_p(actualPos).func_177230_c(), 255, 0);
        } else {
            IELogger.logger.error("Expected MB TE at {} during placement", (Object)actualPos);
        }
    }

    @Override
    public void disassemble(World world, BlockPos origin, boolean mirrored, Direction clickDirectionAtCreation) {
        super.disassemble(world, origin, mirrored, clickDirectionAtCreation);
    }

    public Direction transformDirection(Direction original) {
        return original;
    }

    public Direction untransformDirection(Direction transformed) {
        return transformed;
    }

    public BlockPos multiblockToModelPos(BlockPos posInMultiblock) {
        return posInMultiblock.func_177973_b((Vector3i)this.masterFromOrigin);
    }

    @Override
    public Vector3i getSize(@Nullable World world) {
        return this.size;
    }

    @Override
    @Nonnull
    protected Template getTemplate(@Nullable World world) {
        Template result = super.getTemplate(world);
        Preconditions.checkState((boolean)result.func_186259_a().equals((Object)this.size), (Object)("Wrong template size for multiblock " + this.getTemplateLocation() + ", template size: " + result.func_186259_a()));
        return result;
    }

    @Override
    protected void prepareBlockForDisassembly(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultiblockPartTileEntity) {
            ((MultiblockPartTileEntity)te).formed = false;
        } else {
            IELogger.logger.error("Expected multiblock TE at {}", (Object)pos);
        }
    }
}

