/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CokeOvenTileEntity
extends MultiblockPartTileEntity<CokeOvenTileEntity>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IProcessTile,
IEBlockInterfaces.IBlockBounds {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int EMPTY_CONTAINER_SLOT = 2;
    public static final int FULL_CONTAINER_SLOT = 3;
    public FluidTank tank = new FluidTank(12000);
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int process = 0;
    public int processMax = 0;
    public CokeOvenData guiData = new CokeOvenData();
    LazyOptional<IItemHandler> invHandler = this.registerConstantCap(new IEInventoryHandler(4, (IIEInventory)this, 0, new boolean[]{true, false, true, false}, new boolean[]{false, true, false, true}));

    public CokeOvenTileEntity() {
        super(IEMultiblocks.COKE_OVEN, (TileEntityType)IETileTypes.COKE_OVEN.get(), false);
    }

    @Override
    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    @Override
    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)((Object)this.master());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (!this.field_145850_b.field_72995_K && this.formed && !this.isDummy()) {
            boolean activeAfterTick;
            ItemStack filledContainer;
            CokeOvenRecipe recipe;
            boolean activeBeforeTick = this.getIsActive();
            if (this.process > 0) {
                if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
                    this.process = 0;
                    this.processMax = 0;
                } else {
                    recipe = this.getRecipe();
                    if (recipe == null || recipe.time != this.processMax) {
                        this.process = 0;
                        this.processMax = 0;
                        this.setActive(false);
                    } else {
                        --this.process;
                    }
                }
                this.markContainingBlockForUpdate(null);
            } else {
                if (activeBeforeTick) {
                    recipe = this.getRecipe();
                    if (recipe != null) {
                        Utils.modifyInvStackSize(this.inventory, 0, -recipe.input.getCount());
                        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
                            ((ItemStack)this.inventory.get(1)).func_190917_f(recipe.output.func_77946_l().func_190916_E());
                        } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                            this.inventory.set(1, (Object)recipe.output.func_77946_l());
                        }
                        this.tank.fill(new FluidStack((Fluid)IEContent.fluidCreosote, recipe.creosoteOutput), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.processMax = 0;
                    this.setActive(false);
                }
                if ((recipe = this.getRecipe()) != null) {
                    this.processMax = this.process = recipe.time;
                    this.setActive(true);
                }
            }
            ItemStack inFullSlot = (ItemStack)this.inventory.get(3);
            if (this.tank.getFluidAmount() > 0 && (inFullSlot.func_190926_b() || inFullSlot.func_190916_E() + 1 <= inFullSlot.func_77976_d()) && !(filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tank, ((ItemStack)this.inventory.get(2)).func_77946_l(), inFullSlot, null)).func_190926_b()) {
                if (((ItemStack)this.inventory.get(2)).func_190916_E() == 1 && !Utils.isFluidContainerFull(filledContainer)) {
                    this.inventory.set(2, (Object)filledContainer.func_77946_l());
                } else {
                    if (!inFullSlot.func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)inFullSlot, (ItemStack)filledContainer)) {
                        inFullSlot.func_190917_f(filledContainer.func_190916_E());
                    } else if (inFullSlot.func_190926_b()) {
                        this.inventory.set(3, (Object)filledContainer.func_77946_l());
                    }
                    Utils.modifyInvStackSize(this.inventory, 2, -filledContainer.func_190916_E());
                }
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
            if (activeBeforeTick != (activeAfterTick = this.getIsActive())) {
                this.func_70296_d();
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        for (int z = 0; z < 3; ++z) {
                            BlockPos actualPos = this.getBlockPosForPos(new BlockPos(x, y, z));
                            TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, actualPos);
                            if (!(te instanceof CokeOvenTileEntity)) continue;
                            ((CokeOvenTileEntity)te).setActive(activeAfterTick);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public CokeOvenRecipe getRecipe() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return null;
        }
        CokeOvenRecipe recipe = CokeOvenRecipe.findRecipe((ItemStack)this.inventory.get(0));
        if (recipe == null) {
            return null;
        }
        if ((((ItemStack)this.inventory.get(1)).func_190926_b() || ItemStack.func_179545_c((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)recipe.output) && ((ItemStack)this.inventory.get(1)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(1)) && this.tank.getFluidAmount() + recipe.creosoteOutput <= this.tank.getCapacity()) {
            return recipe;
        }
        return null;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        CokeOvenTileEntity master = (CokeOvenTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        CokeOvenTileEntity master = (CokeOvenTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
            this.process = nbt.func_74762_e("process");
            this.processMax = nbt.func_74762_e("processMax");
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        nbt.func_218657_a("tank", (INBT)tankTag);
        if (!descPacket) {
            nbt.func_74768_a("process", this.process);
            nbt.func_74768_a("processMax", this.processMax);
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        CokeOvenTileEntity master = (CokeOvenTileEntity)this.master();
        if (master != null) {
            return new FluidTank[]{master.tank};
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        CokeOvenTileEntity master = (CokeOvenTileEntity)this.master();
        if (master != null && master.formed && this.formed) {
            return master.inventory;
        }
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0) {
            return CokeOvenRecipe.findRecipe(stack) != null;
        }
        if (slot == 2) {
            return Utils.isFluidRelatedItemStack(stack);
        }
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        CokeOvenTileEntity master;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (master = (CokeOvenTileEntity)this.master()) != null) {
            return master.invHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public class CokeOvenData
    implements IIntArray {
        public static final int MAX_BURN_TIME = 0;
        public static final int BURN_TIME = 1;

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return CokeOvenTileEntity.this.processMax;
                }
                case 1: {
                    return CokeOvenTileEntity.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    CokeOvenTileEntity.this.processMax = value;
                    break;
                }
                case 1: {
                    CokeOvenTileEntity.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    }
}

