/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.MetalBarrelTileEntity;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WoodenBarrelTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IComparatorOverride {
    public static final int IGNITION_TEMPERATURE = 573;
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(ImmutableMap.of((Object)Direction.DOWN, (Object)((Object)IEEnums.IOSideConfig.OUTPUT), (Object)Direction.UP, (Object)((Object)IEEnums.IOSideConfig.INPUT)));
    public FluidTank tank = new FluidTank(12000, this::isFluidValid);
    private Map<Direction, CapabilityReference<IFluidHandler>> neighbors = ImmutableMap.of((Object)Direction.DOWN, CapabilityReference.forNeighbor((TileEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN), (Object)Direction.UP, CapabilityReference.forNeighbor((TileEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP));
    private Map<Direction, LazyOptional<IFluidHandler>> sidedFluidHandler = new HashMap<Direction, LazyOptional<IFluidHandler>>();

    public WoodenBarrelTileEntity(TileEntityType<? extends WoodenBarrelTileEntity> type) {
        super(type);
        this.sidedFluidHandler.put(Direction.DOWN, this.registerCap(() -> new SidedFluidHandler(this, Direction.DOWN)));
        this.sidedFluidHandler.put(Direction.UP, this.registerCap(() -> new SidedFluidHandler(this, Direction.UP)));
        this.sidedFluidHandler.put(null, this.registerCap(() -> new SidedFluidHandler(this, null)));
    }

    public WoodenBarrelTileEntity() {
        this((TileEntityType<? extends WoodenBarrelTileEntity>)((TileEntityType)IETileTypes.WOODEN_BARREL.get()));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean update = false;
        for (Direction side : this.neighbors.keySet()) {
            int accepted;
            FluidStack drained;
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig.get(side) != IEEnums.IOSideConfig.OUTPUT) continue;
            int out = Math.min(40, this.tank.getFluidAmount());
            CapabilityReference<IFluidHandler> capRef = this.neighbors.get(side);
            IFluidHandler handler = capRef.getNullable();
            if (handler == null || (drained = this.tank.drain(accepted = handler.fill(Utils.copyFluidStackWithAmount(this.tank.getFluid(), out, false), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
            handler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            update = true;
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult rtr, boolean hammer) {
        if (rtr.func_216346_c() == RayTraceResult.Type.MISS) {
            return null;
        }
        if (Utils.isFluidRelatedItemStack(player.func_184586_b(Hand.MAIN_HAND))) {
            return new ITextComponent[]{TextUtils.formatFluidStack(this.tank.getFluid())};
        }
        if (!(rtr instanceof BlockRayTraceResult)) {
            return null;
        }
        BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && brtr.func_216354_b().func_176740_k() == Direction.Axis.Y) {
            IEEnums.IOSideConfig side = this.sideConfig.getOrDefault(brtr.func_216354_b(), IEEnums.IOSideConfig.NONE);
            IEEnums.IOSideConfig opposite = this.sideConfig.getOrDefault(brtr.func_216354_b().func_176734_d(), IEEnums.IOSideConfig.NONE);
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", side, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int[] sideCfgArray = nbt.func_74759_k("sideConfig");
        if (sideCfgArray.length < 2) {
            sideCfgArray = new int[]{-1, 0};
        }
        this.sideConfig.clear();
        for (int i = 0; i < sideCfgArray.length; ++i) {
            this.sideConfig.put(Direction.func_82600_a((int)i), IEEnums.IOSideConfig.VALUES[sideCfgArray[i]]);
        }
        this.readTank(nbt);
    }

    public void readTank(CompoundNBT nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        int[] sideCfgArray = new int[]{this.sideConfig.get(Direction.DOWN).ordinal(), this.sideConfig.get(Direction.UP).ordinal()};
        nbt.func_74783_a("sideConfig", sideCfgArray);
        this.writeTank(nbt, false);
    }

    public void writeTank(CompoundNBT nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundNBT tankTag = this.tank.writeToNBT(new CompoundNBT());
        if (!toItem || write) {
            nbt.func_218657_a("tank", (INBT)tankTag);
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || facing.func_176740_k() == Direction.Axis.Y)) {
            return this.sidedFluidHandler.getOrDefault(facing, (LazyOptional<IFluidHandler>)LazyOptional.empty()).cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean isFluidValid(FluidStack fluid) {
        return !fluid.isEmpty() && fluid.getFluid() != null && fluid.getFluid().getAttributes().getTemperature(fluid) < 573 && !fluid.getFluid().getAttributes().isGaseous(fluid);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.getOrDefault(side, IEEnums.IOSideConfig.NONE);
    }

    @Override
    public boolean toggleSide(Direction side, PlayerEntity p) {
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        this.sideConfig.compute(side, (s, config) -> IEEnums.IOSideConfig.next(config));
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 0);
        return true;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        Optional<Boolean> ret;
        Optional fOptional = FluidUtil.getFluidContained((ItemStack)heldItem);
        boolean metal = this instanceof MetalBarrelTileEntity;
        if (!metal && (ret = fOptional.map(f -> {
            if (f.getFluid().getAttributes().isGaseous(f)) {
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.noGasAllowed")});
                return true;
            }
            if (f.getFluid().getAttributes().getTemperature(f) >= 573) {
                ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TranslationTextComponent("chat.immersiveengineering.info.tooHot")});
                return true;
            }
            return false;
        })).orElse(false).booleanValue()) {
            return true;
        }
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.tank)) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c(), 1);
        CompoundNBT tag = new CompoundNBT();
        this.writeTank(tag, true);
        if (!tag.isEmpty()) {
            stack.func_77982_d(tag);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_196082_o());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return (int)(15.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        WoodenBarrelTileEntity barrel;
        @Nullable
        Direction facing;

        SidedFluidHandler(WoodenBarrelTileEntity barrel, @Nullable Direction facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource == null || this.facing != null && this.barrel.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT || !this.barrel.isFluidValid(resource)) {
                return 0;
            }
            int i = this.barrel.tank.fill(resource, doFill);
            if (i > 0) {
                this.barrel.func_70296_d();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (resource == null) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (this.facing != null && this.barrel.sideConfig.get(this.facing) != IEEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            FluidStack f = this.barrel.tank.drain(maxDrain, doDrain);
            if (!f.isEmpty()) {
                this.barrel.func_70296_d();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return f;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.barrel.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.barrel.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.barrel.tank.isFluidValid(tank, stack);
        }
    }
}

