/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.CraftingHelper;

public class IngredientWithSizeSerializer {
    public static final IngredientWithSizeSerializer INSTANCE = new IngredientWithSizeSerializer();
    private static final String COUNT_KEY = "count";
    private static final String BASE_KEY = "base_ingredient";

    @Nonnull
    public IngredientWithSize parse(@Nonnull PacketBuffer buffer) {
        int count = buffer.readInt();
        Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
        return new IngredientWithSize(base, count);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull IngredientWithSize ingredient) {
        buffer.writeInt(ingredient.getCount());
        CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.getBaseIngredient());
    }

    @Nonnull
    public IngredientWithSize parse(@Nonnull JsonElement json) {
        if (json.isJsonObject() && json.getAsJsonObject().has(BASE_KEY)) {
            int count = JSONUtils.func_151208_a((JsonObject)json.getAsJsonObject(), (String)COUNT_KEY, (int)1);
            JsonElement baseJson = json.getAsJsonObject().get(BASE_KEY);
            Ingredient base = Ingredient.func_199802_a((JsonElement)baseJson);
            return new IngredientWithSize(base, count);
        }
        Ingredient base = Ingredient.func_199802_a((JsonElement)json);
        return new IngredientWithSize(base, 1);
    }

    public JsonElement write(@Nonnull IngredientWithSize ingredient) {
        if (ingredient.getCount() == 1) {
            return ingredient.getBaseIngredient().func_200304_c();
        }
        JsonObject json = new JsonObject();
        json.addProperty(COUNT_KEY, (Number)ingredient.getCount());
        json.add(BASE_KEY, ingredient.getBaseIngredient().func_200304_c());
        return json;
    }
}

