/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class BlueprintCraftingRecipeSerializer
extends IERecipeSerializer<BlueprintCraftingRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.WoodenDevices.workbench);
    }

    @Override
    public BlueprintCraftingRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        String category = JSONUtils.func_151200_h((JsonObject)json, (String)"category");
        ItemStack output = this.readOutput(json.get("result"));
        JsonArray inputs = json.getAsJsonArray("inputs");
        IngredientWithSize[] ingredients = new IngredientWithSize[inputs.size()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.deserialize(inputs.get(i));
        }
        return IEServerConfig.MACHINES.autoWorkbenchConfig.apply(new BlueprintCraftingRecipe(recipeId, category, output, ingredients));
    }

    @Nullable
    public BlueprintCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String category = buffer.func_218666_n();
        ItemStack output = buffer.func_150791_c();
        int inputCount = buffer.readInt();
        IngredientWithSize[] ingredients = new IngredientWithSize[inputCount];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.read(buffer);
        }
        return new BlueprintCraftingRecipe(recipeId, category, output, ingredients);
    }

    public void write(PacketBuffer buffer, BlueprintCraftingRecipe recipe) {
        buffer.func_180714_a(recipe.blueprintCategory);
        buffer.func_150788_a(recipe.output);
        buffer.writeInt(recipe.inputs.length);
        for (IngredientWithSize ingredient : recipe.inputs) {
            ingredient.write(buffer);
        }
    }
}

