/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.fluids.IEItemFluidHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DrillItem
extends DieselToolItem {
    public static Material[] validMaterials = new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151592_s, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_76233_E, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y};
    private static final String[][] ROTATING = new String[][]{{"drill_head", "upgrade_damage0"}, {"upgrade_damage1", "upgrade_damage2"}, {"upgrade_damage3", "upgrade_damage4"}};
    private static final String[][] FIXED = new String[][]{{"upgrade_damage1", "upgrade_damage2", "upgrade_damage3", "upgrade_damage4"}};
    @OnlyIn(value=Dist.CLIENT)
    private static TransformationMatrix matAugers;

    public DrillItem() {
        super("drill", DrillItem.withIEOBJRender().func_200917_a(1).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE), "DRILL");
    }

    @Override
    public int getSlotCount() {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        return new Slot[]{new IESlot.WithPredicate(inv, 0, 98, 22, itemStack -> itemStack.func_77973_b() instanceof IDrillHead), new IESlot.Upgrades(container, inv, 1, 78, 52, "DRILL", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 2, 98, 52, "DRILL", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 3, 118, 52, "DRILL", stack, true, getWorld, getPlayer)};
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        invCap.ifPresent(inv -> {
            if (!(inv.getStackInSlot(0).func_190926_b() || inv.getStackInSlot(1).func_190926_b() || inv.getStackInSlot(2).func_190926_b() || inv.getStackInSlot(3).func_190926_b())) {
                Utils.unlockIEAdvancement(player, "main/upgrade_drill");
            }
        });
    }

    @Override
    public ItemStack getHead(ItemStack drill) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == null) {
            return ItemStack.field_190927_a;
        }
        LazyOptional cap = drill.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        ItemStack head = ((IItemHandler)cap.orElseThrow(RuntimeException::new)).getStackInSlot(0);
        return !head.func_190926_b() && head.func_77973_b() instanceof IDrillHead ? head : ItemStack.field_190927_a;
    }

    @Override
    public void setHead(ItemStack drill, ItemStack head) {
        IItemHandler inv = (IItemHandler)drill.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(RuntimeException::new);
        ((IItemHandlerModifiable)inv).setStackInSlot(0, head);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).func_190926_b()) {
            list.add((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drill.noHead"), TextFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            TextFormatting status = (double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN));
            list.add((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.drill.headDamage"), TextFormatting.GRAY).func_240702_b_(" ").func_230529_a_((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.percent", new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack head) {
        return ((IDrillHead)head.func_77973_b()).getAttackDamage(head) + (float)this.getUpgrades(stack).func_74762_e("damage");
    }

    @Override
    public boolean canToolBeUsed(ItemStack drill, @Nullable LivingEntity player) {
        if (player != null && player.func_208600_a((ITag)FluidTags.field_206959_a) && !this.getUpgrades(drill).func_74767_n("waterproof")) {
            return false;
        }
        return this.getHeadDamage(drill) < this.getMaxHeadDamage(drill) && !this.getFluid(drill).isEmpty();
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.func_190926_b() ? ((IDrillHead)head.func_77973_b()).getMaximumHeadDamage(head) : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.func_190926_b() ? ((IDrillHead)head.func_77973_b()).getHeadDamage(head) : 0;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity living) {
        ItemStack head;
        if (state.func_185887_b((IBlockReader)world, pos) != 0.0f && !(head = this.getHead(stack)).func_190926_b()) {
            if (living instanceof PlayerEntity) {
                if (((PlayerEntity)living).field_71075_bZ.field_75098_d) {
                    return true;
                }
                ((IDrillHead)head.func_77973_b()).afterBlockbreak(stack, head, (PlayerEntity)living);
            }
            this.consumeDurability(stack, world, state, pos, living);
        }
        return true;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        ((IDrillHead)head.func_77973_b()).damageHead(head, amount);
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        ItemStack head = this.getHead(stack);
        if (!head.func_190926_b()) {
            return ((IDrillHead)head.func_77973_b()).getMiningLevel(head) + ItemNBTHelper.getInt(stack, "harvestLevel");
        }
        return 0;
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!this.getHead(stack).func_190926_b() && this.canToolBeUsed(stack, null)) {
            return ImmutableSet.of((Object)ToolType.PICKAXE, (Object)ToolType.SHOVEL);
        }
        return super.getToolTypes(stack);
    }

    @Override
    public boolean isEffective(ItemStack stack, Material mat) {
        for (Material m : validMaterials) {
            if (m != mat) continue;
            return true;
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        ItemStack head = this.getHead(stack);
        if (!head.func_190926_b() && this.canToolBeUsed(stack, null)) {
            return ((IDrillHead)head.func_77973_b()).getMiningSpeed(head) + this.getUpgrades(stack).func_74760_g("speed");
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canBreakExtraBlock(World world, Block block, BlockPos pos, BlockState state, PlayerEntity player, ItemStack drill, ItemStack head, boolean inWorld) {
        if (block.canHarvestBlock(state, (IBlockReader)world, pos, player) && this.isEffective(drill, state.func_185904_a()) && this.canToolBeUsed(drill, (LivingEntity)player)) {
            if (inWorld) {
                return !((IDrillHead)head.func_77973_b()).beforeBlockbreak(drill, head, player);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos iPos, PlayerEntity player) {
        World world = player.field_70170_p;
        if (player.func_225608_bj_() || world.field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return false;
        }
        BlockRayTraceResult mop = DrillItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        ItemStack head = this.getHead(stack);
        if (mop == null || head.func_190926_b() || !this.canToolBeUsed(stack, (LivingEntity)player)) {
            return false;
        }
        ImmutableList<BlockPos> additional = ((IDrillHead)head.func_77973_b()).getExtraBlocksDug(head, world, player, (RayTraceResult)mop);
        for (BlockPos pos : additional) {
            int xpDropEvent;
            BlockState state;
            Block block;
            if (!world.func_175667_e(pos) || (block = (state = world.func_180495_p(pos)).func_177230_c()) == null || block.isAir(state, (IBlockReader)world, pos) || state.func_185903_a(player, (IBlockReader)world, pos) == 0.0f || !this.canBreakExtraBlock(world, block, pos, state, player, stack, head, true) || (xpDropEvent = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos)) < 0) continue;
            if (player.field_71075_bZ.field_75098_d) {
                block.func_176208_a(world, pos, state, player);
                if (block.removedByPlayer(state, world, pos, player, false, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                }
            } else {
                block.func_176208_a(world, pos, state, player);
                TileEntity te = world.func_175625_s(pos);
                stack.func_179548_a(world, state, pos, player);
                if (block.removedByPlayer(state, world, pos, player, true, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                    block.func_180657_a(world, player, pos, state, te, stack);
                    if (world instanceof ServerWorld) {
                        block.func_180637_b((ServerWorld)world, pos, xpDropEvent);
                    }
                }
            }
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String group, String material) {
        if (!"head".equals(material)) {
            return null;
        }
        ItemStack head = this.getHead(stack);
        if (head.func_77973_b() instanceof IDrillHead) {
            return ((IDrillHead)head.func_77973_b()).getDrillTexture(stack, this.getHead(stack));
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.equals("drill_frame") || group.equals("drill_grip")) {
            return true;
        }
        CompoundNBT upgrades = this.getUpgrades(stack);
        if (group.equals("upgrade_waterproof")) {
            return upgrades.func_74767_n("waterproof");
        }
        if (group.equals("upgrade_speed")) {
            return upgrades.func_74767_n("oiled");
        }
        if (!this.getHead(stack).func_190926_b()) {
            if (group.equals("drill_head")) {
                return true;
            }
            if (group.equals("upgrade_damage0")) {
                return upgrades.func_74762_e("damage") > 0;
            }
            if (group.equals("upgrade_damage1") || group.equals("upgrade_damage2")) {
                return upgrades.func_74762_e("damage") > 1;
            }
            if (group.equals("upgrade_damage3") || group.equals("upgrade_damage4")) {
                return upgrades.func_74762_e("damage") > 2;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(ItemStack stack, String group, TransformationMatrix transform) {
        CompoundNBT upgrades = this.getUpgrades(stack);
        if (group.equals("drill_head") && upgrades.func_74762_e("damage") <= 0) {
            return transform.compose(new TransformationMatrix(new Vector3f(-0.25f, 0.0f, 0.0f), null, null, null));
        }
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String[][] getSpecialGroups(ItemStack stack, ItemCameraTransforms.TransformType transform, LivingEntity entity) {
        if (this.shouldRotate(entity, stack, transform)) {
            return ROTATING;
        }
        return FIXED;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix getTransformForGroups(ItemStack stack, String[] groups, ItemCameraTransforms.TransformType transform, LivingEntity entity, float partialTicks) {
        if (matAugers == null) {
            matAugers = new TransformationMatrix(new Vector3f(0.441f, 0.0f, 0.0f), null, null, null);
        }
        if (groups == FIXED[0]) {
            return matAugers;
        }
        float angle = ((float)(entity.field_70173_aa % 60) + partialTicks) / 60.0f * ((float)Math.PI * 2);
        Quaternion rotation = null;
        Vector3f translation = null;
        if ("drill_head".equals(groups[0])) {
            rotation = new Quaternion(angle, 0.0f, 0.0f, false);
        } else if ("upgrade_damage1".equals(groups[0])) {
            translation = new Vector3f(0.441f, 0.0f, 0.0f);
            rotation = new Quaternion(0.0f, angle, 0.0f, false);
        } else if ("upgrade_damage3".equals(groups[0])) {
            translation = new Vector3f(0.441f, 0.0f, 0.0f);
            rotation = new Quaternion(0.0f, 0.0f, angle, false);
        }
        return new TransformationMatrix(translation, rotation, null, null);
    }
}

