/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class HammerItem
extends IEBaseItem
implements ITool {
    public static final ToolType HAMMER_TOOL = ToolType.get((String)"immersiveengineering_hammer");

    public HammerItem() {
        super("hammer", new Item.Properties().func_200915_b(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)IEServerConfig.TOOLS.hammerDurabiliy.getOrDefault();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String s;
        ListNBT tagList;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemNBTHelper.hasKey(stack, "multiblockPermission")) {
            tagList = stack.func_196082_o().func_150295_c("multiblockPermission", 8);
            s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblocksAllowed", (Object[])new Object[0]);
            this.addInfo(tooltip, s, tagList);
        }
        if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
            tagList = stack.func_196082_o().func_150295_c("multiblockInterdiction", 8);
            s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblockForbidden", (Object[])new Object[0]);
            this.addInfo(tooltip, s, tagList);
        }
    }

    private void addInfo(List<ITextComponent> list, String s, ListNBT tagList) {
        if (!Screen.func_231173_s_()) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.holdShift", new Object[]{s}));
        } else {
            list.add((ITextComponent)new StringTextComponent(s));
            for (int i = 0; i < tagList.size(); ++i) {
                list.add((ITextComponent)ClientUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.multiblock." + tagList.func_150307_f(i)), TextFormatting.DARK_GRAY));
            }
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        boolean rotate;
        ListNBT list;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Direction side = context.func_196000_l();
        List<ResourceLocation> permittedMultiblocks = null;
        List interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey(stack, "multiblockPermission")) {
            list = stack.func_196082_o().func_150295_c("multiblockPermission", 8);
            Optional<List<ResourceLocation>> permittedMultiblocksResult = HammerItem.parseUserDefinedRLs(list, player, "permission");
            if (!permittedMultiblocksResult.isPresent()) {
                return ActionResultType.FAIL;
            }
            permittedMultiblocks = permittedMultiblocksResult.get();
        }
        if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
            list = stack.func_196082_o().func_150295_c("multiblockInterdiction", 8);
            Optional<List<ResourceLocation>> interdictedMultiblocksResult = HammerItem.parseUserDefinedRLs(list, player, "interdiction");
            if (!interdictedMultiblocksResult.isPresent()) {
                return ActionResultType.FAIL;
            }
            interdictedMultiblocks = (List)interdictedMultiblocksResult.get();
        }
        Direction multiblockSide = side.func_176740_k() == Direction.Axis.Y && player != null ? Direction.func_176733_a((double)player.field_70177_z).func_176734_d() : side;
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean isAllowed;
            if (!mb.isBlockTrigger(world.func_180495_p(pos), multiblockSide, world) || !(isAllowed = permittedMultiblocks != null ? permittedMultiblocks.contains(mb.getUniqueName()) : (interdictedMultiblocks != null ? !interdictedMultiblocks.contains(mb.getUniqueName()) : true)) || MultiblockHandler.postMultiblockFormationEvent(player, mb, pos, stack).isCanceled() || !mb.createStructure(world, pos, multiblockSide, player)) continue;
            if (player instanceof ServerPlayerEntity) {
                IEAdvancements.TRIGGER_MULTIBLOCK.trigger((ServerPlayerEntity)player, mb, stack);
            }
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IEBlockInterfaces.IConfigurableSides) {
            Direction activeSide;
            Direction direction = activeSide = player != null && player.func_225608_bj_() ? side.func_176734_d() : side;
            if (((IEBlockInterfaces.IConfigurableSides)tile).toggleSide(activeSide, player)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        boolean bl = rotate = !(tile instanceof IEBlockInterfaces.IDirectionalTile) && !(tile instanceof IEBlockInterfaces.IHammerInteraction);
        if (!rotate && tile instanceof IEBlockInterfaces.IDirectionalTile) {
            rotate = ((IEBlockInterfaces.IDirectionalTile)tile).canHammerRotate(side, context.func_221532_j().func_178788_d(Vector3d.func_237491_b_((Vector3i)pos)), (LivingEntity)player);
        }
        if (rotate && RotationUtil.rotateBlock(world, pos, player != null && player.func_225608_bj_() != side.equals((Object)Direction.DOWN))) {
            return ActionResultType.SUCCESS;
        }
        if (!rotate && tile instanceof IEBlockInterfaces.IHammerInteraction && ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, context.func_221531_n(), context.func_221532_j())) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static Optional<List<ResourceLocation>> parseUserDefinedRLs(ListNBT data, PlayerEntity player, String prefix) {
        DataResult<List<ResourceLocation>> result = HammerItem.parseUserDefinedRLs(data);
        return result.resultOrPartial(err -> {
            if (player != null && !player.func_130014_f_().field_72995_K) {
                player.func_146105_b((ITextComponent)new StringTextComponent("Invalid " + prefix + " entry: " + err), false);
            }
        });
    }

    private static DataResult<List<ResourceLocation>> parseUserDefinedRLs(ListNBT data) {
        return Codec.list((Codec)ResourceLocation.field_240908_a_).parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)data);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        if (container.func_96631_a(1, Utils.RAND, null)) {
            return ItemStack.field_190927_a;
        }
        return container;
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return 14;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!player.field_70170_p.field_72995_K && RotationUtil.rotateEntity((Entity)entity, player)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public Set<ToolType> getToolTypes(ItemStack stack) {
        return ImmutableSet.of((Object)HAMMER_TOOL);
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (this.getToolTypes(stack).contains(tool)) {
            return 2;
        }
        return -1;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        for (ToolType type : this.getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return 6.0f;
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        if (state.func_177230_c() instanceof IEBaseBlock) {
            return ((IEBaseBlock)state.func_177230_c()).allowHammerHarvest(state);
        }
        return state.func_177230_c().isToolEffective(state, HAMMER_TOOL);
    }
}

