/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Triple;

public class RailgunItem
extends UpgradeableToolItem
implements EnergyHelper.IIEEnergyItem,
ZoomHandler.IZoomTool,
IEItemInterfaces.IScrollwheel,
ITool,
IOBJModelCallback<ItemStack> {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public RailgunItem() {
        super("railgun", new Item.Properties().func_200917_a(1).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE), "RAILGUN");
    }

    @Override
    public int getSlotCount() {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 80, 32, "RAILGUN", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 1, 100, 32, "RAILGUN", stack, true, getWorld, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, World w, PlayerEntity player) {
        super.recalculateUpgrades(stack, w, player);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.putInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.putInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.func_77989_b((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final LazyOptional<EnergyHelper.ItemEnergyStorage> energyStorage;
                final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.energyStorage = CapabilityUtils.constantOptional(new EnergyHelper.ItemEnergyStorage(stack));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "railgun"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return this.energyStorage.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.energyStored", new Object[]{stored}));
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.NONE;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int energy = (Integer)IEServerConfig.TOOLS.railgun_consumption.get();
        float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !RailgunItem.findAmmo(stack, player).func_190926_b()) {
            player.func_184598_c(hand);
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getChargeTime(stack) <= 20 ? IESounds.chargeFast : IESounds.chargeSlow, SoundCategory.PLAYERS, 1.5f, 1.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity user, int count) {
        int inUse = this.func_77626_a(stack) - count;
        if (inUse > this.getChargeTime(stack) && inUse % 20 == user.func_70681_au().nextInt(20)) {
            user.field_70170_p.func_184148_a(null, user.func_226277_ct_(), user.func_226278_cu_(), user.func_226281_cx_(), IESounds.spark, SoundCategory.PLAYERS, 0.8f + 0.2f * user.func_70681_au().nextFloat(), 0.5f + 0.5f * user.func_70681_au().nextFloat());
            Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader = ShaderRegistry.getStoredShaderAndCase(stack);
            if (shader != null) {
                Vector3d pos = Utils.getLivingFrontPos(user, 0.4375, (double)user.func_213302_cg() * 0.75, ItemUtils.getLivingHand(user, user.func_184600_cs()), false, 1.0f);
                ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(user.field_70170_p, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType().toString(), pos, null, 0.0625f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity user, int timeLeft) {
        if (user instanceof PlayerEntity) {
            ItemStack ammo;
            int inUse = this.func_77626_a(stack) - timeLeft;
            ItemNBTHelper.remove(stack, "inUse");
            if (inUse < this.getChargeTime(stack)) {
                return;
            }
            int energy = (Integer)IEServerConfig.TOOLS.railgun_consumption.get();
            float energyMod = 1.0f + this.getUpgrades(stack).func_74760_g("consumption");
            if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && !(ammo = RailgunItem.findAmmo(stack, (PlayerEntity)user)).func_190926_b()) {
                Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader;
                ItemStack ammoConsumed = ammo.func_77979_a(1);
                RailgunHandler.IRailgunProjectile projectileProperties = RailgunHandler.getProjectile(ammoConsumed);
                Vector3d vec = user.func_70040_Z();
                float speed = 20.0f;
                RailgunShotEntity shot = new RailgunShotEntity(user.field_70170_p, user, vec.field_72450_a * (double)speed, vec.field_72448_b * (double)speed, vec.field_72449_c * (double)speed, ammoConsumed);
                shot = projectileProperties.getProjectile((PlayerEntity)user, ammoConsumed, (Entity)shot);
                user.field_70170_p.func_184148_a(null, user.func_226277_ct_(), user.func_226278_cu_(), user.func_226281_cx_(), IESounds.railgunFire, SoundCategory.PLAYERS, 1.0f, 0.5f + 0.5f * user.func_70681_au().nextFloat());
                this.extractEnergy(stack, energy, false);
                if (!world.field_72995_K) {
                    user.field_70170_p.func_217376_c((Entity)shot);
                }
                if ((shader = ShaderRegistry.getStoredShaderAndCase(stack)) != null) {
                    HandSide handside = user.func_184591_cq();
                    if (user.func_184600_cs() != Hand.MAIN_HAND) {
                        handside = handside == HandSide.LEFT ? HandSide.RIGHT : HandSide.LEFT;
                    }
                    Vector3d pos = Utils.getLivingFrontPos(user, 0.75, (double)user.func_213302_cg() * 0.75, handside, false, 1.0f);
                    ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType().toString(), pos, Vector3d.func_189984_a((Vector2f)user.func_189653_aC()), 0.125f);
                }
            }
        }
    }

    public static ItemStack findAmmo(ItemStack railgun, PlayerEntity player) {
        int slot;
        ItemStack ammo;
        if (ItemNBTHelper.hasKey(railgun, "ammo_slot") && !(ammo = RailgunItem.findAmmoInSlot(player, slot = ItemNBTHelper.getInt(railgun, "ammo_slot"))).func_190926_b()) {
            return ammo;
        }
        if (RailgunItem.isAmmo(player.func_184586_b(Hand.OFF_HAND))) {
            ItemNBTHelper.putInt(railgun, "ammo_slot", 0);
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (RailgunItem.isAmmo(player.func_184586_b(Hand.MAIN_HAND))) {
            ItemNBTHelper.putInt(railgun, "ammo_slot", 1);
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!RailgunItem.isAmmo(itemstack)) continue;
            ItemNBTHelper.putInt(railgun, "ammo_slot", 2 + i);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findAmmoInSlot(PlayerEntity player, int slot) {
        ItemStack ammo = ItemStack.field_190927_a;
        if (slot == 0 || slot == 1) {
            ammo = player.func_184586_b(slot == 0 ? Hand.MAIN_HAND : Hand.OFF_HAND);
        } else if (slot > 1 && slot - 2 < player.field_71071_by.func_70302_i_()) {
            ammo = player.field_71071_by.func_70301_a(slot - 2);
        }
        if (RailgunItem.isAmmo(ammo)) {
            return ammo;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        RailgunHandler.IRailgunProjectile prop = RailgunHandler.getProjectile(stack);
        return prop != null;
    }

    private boolean checkAmmoSlot(ItemStack stack, PlayerEntity player, int actualSlot) {
        if (!RailgunItem.findAmmoInSlot(player, actualSlot).func_190926_b()) {
            ItemNBTHelper.putInt(stack, "ammo_slot", actualSlot);
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void onScrollwheel(ItemStack stack, PlayerEntity player, boolean forward) {
        int slot = ItemNBTHelper.getInt(stack, "ammo_slot");
        int count = player.field_71071_by.func_70302_i_() + 2;
        if (forward) {
            for (int i = 1; i < count; ++i) {
                if (!this.checkAmmoSlot(stack, player, (slot + i) % count)) continue;
                return;
            }
        } else {
            for (int i = count - 1; i >= 1; --i) {
                if (!this.checkAmmoSlot(stack, player, (slot + i) % count)) continue;
                return;
            }
        }
    }

    public int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + this.getUpgrades(railgun).func_74760_g("speed")));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        invCap.ifPresent(inv -> {
            if (!inv.getStackInSlot(0).func_190926_b() && !inv.getStackInSlot(1).func_190926_b()) {
                Utils.unlockIEAdvancement(player, "main/upgrade_railgun");
            }
        });
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 8000;
    }

    public String[] compileRender(ItemStack stack) {
        HashSet<String> render = new HashSet<String>();
        render.add("frame");
        render.add("barrel");
        render.add("grip");
        render.add("capacitors");
        render.add("sled");
        render.add("wires");
        CompoundNBT upgrades = this.getUpgrades(stack);
        if (upgrades.func_74769_h("speed") > 0.0) {
            render.add("upgrade_speed");
        }
        if (upgrades.func_74767_n("scope")) {
            render.add("upgrade_scope");
        }
        return render.toArray(new String[render.size()]);
    }

    @Override
    public boolean canZoom(ItemStack stack, PlayerEntity player) {
        return this.getUpgrades(stack).func_74767_n("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, PlayerEntity player) {
        return this.zoomSteps;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.equals("upgrade_scope")) {
            return this.getUpgrades(stack).func_74767_n("scope");
        }
        if (group.equals("upgrade_speed")) {
            return this.getUpgrades(stack).func_74769_h("speed") > 0.0;
        }
        if (group.equals("barrel_top")) {
            return this.getUpgrades(stack).func_74769_h("speed") <= 0.0;
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(ItemStack stack, String group, TransformationMatrix transform) {
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat, LivingEntity entity) {
    }
}

