/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.RevolverContainer;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Triple;

public class RevolverItem
extends UpgradeableToolItem
implements IOBJModelCallback<ItemStack>,
ITool,
IEItemInterfaces.IBulletContainer {
    public static UUID speedModUUID = Utils.generateNewUUID();
    public static UUID luckModUUID = Utils.generateNewUUID();
    public static HashMap<String, TextureAtlasSprite> revolverIcons = new HashMap();
    public static TextureAtlasSprite revolverDefaultTexture;
    private static final String[][] groups;
    @OnlyIn(value=Dist.CLIENT)
    private static TransformationMatrix matOpen;
    @OnlyIn(value=Dist.CLIENT)
    private static TransformationMatrix matClose;
    @OnlyIn(value=Dist.CLIENT)
    private static TransformationMatrix matCylinder;
    public static final ArrayListMultimap<String, SpecialRevolver> specialRevolvers;
    public static final Map<String, SpecialRevolver> specialRevolversByTag;

    public RevolverItem() {
        super("revolver", RevolverItem.withIEOBJRender().func_200917_a(1).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE), "REVOLVER");
    }

    public static void addRevolverTextures(TextureStitchEvent.Pre evt) {
        evt.addSprite(new ResourceLocation("immersiveengineering", "revolvers/revolver"));
        for (String key : specialRevolversByTag.keySet()) {
            if (key.isEmpty() || RevolverItem.specialRevolversByTag.get((Object)key).tag.isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            evt.addSprite(new ResourceLocation("immersiveengineering", "revolvers/revolver_" + key.substring(0, split).toLowerCase(Locale.US)));
        }
    }

    public static void retrieveRevolverTextures(AtlasTexture map) {
        revolverDefaultTexture = map.func_195424_a(new ResourceLocation("immersiveengineering:revolvers/revolver"));
        for (String key : specialRevolversByTag.keySet()) {
            if (key.isEmpty() || RevolverItem.specialRevolversByTag.get((Object)key).tag.isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            revolverIcons.put(key, map.func_195424_a(new ResourceLocation("immersiveengineering:revolvers/revolver_" + key.substring(0, split).toLowerCase(Locale.US))));
        }
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        ret = ret == null ? new CompoundNBT() : ret.func_74737_b();
        CompoundNBT retFinal = ret;
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
            NonNullList bullets = NonNullList.func_191197_a((int)this.getBulletCount(stack), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.getBulletCount(stack); ++i) {
                bullets.set(i, (Object)handler.getStackInSlot(i));
            }
            retFinal.func_218657_a("bullets", (INBT)Utils.writeInventory((Collection<ItemStack>)bullets));
        });
        return retFinal;
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "revolver"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public int getSlotCount() {
        return 21;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        return new Slot[]{new IESlot.Upgrades(container, inv, 18, 80, 32, "REVOLVER", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, inv, 19, 100, 32, "REVOLVER", stack, true, getWorld, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(inv -> {
            if (!inv.getStackInSlot(18).func_190926_b() && !inv.getStackInSlot(19).func_190926_b()) {
                Utils.unlockIEAdvancement(player, "main/upgrade_revolver");
            }
        });
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            return this.func_77658_a() + "." + tag;
        }
        return super.func_77667_c(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.revolver." + tag));
        } else if (ItemNBTHelper.hasKey(stack, "flavour")) {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.revolver." + ItemNBTHelper.getString(stack, "flavour")));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.revolver"));
        }
        CompoundNBT perks = this.getPerks(stack);
        for (String key : perks.func_150296_c()) {
            RevolverPerk perk = RevolverPerk.get(key);
            if (perk == null) continue;
            list.add((ITextComponent)new StringTextComponent("  ").func_230529_a_(perk.getDisplayString(perks.func_74769_h(key))));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlotType.MAINHAND) {
            double melee;
            if (this.getUpgrades(stack).func_74767_n("fancyAnimation")) {
                builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION));
            }
            if ((melee = this.getUpgradeValue_d(stack, "melee")) != 0.0) {
                builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", melee, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
            }
        }
        if (slot.func_188453_a() == EquipmentSlotType.Group.HAND) {
            double luck;
            double speed = this.getUpgradeValue_d(stack, "speed");
            if (speed != 0.0) {
                builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(speedModUUID, "Weapon modifier", speed, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if ((luck = this.getUpgradeValue_d(stack, RevolverPerk.LUCK.getNBTKey())) != 0.0) {
                builder.put((Object)Attributes.field_233828_k_, (Object)new AttributeModifier(luckModUUID, "Weapon modifier", luck, AttributeModifier.Operation.ADDITION));
            }
        }
        return builder.build();
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        super.func_77663_a(stack, world, ent, slot, inHand);
        if (ItemNBTHelper.hasKey(stack, "reload")) {
            int reload = ItemNBTHelper.getInt(stack, "reload") - 1;
            if (reload <= 0) {
                ItemNBTHelper.remove(stack, "reload");
            } else {
                ItemNBTHelper.putInt(stack, "reload", reload);
            }
        }
        if (ItemNBTHelper.hasKey(stack, "cooldown")) {
            int cooldown = ItemNBTHelper.getInt(stack, "cooldown") - 1;
            if (cooldown <= 0) {
                ItemNBTHelper.remove(stack, "cooldown");
            } else {
                ItemNBTHelper.putInt(stack, "cooldown", cooldown);
            }
        }
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BOW;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack revolver = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.openGui(player, hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND);
                return new ActionResult(ActionResultType.SUCCESS, (Object)revolver);
            }
            if (player.func_184825_o(1.0f) >= 1.0f) {
                if (this.getUpgrades(revolver).func_74767_n("nerf")) {
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 0.6f);
                } else {
                    if (this.getShootCooldown(revolver) > 0 || ItemNBTHelper.hasKey(revolver, "reload")) {
                        return new ActionResult(ActionResultType.PASS, (Object)revolver);
                    }
                    NonNullList<ItemStack> bullets = this.getBullets(revolver, false);
                    if (this.isEmpty(revolver, false)) {
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack stack = player.field_71071_by.func_70301_a(i);
                            if (!(stack.func_77973_b() instanceof SpeedloaderItem) || ((SpeedloaderItem)stack.func_77973_b()).isEmpty(stack)) continue;
                            for (ItemStack b : bullets) {
                                if (b.func_190926_b()) continue;
                                world.func_217376_c((Entity)new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), b));
                            }
                            this.setBullets(revolver, ((SpeedloaderItem)stack.func_77973_b()).getContainedItems(stack), true);
                            ((SpeedloaderItem)stack.func_77973_b()).setContainedItems(stack, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a));
                            player.field_71071_by.func_70296_d();
                            if (player instanceof ServerPlayerEntity) {
                                ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSpeedloaderSync(i, hand));
                            }
                            ItemNBTHelper.putInt(revolver, "reload", 60);
                            return new ActionResult(ActionResultType.SUCCESS, (Object)revolver);
                        }
                    }
                    if (!ItemNBTHelper.hasKey(revolver, "reload")) {
                        Item bullet0 = ((ItemStack)bullets.get(0)).func_77973_b();
                        if (bullet0 instanceof BulletItem) {
                            BulletHandler.IBullet bullet = ((BulletItem)bullet0).getType();
                            if (bullet != null) {
                                Vector3d vec = player.func_70040_Z();
                                boolean electro = this.getUpgrades(revolver).func_74767_n("electro");
                                int count = bullet.getProjectileCount(player);
                                if (count == 1) {
                                    RevolvershotEntity entBullet = this.getBullet(player, vec, bullet, electro);
                                    player.field_70170_p.func_217376_c(bullet.getProjectile(player, (ItemStack)bullets.get(0), (Entity)entBullet, electro));
                                } else {
                                    for (int i = 0; i < count; ++i) {
                                        Vector3d vecDir = vec.func_72441_c(player.func_70681_au().nextGaussian() * 0.1, player.func_70681_au().nextGaussian() * 0.1, player.func_70681_au().nextGaussian() * 0.1);
                                        RevolvershotEntity entBullet = this.getBullet(player, vecDir, bullet, electro);
                                        player.field_70170_p.func_217376_c(bullet.getProjectile(player, (ItemStack)bullets.get(0), (Entity)entBullet, electro));
                                    }
                                }
                                bullets.set(0, (Object)bullet.getCasing((ItemStack)bullets.get(0)).func_77946_l());
                                float noise = 0.5f;
                                if (this.hasUpgradeValue(revolver, RevolverPerk.NOISE.getNBTKey())) {
                                    noise *= (float)this.getUpgradeValue_d(revolver, RevolverPerk.NOISE.getNBTKey());
                                }
                                Utils.attractEnemies((LivingEntity)player, 64.0f * noise);
                                SoundEvent sound = bullet.getSound();
                                if (sound == null) {
                                    sound = IESounds.revolverFire;
                                }
                                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, noise, 1.0f);
                            } else {
                                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187685_dH, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            }
                        } else {
                            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187685_dH, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        this.rotateCylinder(revolver, player, true, bullets);
                        ItemNBTHelper.putInt(revolver, "cooldown", this.getMaxShootCooldown(revolver));
                        return new ActionResult(ActionResultType.SUCCESS, (Object)revolver);
                    }
                }
            }
        } else if (!player.func_225608_bj_()) {
            Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader;
            if (this.getShootCooldown(revolver) > 0 || ItemNBTHelper.hasKey(revolver, "reload")) {
                return new ActionResult(ActionResultType.PASS, (Object)revolver);
            }
            NonNullList bullets = this.getBullets(revolver);
            if (!((ItemStack)bullets.get(0)).func_190926_b() && ((ItemStack)bullets.get(0)).func_77973_b() instanceof BulletItem && (shader = ShaderRegistry.getStoredShaderAndCase(revolver)) != null) {
                Vector3d pos = Utils.getLivingFrontPos((LivingEntity)player, 0.75, (double)player.func_213302_cg() * 0.75, ItemUtils.getLivingHand((LivingEntity)player, hand), false, 1.0f);
                ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), revolver, ((ShaderCase)shader.getRight()).getShaderType().toString(), pos, Vector3d.func_189984_a((Vector2f)player.func_189653_aC()), 0.125f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)revolver);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)revolver);
    }

    public int getShootCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, "cooldown");
    }

    public int getMaxShootCooldown(ItemStack stack) {
        if (this.hasUpgradeValue(stack, RevolverPerk.COOLDOWN.getNBTKey())) {
            return (int)Math.ceil(15.0 * this.getUpgradeValue_d(stack, RevolverPerk.COOLDOWN.getNBTKey()));
        }
        return 15;
    }

    @Override
    public int getBulletCount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).func_74762_e("bullets");
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver, boolean remote) {
        if (!remote && this.isEmpty(revolver, true)) {
            remote = true;
        } else if (remote && (!ItemNBTHelper.hasKey(revolver, "bullets", 9) || revolver.func_196082_o().func_150295_c("bullets", 10).isEmpty())) {
            remote = false;
        }
        if (!remote) {
            return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getBulletCount(revolver)));
        }
        return Utils.readInventory(revolver.func_196082_o().func_150295_c("bullets", 10), this.getBulletCount(revolver));
    }

    private RevolvershotEntity getBullet(PlayerEntity player, Vector3d vecDir, BulletHandler.IBullet type, boolean electro) {
        IELogger.logger.info("Starting with motion vector {}", (Object)vecDir);
        RevolvershotEntity bullet = new RevolvershotEntity(player.field_70170_p, (LivingEntity)player, vecDir.field_72450_a * 1.5, vecDir.field_72448_b * 1.5, vecDir.field_72449_c * 1.5, type);
        bullet.func_213317_d(vecDir.func_186678_a(2.0));
        bullet.bulletElectro = electro;
        return bullet;
    }

    public void setBullets(ItemStack revolver, NonNullList<ItemStack> bullets, boolean ignoreExtendedMag) {
        int i;
        IItemHandlerModifiable inv = (IItemHandlerModifiable)revolver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        for (i = 0; i < 18; ++i) {
            inv.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (ignoreExtendedMag && this.getUpgrades(revolver).func_74762_e("bullets") > 0) {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i < 2 ? i : i + this.getUpgrades(revolver).func_74762_e("bullets"), (ItemStack)bullets.get(i));
            }
        } else {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i, (ItemStack)bullets.get(i));
            }
        }
    }

    public void rotateCylinder(ItemStack revolver, PlayerEntity player, boolean forward, NonNullList<ItemStack> bullets) {
        NonNullList cycled = NonNullList.func_191197_a((int)this.getBulletCount(revolver), (Object)ItemStack.field_190927_a);
        int offset = forward ? -1 : 1;
        for (int i = 0; i < cycled.size(); ++i) {
            cycled.set((i + offset + cycled.size()) % cycled.size(), bullets.get(i));
        }
        this.setBullets(revolver, (NonNullList<ItemStack>)cycled, false);
        player.field_71071_by.func_70296_d();
    }

    public void rotateCylinder(ItemStack revolver, PlayerEntity player, boolean forward) {
        NonNullList bullets = this.getBullets(revolver);
        this.rotateCylinder(revolver, player, forward, (NonNullList<ItemStack>)bullets);
    }

    public boolean isEmpty(ItemStack stack, boolean allowCasing) {
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return invCap.map(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                boolean isValid = true;
                if (!allowCasing) {
                    isValid = b.func_77973_b() instanceof BulletItem;
                }
                if (b.func_190926_b() || !isValid) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public CompoundNBT getUpgradeBase(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "baseUpgrades");
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    public CompoundNBT getPerks(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "perks");
    }

    public boolean hasUpgradeValue(ItemStack stack, String key) {
        return this.getUpgrades(stack).func_74764_b(key) || this.getPerks(stack).func_74764_b(key);
    }

    public double getUpgradeValue_d(ItemStack stack, String key) {
        return this.getUpgrades(stack).func_74769_h(key) + this.getPerks(stack).func_74769_h(key);
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        ArrayList list;
        if (stack.func_190926_b() || player == null) {
            return;
        }
        String uuid = player.func_110124_au().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = ItemNBTHelper.getString(stack, "elite");
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack, world, player);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            ItemNBTHelper.remove(stack, "elite");
            ItemNBTHelper.remove(stack, "flavour");
            ItemNBTHelper.remove(stack, "baseUpgrades");
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            ItemNBTHelper.putString(stack, "elite", r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            ItemNBTHelper.putString(stack, "flavour", r.flavour);
        }
        CompoundNBT baseUpgrades = new CompoundNBT();
        for (Map.Entry<String, Object> e : r.baseUpgrades.entrySet()) {
            if (e.getValue() instanceof Boolean) {
                baseUpgrades.func_74757_a(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                baseUpgrades.func_74768_a(e.getKey(), ((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof Float) {
                baseUpgrades.func_74780_a(e.getKey(), (double)((Float)e.getValue()).floatValue());
                continue;
            }
            if (e.getValue() instanceof Double) {
                baseUpgrades.func_74780_a(e.getKey(), ((Double)e.getValue()).doubleValue());
                continue;
            }
            if (!(e.getValue() instanceof String)) continue;
            baseUpgrades.func_74778_a(e.getKey(), (String)e.getValue());
        }
        ItemNBTHelper.setTagCompound(stack, "baseUpgrades", baseUpgrades);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.func_77989_b((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        if (ItemNBTHelper.hasKey(oldStack, "elite") || ItemNBTHelper.hasKey(newStack, "elite")) {
            return !ItemNBTHelper.getString(oldStack, "elite").equals(ItemNBTHelper.getString(newStack, "elite"));
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String group, String material) {
        String tag = ItemNBTHelper.getString(stack, "elite");
        if (!tag.isEmpty()) {
            return revolverIcons.get(tag);
        }
        return revolverDefaultTexture;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        SpecialRevolver r;
        if (group.equals("frame") || group.equals("cylinder") || group.equals("barrel") || group.equals("cosmetic_compensator")) {
            return true;
        }
        HashSet<String> render = new HashSet<String>();
        String tag = ItemNBTHelper.getString(stack, "elite");
        String flavour = ItemNBTHelper.getString(stack, "flavour");
        if (!tag.isEmpty() && specialRevolversByTag.containsKey(tag)) {
            r = specialRevolversByTag.get(tag);
            if (r != null && r.renderAdditions != null) {
                Collections.addAll(render, r.renderAdditions);
            }
        } else if (!flavour.isEmpty() && specialRevolversByTag.containsKey(flavour) && (r = specialRevolversByTag.get(flavour)) != null && r.renderAdditions != null) {
            Collections.addAll(render, r.renderAdditions);
        }
        CompoundNBT upgrades = this.getUpgrades(stack);
        if (upgrades.func_74762_e("bullets") > 0 && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (upgrades.func_74769_h("melee") > 0.0 && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (upgrades.func_74767_n("electro")) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        return render.contains(group);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePerspective(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat, @Nullable LivingEntity entity) {
        if (entity instanceof PlayerEntity && (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            float f;
            boolean left;
            boolean main = (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) == (entity.func_184591_cq() == HandSide.RIGHT);
            boolean bl = left = cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            if (this.getUpgrades(stack).func_74767_n("fancyAnimation") && main && (f = ((PlayerEntity)entity).func_184825_o(ClientUtils.mc().func_184121_ak())) < 1.0f) {
                float angle = f * -6.28318f;
                if (left) {
                    angle *= -1.0f;
                }
                mat.func_227861_a_(0.0, 1.5 - (double)f, 0.0);
                mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), angle, false));
            }
            ItemStack itemStack = stack = main ? entity.func_184614_ca() : entity.func_184592_cb();
            if (ItemNBTHelper.hasKey(stack, "reload")) {
                f = 3.0f - (float)ItemNBTHelper.getInt(stack, "reload") / 20.0f;
                if ((double)f > 0.35 && (double)f < 1.95) {
                    if ((double)f < 0.5) {
                        mat.func_227861_a_((0.35 - (double)f) * 2.0, 0.0, 0.0);
                        mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f), 2.64f * (f - 0.35f), false));
                    } else if ((double)f < 0.6) {
                        mat.func_227861_a_(((double)f - 0.5) * 6.0, (0.5 - (double)f) * 1.0, 0.0);
                        mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f), 0.87266f, false));
                    } else if ((double)f < 1.7) {
                        mat.func_227861_a_(0.0, -0.6, 0.0);
                        mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f), 0.87266f, false));
                    } else if ((double)f < 1.8) {
                        mat.func_227861_a_((1.8 - (double)f) * 6.0, ((double)f - 1.8) * 1.0, 0.0);
                        mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f), 0.87266f, false));
                    } else {
                        mat.func_227861_a_((double)((f - 1.95f) * 2.0f), 0.0, 0.0);
                        mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f), 2.64f * (1.95f - f), false));
                    }
                }
            } else if (((PlayerEntity)entity).field_71070_bA instanceof RevolverContainer) {
                mat.func_227861_a_(left ? 0.4 : -0.4, 0.4, 0.0);
                mat.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f), 0.87266f, false));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String[][] getSpecialGroups(ItemStack stack, ItemCameraTransforms.TransformType transform, LivingEntity entity) {
        return groups;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix getTransformForGroups(ItemStack stack, String[] groups, ItemCameraTransforms.TransformType transform, LivingEntity entity, float partialTicks) {
        if (matOpen == null) {
            matOpen = new TransformationMatrix(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternion(0.0f, 0.0f, -0.87266f, false), null, null);
        }
        if (matClose == null) {
            matClose = new TransformationMatrix(new Vector3f(-0.625f, 0.25f, 0.0f), null, null, null);
        }
        if (matCylinder == null) {
            matCylinder = new TransformationMatrix(new Vector3f(0.0f, 0.6875f, 0.0f), null, null, null);
        }
        if (entity instanceof PlayerEntity && (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            boolean main = (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) == (entity.func_184591_cq() == HandSide.RIGHT);
            boolean left = transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            ItemStack itemStack = stack = main ? entity.func_184614_ca() : entity.func_184592_cb();
            if (ItemNBTHelper.hasKey(stack, "reload")) {
                float f = 3.0f - (float)ItemNBTHelper.getInt(stack, "reload") / 20.0f;
                if ("frame".equals(groups[0])) {
                    if ((double)f < 0.35 || (double)f > 1.95) {
                        return matClose;
                    }
                    if ((double)f < 0.5) {
                        return new TransformationMatrix(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternion(0.0f, 0.0f, -2.64f * (f - 0.35f), false), null, null);
                    }
                    if ((double)f < 1.8) {
                        return matOpen;
                    }
                    return new TransformationMatrix(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternion(0.0f, 0.0f, -2.64f * (1.95f - f), false), null, null);
                }
                if ((double)f > 2.5 && (double)f < 2.9) {
                    float angle = (float)(left ? -1 : 1) * -15.70795f * (f - 2.5f);
                    return new TransformationMatrix(new Vector3f(0.0f, 0.6875f, 0.0f), new Quaternion(angle, 0.0f, 0.0f, false), null, null);
                }
            } else if ("frame".equals(groups[0]) && ((PlayerEntity)entity).field_71070_bA instanceof RevolverContainer) {
                return matOpen;
            }
        }
        return "frame".equals(groups[0]) ? matClose : matCylinder;
    }

    static {
        groups = new String[][]{{"frame"}, {"cylinder"}};
        specialRevolvers = ArrayListMultimap.create();
        specialRevolversByTag = new HashMap<String, SpecialRevolver>();
    }

    @ParametersAreNonnullByDefault
    public static enum RevolverPerk {
        COOLDOWN(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((1.0 - f) * 100.0), (l, r) -> l * r, 1.0, -0.75, -0.05),
        NOISE(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((f - 1.0) * 100.0), (l, r) -> l * r, 1.0, -0.9, -0.1),
        LUCK(f -> f < 0.0, f -> Utils.NUMBERFORMAT_PREFIXED.format(f * 100.0), (l, r) -> l + r, 0.0, 3.0, 0.5);

        private final DoublePredicate isBadValue;
        private final Function<Double, String> valueFormatter;
        private final DoubleBinaryOperator valueConcat;
        private final double generate_median;
        private final double generate_deviation;
        private final double generate_luckScale;

        private RevolverPerk(DoublePredicate isBadValue, Function<Double, String> valueFormatter, DoubleBinaryOperator valueConcat, double generate_median, double generate_deviation, double generate_luckScale) {
            this.isBadValue = isBadValue;
            this.valueFormatter = valueFormatter;
            this.valueConcat = valueConcat;
            this.generate_median = generate_median;
            this.generate_deviation = generate_deviation;
            this.generate_luckScale = generate_luckScale;
        }

        public String getNBTKey() {
            return this.name().toLowerCase(Locale.US);
        }

        public ITextComponent getDisplayString(double value) {
            String key = "desc.immersiveengineering.info.revolver.perk." + this.toString();
            return new TranslationTextComponent(key, new Object[]{this.valueFormatter.apply(value)}).func_240699_a_(this.isBadValue.test(value) ? TextFormatting.RED : TextFormatting.BLUE);
        }

        public static ITextComponent getFormattedName(ITextComponent name, CompoundNBT perksTag) {
            double averageTier = 0.0;
            for (String key : perksTag.func_150296_c()) {
                RevolverPerk perk = RevolverPerk.get(key);
                double value = perksTag.func_74769_h(key);
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
                int iTier = (int)MathHelper.func_151237_a((double)(dTier < 0.0 ? Math.floor(dTier) : Math.ceil(dTier)), (double)-3.0, (double)3.0);
                String translate = "desc.immersiveengineering.info.revolver.perk." + perk.name().toLowerCase(Locale.US) + ".tier" + iTier;
                name = new TranslationTextComponent(translate).func_230529_a_(name);
            }
            int rarityTier = (int)Math.ceil(MathHelper.func_151237_a((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
            Rarity rarity = rarityTier == 5 ? Lib.RARITY_MASTERWORK : (rarityTier == 4 ? Rarity.EPIC : (rarityTier == 3 ? Rarity.RARE : (rarityTier == 2 ? Rarity.UNCOMMON : Rarity.COMMON)));
            return name.func_230532_e_().func_240699_a_(rarity.field_77937_e);
        }

        public static int calculateTier(CompoundNBT perksTag) {
            double averageTier = 0.0;
            for (String key : perksTag.func_150296_c()) {
                RevolverPerk perk = RevolverPerk.get(key);
                double value = perksTag.func_74769_h(key);
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
            }
            return (int)Math.ceil(MathHelper.func_151237_a((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
        }

        public double concat(double left, double right) {
            return this.valueConcat.applyAsDouble(left, right);
        }

        public double generateValue(Random rand, boolean isBad, float luck) {
            double d = Utils.generateLuckInfluencedDouble(this.generate_median, this.generate_deviation, luck, rand, isBad, this.generate_luckScale);
            int i = (int)(d * 100.0);
            d = (double)i / 100.0;
            return d;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static RevolverPerk get(String name) {
            try {
                return RevolverPerk.valueOf(name.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                return null;
            }
        }

        public static RevolverPerk getRandom(Random rand) {
            int i = rand.nextInt(RevolverPerk.values().length);
            return RevolverPerk.values()[i];
        }

        public static CompoundNBT generatePerkSet(Random rand, float luck) {
            RevolverPerk goodPerk = RevolverPerk.getRandom(rand);
            RevolverPerk badPerk = LUCK;
            double val = goodPerk.generateValue(rand, false, luck);
            CompoundNBT perkCompound = new CompoundNBT();
            if (goodPerk == badPerk) {
                val = (val + badPerk.generateValue(rand, true, luck)) / 2.0;
            } else {
                perkCompound.func_74780_a(badPerk.getNBTKey(), badPerk.generateValue(rand, true, luck));
            }
            perkCompound.func_74780_a(goodPerk.getNBTKey(), val);
            return perkCompound;
        }
    }

    public static class SpecialRevolver {
        public final String[] uuid;
        public final String tag;
        public final String flavour;
        public final HashMap<String, Object> baseUpgrades;
        public final String[] renderAdditions;

        public SpecialRevolver(String[] uuid, String tag, String flavour, HashMap<String, Object> baseUpgrades, String[] renderAdditions) {
            this.uuid = uuid;
            this.tag = tag;
            this.flavour = flavour;
            this.baseUpgrades = baseUpgrades;
            this.renderAdditions = renderAdditions;
        }
    }
}

