/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSkyhookSync
implements IMessage {
    private int entityID;
    private Connection connection;
    private ConnectionPoint start;
    private double linePos;
    private double speed;

    public MessageSkyhookSync(SkylineHookEntity entity) {
        this.entityID = entity.func_145782_y();
        this.connection = entity.getConnection();
        this.linePos = entity.linePos;
        this.start = entity.start;
        this.speed = entity.horizontalSpeed;
    }

    public MessageSkyhookSync(PacketBuffer buf) {
        this.entityID = buf.readInt();
        CompoundNBT tag = buf.func_150793_b();
        this.connection = new Connection(tag);
        this.linePos = buf.readDouble();
        this.speed = buf.readDouble();
        this.start = new ConnectionPoint(buf.func_150793_b());
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.func_150786_a(this.connection.toNBT());
        buf.writeDouble(this.linePos);
        buf.writeDouble(this.speed);
        buf.func_150786_a(this.start.createTag());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity ent;
            World world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (ent = world.func_73045_a(this.entityID)) instanceof SkylineHookEntity) {
                this.connection.generateCatenaryData(world);
                ((SkylineHookEntity)ent).setConnectionAndPos(this.connection, this.start, this.linePos, this.speed);
            }
        });
    }
}

