/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.client.gui.machine.GuiAdvancedElectricMachine;
import mekanism.client.gui.machine.GuiElectricMachine;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.ParticleTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientRegistrationUtil {
    private ClientRegistrationUtil() {
    }

    public static <T extends Entity> void registerEntityRenderingHandler(EntityTypeRegistryObject<T> entityTypeRO, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityTypeRO.getEntityType(), renderFactory);
    }

    public static synchronized <T extends TileEntity> void bindTileEntityRenderer(TileEntityTypeRegistryObject<T> tileTypeRO, Function<TileEntityRendererDispatcher, TileEntityRenderer<? super T>> renderFactory) {
        ClientRegistry.bindTileEntityRenderer(tileTypeRO.getTileEntityType(), renderFactory);
    }

    @SafeVarargs
    public static synchronized <T extends TileEntity> void bindTileEntityRenderer(Function<TileEntityRendererDispatcher, TileEntityRenderer<T>> rendererFactory, TileEntityTypeRegistryObject<? extends T> ... tileEntityTypeROs) {
        TileEntityRenderer<TileEntityRendererDispatcher> renderer = rendererFactory.apply(TileEntityRendererDispatcher.field_147556_a);
        for (TileEntityTypeRegistryObject<T> tileEntityTypeRegistryObject : tileEntityTypeROs) {
            ClientRegistry.bindTileEntityRenderer(tileEntityTypeRegistryObject.getTileEntityType(), (T constant) -> renderer);
        }
    }

    public static <T extends IParticleData> void registerParticleFactory(ParticleTypeRegistryObject<T, ?> particleTypeRO, ParticleManager.IParticleMetaFactory<T> factory) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a(particleTypeRO.getParticleType(), factory);
    }

    public static <C extends Container, U extends Screen> void registerScreen(ContainerTypeRegistryObject<C> type, ScreenManager.IScreenFactory<C, U> factory) {
        ScreenManager.func_216911_a(type.getContainerType(), factory);
    }

    public static <TILE extends TileEntityElectricMachine, C extends MekanismTileContainer<TILE>> void registerElectricScreen(ContainerTypeRegistryObject<C> type) {
        ClientRegistrationUtil.registerScreen(type, new ScreenManager.IScreenFactory<C, GuiElectricMachine<TILE, C>>(){

            @Nonnull
            public GuiElectricMachine<TILE, C> create(@Nonnull C container, @Nonnull PlayerInventory inv, @Nonnull ITextComponent title) {
                return new GuiElectricMachine(container, inv, title);
            }
        });
    }

    public static <TILE extends TileEntityAdvancedElectricMachine, C extends MekanismTileContainer<TILE>> void registerAdvancedElectricScreen(ContainerTypeRegistryObject<C> type) {
        ClientRegistrationUtil.registerScreen(type, new ScreenManager.IScreenFactory<C, GuiAdvancedElectricMachine<TILE, C>>(){

            @Nonnull
            public GuiAdvancedElectricMachine<TILE, C> create(@Nonnull C container, @Nonnull PlayerInventory inv, @Nonnull ITextComponent title) {
                return new GuiAdvancedElectricMachine(container, inv, title);
            }
        });
    }

    public static void setPropertyOverride(IItemProvider itemProvider, ResourceLocation override, IItemPropertyGetter propertyGetter) {
        ItemModelsProperties.func_239418_a_((Item)itemProvider.getItem(), (ResourceLocation)override, (IItemPropertyGetter)propertyGetter);
    }

    public static void registerItemColorHandler(ItemColors colors, IItemColor itemColor, IItemProvider ... items) {
        for (IItemProvider itemProvider : items) {
            colors.func_199877_a(itemColor, new net.minecraft.util.IItemProvider[]{itemProvider.getItem()});
        }
    }

    public static void registerBlockColorHandler(BlockColors blockColors, IBlockColor blockColor, IBlockProvider ... blocks) {
        for (IBlockProvider blockProvider : blocks) {
            blockColors.func_186722_a(blockColor, new Block[]{blockProvider.getBlock()});
        }
    }

    public static void registerBlockColorHandler(BlockColors blockColors, ItemColors itemColors, IBlockColor blockColor, IItemColor itemColor, IBlockProvider ... blocks) {
        for (IBlockProvider blockProvider : blocks) {
            blockColors.func_186722_a(blockColor, new Block[]{blockProvider.getBlock()});
            itemColors.func_199877_a(itemColor, new net.minecraft.util.IItemProvider[]{blockProvider.getItem()});
        }
    }

    public static void registerIColoredBlockHandler(BlockColors blockColors, ItemColors itemColors, IBlockProvider ... blocks) {
        ClientRegistrationUtil.registerBlockColorHandler(blockColors, itemColors, (state, world, pos, tintIndex) -> {
            Block block = state.func_177230_c();
            if (block instanceof IColoredBlock) {
                return MekanismRenderer.getColorARGB(((IColoredBlock)block).getColor(), 1.0f);
            }
            return -1;
        }, (stack, tintIndex) -> {
            Block block;
            Item item = stack.func_77973_b();
            if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof IColoredBlock) {
                return MekanismRenderer.getColorARGB(((IColoredBlock)block).getColor(), 1.0f);
            }
            return -1;
        }, blocks);
    }

    public static void setRenderLayer(RenderType type, IBlockProvider ... blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            RenderTypeLookup.setRenderLayer((Block)blockProvider.getBlock(), (RenderType)type);
        }
    }

    public static synchronized void setRenderLayer(Predicate<RenderType> predicate, IBlockProvider ... blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            RenderTypeLookup.setRenderLayer((Block)blockProvider.getBlock(), predicate);
        }
    }

    public static void setRenderLayer(RenderType type, FluidRegistryObject<?, ?, ?, ?> ... fluidROs) {
        for (FluidRegistryObject<?, ?, ?, ?> fluidRO : fluidROs) {
            RenderTypeLookup.setRenderLayer(fluidRO.getStillFluid(), (RenderType)type);
            RenderTypeLookup.setRenderLayer(fluidRO.getFlowingFluid(), (RenderType)type);
        }
    }

    public static synchronized void setRenderLayer(Predicate<RenderType> predicate, FluidRegistryObject<?, ?, ?, ?> ... fluidROs) {
        for (FluidRegistryObject<?, ?, ?, ?> fluidRO : fluidROs) {
            RenderTypeLookup.setRenderLayer(fluidRO.getStillFluid(), predicate);
            RenderTypeLookup.setRenderLayer(fluidRO.getFlowingFluid(), predicate);
        }
    }
}

