/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRelativeElement;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiElement
extends Widget
implements IFancyFontRenderer {
    private static final int BUTTON_TEX_X = 200;
    private static final int BUTTON_TEX_Y = 60;
    public static final Minecraft minecraft = Minecraft.func_71410_x();
    protected ButtonBackground buttonBackground = ButtonBackground.NONE;
    protected final List<GuiElement> children = new ArrayList<GuiElement>();
    protected final IGuiWrapper guiObj;
    protected boolean playClickSound;
    public boolean isOverlay;

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height, ITextComponent text) {
        super(x, y, width, height, text);
        this.guiObj = gui;
    }

    protected void addChild(GuiElement element) {
        this.children.add(element);
        if (this.isOverlay) {
            element.isOverlay = true;
        }
    }

    public IGuiWrapper getGuiObj() {
        return this.guiObj;
    }

    public List<GuiElement> children() {
        return this.children;
    }

    public void tick() {
        this.children.forEach(GuiElement::tick);
    }

    public void resize(int prevLeft, int prevTop, int left, int top) {
        this.field_230690_l_ = this.field_230690_l_ - prevLeft + left;
        this.field_230691_m_ = this.field_230691_m_ - prevTop + top;
        this.children.forEach(child -> child.resize(prevLeft, prevTop, left, top));
    }

    public void func_230996_d_(boolean focused) {
        super.func_230996_d_(focused);
    }

    public void move(int changeX, int changeY) {
        this.field_230690_l_ += changeX;
        this.field_230691_m_ += changeY;
        if (this instanceof GuiRelativeElement) {
            ((GuiRelativeElement)this).relativeX += changeX;
            ((GuiRelativeElement)this).relativeY += changeY;
        }
        this.children.forEach(child -> child.move(changeX, changeY));
    }

    public void onWindowClose() {
        this.children.forEach(GuiElement::onWindowClose);
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    protected IHoverable getOnHover(ILangEntry translationHelper) {
        return this.getOnHover(() -> translationHelper.translate(new Object[0]));
    }

    protected IHoverable getOnHover(Supplier<ITextComponent> componentSupplier) {
        return (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)componentSupplier.get(), xAxis, yAxis);
    }

    public boolean hasPersistentData() {
        return this.children.stream().anyMatch(GuiElement::hasPersistentData);
    }

    public void syncFrom(GuiElement element) {
        int numChildren = this.children.size();
        if (numChildren > 0) {
            for (int i = 0; i < element.children.size(); ++i) {
                GuiElement child;
                GuiElement prevChild = element.children.get(i);
                if (!prevChild.hasPersistentData() || i >= numChildren || (child = this.children.get(i)).getClass() != prevChild.getClass()) continue;
                child.syncFrom(prevChild);
            }
        }
    }

    public final void onRenderForeground(MatrixStack matrix, int mouseX, int mouseY, int zOffset, int totalOffset) {
        if (this.field_230694_p_) {
            matrix.func_227861_a_(0.0, 0.0, (double)zOffset);
            GuiMekanism.maxZOffset = Math.max(totalOffset, GuiMekanism.maxZOffset);
            matrix.func_227861_a_((double)(-this.guiObj.getLeft()), (double)(-this.guiObj.getTop()), 0.0);
            this.renderBackgroundOverlay(matrix, mouseX, mouseY);
            this.children.forEach(child -> child.func_230430_a_(matrix, mouseX, mouseY, 0.0f));
            this.children.forEach(child -> child.onDrawBackground(matrix, mouseX, mouseY, 0.0f));
            matrix.func_227861_a_((double)this.guiObj.getLeft(), (double)this.guiObj.getTop(), 0.0);
            this.renderForeground(matrix, mouseX, mouseY);
            this.children.forEach(child -> child.onRenderForeground(matrix, mouseX, mouseY, 50, totalOffset + 50));
        }
    }

    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        this.drawButtonText(matrix);
    }

    public void renderBackgroundOverlay(MatrixStack matrix, int mouseX, int mouseY) {
    }

    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.children.stream().filter(child -> child.func_231047_b_(mouseX + this.guiObj.getLeft(), mouseY + this.guiObj.getTop())).forEach(child -> child.func_230443_a_(matrix, mouseX, mouseY));
    }

    public void displayTooltip(MatrixStack matrix, ITextComponent component, int xAxis, int yAxis) {
        this.guiObj.displayTooltip(matrix, component, xAxis, yAxis);
    }

    public void displayTooltips(MatrixStack matrix, List<ITextComponent> list, int xAxis, int yAxis) {
        this.guiObj.displayTooltips(matrix, list, xAxis, yAxis);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231044_a_(mouseX, mouseY, button)) || super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231046_a_(keyCode, scanCode, modifiers)) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char c, int keyCode) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231042_a_(c, keyCode)) || super.func_231042_a_(c, keyCode);
    }

    public void func_230983_a_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        this.children.forEach(element -> element.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld));
        super.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld);
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        this.children.forEach(element -> element.func_231000_a__(mouseX, mouseY));
        super.func_231000_a__(mouseX, mouseY);
    }

    @Override
    public FontRenderer getFont() {
        return this.guiObj.getFont();
    }

    @Override
    public int getXSize() {
        return this.field_230688_j_;
    }

    public void setButtonBackground(ButtonBackground buttonBackground) {
        this.buttonBackground = buttonBackground;
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        return this.func_231047_b_(mouseX, mouseY);
    }

    protected int getButtonX() {
        return this.field_230690_l_;
    }

    protected int getButtonY() {
        return this.field_230691_m_;
    }

    protected int getButtonWidth() {
        return this.field_230688_j_;
    }

    protected int getButtonHeight() {
        return this.field_230689_k_;
    }

    protected boolean resetColorBeforeRender() {
        return true;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return super.func_231047_b_(mouseX, mouseY) || this.children.stream().anyMatch(child -> child.func_231047_b_(mouseX, mouseY));
    }

    public final boolean isMouseOverCheckWindows(double mouseX, double mouseY) {
        GuiWindow window;
        boolean isHovering = this.func_231047_b_(mouseX, mouseY);
        if (isHovering && (window = this.guiObj.getWindowHovering(mouseX, mouseY)) != null && !window.children().contains(this)) {
            isHovering = false;
        }
        return isHovering;
    }

    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonBackground != ButtonBackground.NONE) {
            this.drawButton(matrix, mouseX, mouseY);
        }
    }

    public void onDrawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.drawBackground(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public void func_230431_b_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtonText(MatrixStack matrix) {
        ITextComponent message = this.func_230458_i_();
        if (!message.getString().isEmpty()) {
            int halfWidthLeft = this.field_230688_j_ / 2;
            GuiElement.func_238472_a_((MatrixStack)matrix, (FontRenderer)this.getFont(), (ITextComponent)message, (int)(this.field_230690_l_ - this.guiObj.getLeft() + halfWidthLeft), (int)(this.field_230691_m_ - this.guiObj.getTop() + (this.field_230689_k_ - 8) / 2), (int)(this.getFGColor() | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
        }
    }

    protected void drawButton(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.resetColorBeforeRender()) {
            MekanismRenderer.resetColor();
        }
        MekanismRenderer.bindTexture(this.buttonBackground.getTexture());
        int i = this.func_230989_a_(this.isMouseOverCheckWindows(mouseX, mouseY));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int width = this.getButtonWidth();
        int height = this.getButtonHeight();
        int halfWidthLeft = width / 2;
        int halfWidthRight = width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = height / 2;
        int halfHeightBottom = height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        int position = i * 20;
        int x = this.getButtonX();
        int y = this.getButtonY();
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)position, (int)halfWidthLeft, (int)halfHeightTop, (int)200, (int)60);
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)x, (int)(y + halfHeightTop), (float)0.0f, (float)(position + 20 - halfHeightBottom), (int)halfWidthLeft, (int)halfHeightBottom, (int)200, (int)60);
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)(x + halfWidthLeft), (int)y, (float)(200 - halfWidthRight), (float)position, (int)halfWidthRight, (int)halfHeightTop, (int)200, (int)60);
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)(x + halfWidthLeft), (int)(y + halfHeightTop), (float)(200 - halfWidthRight), (float)(position + 20 - halfHeightBottom), (int)halfWidthRight, (int)halfHeightBottom, (int)200, (int)60);
        this.func_230441_a_(matrix, minecraft, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void renderExtendedTexture(MatrixStack matrix, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderExtendedTexture(matrix, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
    }

    protected void renderBackgroundTexture(MatrixStack matrix, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderBackgroundTexture(matrix, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 256, 256);
    }

    public void func_230988_a_(@Nonnull SoundHandler soundHandler) {
        if (this.playClickSound) {
            super.func_230988_a_(soundHandler);
        }
    }

    protected void playClickSound() {
        super.func_230988_a_(minecraft.func_147118_V());
    }

    protected void drawTiledSprite(MatrixStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, GuiUtils.TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(matrix, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, this.func_230927_p_(), tilingDirection);
    }

    @FunctionalInterface
    public static interface IClickable {
        public void onClick(GuiElement var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface IHoverable {
        public void onHover(GuiElement var1, MatrixStack var2, int var3, int var4);
    }

    public static enum ButtonBackground {
        DEFAULT(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button.png")),
        DIGITAL(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button_digital.png")),
        NONE(null);

        private final ResourceLocation texture;

        private ButtonBackground(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

