/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.filter.GuiTextFilter;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiTagFilter<FILTER extends ITagFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiTextFilter<FILTER, TILE> {
    protected GuiTagFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, FILTER origFilter) {
        super(gui, x, y, width, height, (ITextComponent)MekanismLang.TAG_FILTER.translate(new Object[0]), tile, origFilter);
    }

    @Override
    protected List<ITextComponent> getScreenText() {
        List<ITextComponent> list = super.getScreenText();
        list.add((ITextComponent)MekanismLang.TAG_FILTER_TAG.translate(((ITagFilter)this.filter).getTagName()));
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.TAG_FILTER_NO_TAG;
    }

    @Override
    protected void setText() {
        String name = this.text.getText();
        if (name.isEmpty()) {
            this.filterSaveFailed(this.getNoFilterSaveError());
        } else if (name.equals(((ITagFilter)this.filter).getTagName())) {
            this.filterSaveFailed(MekanismLang.TAG_FILTER_SAME_TAG);
        } else {
            ((ITagFilter)this.filter).setTagName(name);
            this.slotDisplay.updateStackList();
            this.text.setText("");
        }
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRenderStacks() {
        if (((ITagFilter)this.filter).hasFilter()) {
            return TagCache.getItemTagStacks(((ITagFilter)this.filter).getTagName());
        }
        return Collections.emptyList();
    }
}

