/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.text;

import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.Arrays;
import mekanism.api.functions.CharPredicate;

public class InputValidator {
    public static final CharPredicate ALL = c -> true;
    public static final CharPredicate DIGIT = Character::isDigit;
    public static final CharPredicate LETTER = Character::isLetter;
    public static final CharPredicate DECIMAL = DIGIT.or(InputValidator.from('.'));
    public static final CharPredicate SCI_NOTATION = DECIMAL.or(InputValidator.from('E'));
    public static final CharPredicate FILTER_CHARS = InputValidator.from('*', '-', ' ', '|', '_', '\'', ':', '/', '#', '?');
    public static final CharPredicate FREQUENCY_CHARS = InputValidator.from('-', ' ', '|', '\'', '\"', '_', '+', ':', '(', ')', '?', '!', '/', '@', '$', '`', '~', ',', '.', '#');

    private InputValidator() {
    }

    public static CharPredicate from(char character) {
        return c -> c == character;
    }

    public static CharPredicate from(char ... chars) {
        return new SetInputValidator(chars);
    }

    public static CharPredicate or(CharPredicate ... validators) {
        return c -> Arrays.stream(validators).anyMatch(v -> v.test(c));
    }

    private static class SetInputValidator
    implements CharPredicate {
        private final CharSet validSet;

        public SetInputValidator(char ... chars) {
            this.validSet = new CharOpenHashSet(chars);
        }

        @Override
        public boolean test(char c) {
            return this.validSet.contains(c);
        }
    }
}

