/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IEmptyStackProvider;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IEmptyGasProvider;
import mekanism.api.chemical.infuse.IEmptyInfusionProvider;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IEmptyPigmentProvider;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.IEmptySlurryProvider;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.ChemicalUtil;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class ChemicalStackHelper<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IIngredientHelper<STACK>,
IEmptyStackProvider<CHEMICAL, STACK> {
    protected abstract String getType();

    @Nullable
    public STACK getMatch(Iterable<STACK> ingredients, @Nonnull STACK toMatch) {
        for (ChemicalStack stack : ingredients) {
            if (!((ChemicalStack)toMatch).isTypeEqual((ChemicalStack)stack)) continue;
            return (STACK)stack;
        }
        return null;
    }

    public String getDisplayName(STACK ingredient) {
        return TextComponentUtil.build(ingredient).getString();
    }

    public String getUniqueId(STACK ingredient) {
        return this.getType().toLowerCase(Locale.ROOT) + ":" + ((ChemicalStack)ingredient).getTypeRegistryName();
    }

    public String getWildcardId(STACK ingredient) {
        return this.getUniqueId(ingredient);
    }

    public String getModId(STACK ingredient) {
        return ((ChemicalStack)ingredient).getTypeRegistryName().func_110624_b();
    }

    public String getResourceId(STACK ingredient) {
        return ((ChemicalStack)ingredient).getTypeRegistryName().func_110623_a();
    }

    public STACK copyIngredient(STACK ingredient) {
        return ChemicalUtil.copy(ingredient);
    }

    public Collection<ResourceLocation> getTags(STACK ingredient) {
        return ((Chemical)((ChemicalStack)ingredient).getType()).getTags();
    }

    public String getErrorInfo(@Nullable STACK ingredient) {
        if (ingredient == null) {
            ingredient = this.getEmptyStack();
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(GasStack.class);
        Object chemical = ((ChemicalStack)ingredient).getType();
        toStringHelper.add(this.getType(), (Object)(((Chemical)chemical).isEmptyType() ? "none" : TextComponentUtil.build(chemical).getString()));
        if (!((ChemicalStack)ingredient).isEmpty()) {
            toStringHelper.add("Amount", ((ChemicalStack)ingredient).getAmount());
        }
        return toStringHelper.toString();
    }

    @Nullable
    protected abstract MekanismRecipeType<? extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> getConversionRecipeType();

    public List<ItemStack> getStacksFor(@Nonnull CHEMICAL type, boolean displayConversions) {
        MekanismRecipeType<ItemStackToChemicalRecipe<CHEMICAL, STACK>> recipeType;
        if (((Chemical)type).isEmptyType()) {
            return Collections.emptyList();
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(ChemicalUtil.getFullChemicalTank(ChemicalTankTier.BASIC, type));
        if (displayConversions && (recipeType = this.getConversionRecipeType()) != null) {
            for (ItemStackToChemicalRecipe<CHEMICAL, STACK> recipe : recipeType.getRecipes((World)world)) {
                if (!((ChemicalStack)recipe.getOutputDefinition()).isTypeEqual(type)) continue;
                stacks.addAll(recipe.getInput().getRepresentations());
            }
        }
        return stacks;
    }

    public static class SlurryStackHelper
    extends ChemicalStackHelper<Slurry, SlurryStack>
    implements IEmptySlurryProvider {
        @Override
        protected String getType() {
            return "Slurry";
        }

        @Override
        @Nullable
        protected MekanismRecipeType<? extends ItemStackToChemicalRecipe<Slurry, SlurryStack>> getConversionRecipeType() {
            return null;
        }
    }

    public static class PigmentStackHelper
    extends ChemicalStackHelper<Pigment, PigmentStack>
    implements IEmptyPigmentProvider {
        @Override
        protected String getType() {
            return "Pigment";
        }

        @Override
        @Nullable
        protected MekanismRecipeType<? extends ItemStackToChemicalRecipe<Pigment, PigmentStack>> getConversionRecipeType() {
            return null;
        }
    }

    public static class InfusionStackHelper
    extends ChemicalStackHelper<InfuseType, InfusionStack>
    implements IEmptyInfusionProvider {
        @Override
        protected String getType() {
            return "Infuse Type";
        }

        @Override
        @Nullable
        protected MekanismRecipeType<? extends ItemStackToChemicalRecipe<InfuseType, InfusionStack>> getConversionRecipeType() {
            return MekanismRecipeType.INFUSION_CONVERSION;
        }
    }

    public static class GasStackHelper
    extends ChemicalStackHelper<Gas, GasStack>
    implements IEmptyGasProvider {
        @Override
        protected String getType() {
            return "Gas";
        }

        @Override
        @Nullable
        protected MekanismRecipeType<? extends ItemStackToChemicalRecipe<Gas, GasStack>> getConversionRecipeType() {
            return MekanismRecipeType.GAS_CONVERSION;
        }
    }
}

