/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mekanism.client.SpecialColors;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public interface IFancyFontRenderer {
    public int getXSize();

    public FontRenderer getFont();

    default public int titleTextColor() {
        return SpecialColors.TEXT_TITLE.argb();
    }

    default public int headingTextColor() {
        return SpecialColors.TEXT_HEADING.argb();
    }

    default public int subheadingTextColor() {
        return SpecialColors.TEXT_SUBHEADING.argb();
    }

    default public int screenTextColor() {
        return SpecialColors.TEXT_SCREEN.argb();
    }

    default public int drawString(MatrixStack matrix, ITextComponent component, int x, int y, int color) {
        return this.getFont().func_243248_b(matrix, component, (float)x, (float)y, color);
    }

    default public int getStringWidth(ITextComponent component) {
        return this.getFont().func_238414_a_((ITextProperties)component);
    }

    default public void drawCenteredText(MatrixStack matrix, ITextComponent component, float x, float y, int color) {
        this.drawCenteredText(matrix, component, x, 0.0f, y, color);
    }

    default public void drawCenteredText(MatrixStack matrix, ITextComponent component, float xStart, float areaWidth, float y, int color) {
        int textWidth = this.getStringWidth(component);
        float centerX = xStart + areaWidth / 2.0f - (float)textWidth / 2.0f;
        this.drawTextExact(matrix, component, centerX, y, color);
    }

    default public void drawTitleText(MatrixStack matrix, ITextComponent text, float y) {
        this.drawCenteredTextScaledBound(matrix, text, this.getXSize() - 8, y, this.titleTextColor());
    }

    default public void drawScaledCenteredText(MatrixStack matrix, ITextComponent text, float left, float y, int color, float scale) {
        int textWidth = this.getStringWidth(text);
        float centerX = left - (float)textWidth / 2.0f * scale;
        this.drawTextWithScale(matrix, text, centerX, y, color, scale);
    }

    default public void drawCenteredTextScaledBound(MatrixStack matrix, ITextComponent text, float maxLength, float y, int color) {
        float scale = Math.min(1.0f, maxLength / (float)this.getStringWidth(text));
        this.drawScaledCenteredText(matrix, text, (float)this.getXSize() / 2.0f, y, color, scale);
    }

    default public void drawTextExact(MatrixStack matrix, ITextComponent text, float x, float y, int color) {
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)y, 0.0);
        this.drawString(matrix, text, 0, 0, color);
        matrix.func_227865_b_();
    }

    default public float getNeededScale(ITextComponent text, float maxLength) {
        int length = this.getStringWidth(text);
        return (float)length <= maxLength ? 1.0f : maxLength / (float)length;
    }

    default public void drawTextScaledBound(MatrixStack matrix, String text, float x, float y, int color, float maxLength) {
        this.drawTextScaledBound(matrix, (ITextComponent)new StringTextComponent(text), x, y, color, maxLength);
    }

    default public void drawTextScaledBound(MatrixStack matrix, ITextComponent component, float x, float y, int color, float maxLength) {
        int length = this.getStringWidth(component);
        if ((float)length <= maxLength) {
            this.drawTextExact(matrix, component, x, y, color);
        } else {
            this.drawTextWithScale(matrix, component, x, y, color, maxLength / (float)length);
        }
        MekanismRenderer.resetColor();
    }

    default public void drawScaledTextScaledBound(MatrixStack matrix, ITextComponent text, float x, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawTextWithScale(matrix, text, x, y, color, scale);
    }

    default public void drawTextWithScale(MatrixStack matrix, ITextComponent text, float x, float y, int color, float scale) {
        this.prepTextScale(matrix, m -> this.drawString((MatrixStack)m, text, 0, 0, color), x, y, scale);
    }

    default public void prepTextScale(MatrixStack matrix, Consumer<MatrixStack> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)x, (double)(y + yAdd), 0.0);
        matrix.func_227862_a_(scale, scale, scale);
        runnable.accept(matrix);
        matrix.func_227865_b_();
        MekanismRenderer.resetColor();
    }

    default public void drawWrappedCenteredText(MatrixStack matrix, ITextComponent text, float x, float y, int color, float maxLength) {
        new WrappedTextRenderer(this).render(matrix, text.getString(), x, y, color, maxLength);
    }

    public static class WrappedTextRenderer {
        final IFancyFontRenderer font;
        final List<Pair<ITextComponent, Float>> linesToDraw = new ArrayList<Pair<ITextComponent, Float>>();
        StringBuilder lineBuilder = new StringBuilder();
        StringBuilder wordBuilder = new StringBuilder();
        float lineLength = 0.0f;
        float wordLength = 0.0f;
        final float SPACE_LENGTH;

        WrappedTextRenderer(IFancyFontRenderer font) {
            this.font = font;
            this.SPACE_LENGTH = font.getFont().func_78256_a(" ");
        }

        void render(MatrixStack matrix, String text, float x, float y, int color, float maxLength) {
            for (char c : text.toCharArray()) {
                if (c == ' ') {
                    this.addWord(maxLength);
                    continue;
                }
                this.wordBuilder.append(c);
                this.wordLength += (float)this.font.getFont().func_78256_a(Character.toString(c));
            }
            if (this.wordBuilder.length() > 0) {
                this.addWord(maxLength);
            }
            if (this.lineBuilder.length() > 0) {
                this.linesToDraw.add((Pair<ITextComponent, Float>)Pair.of((Object)new StringTextComponent(this.lineBuilder.toString()), (Object)Float.valueOf(this.lineLength)));
            }
            float startY = y;
            for (Pair<ITextComponent, Float> p : this.linesToDraw) {
                this.font.drawTextExact(matrix, (ITextComponent)p.getLeft(), x - ((Float)p.getRight()).floatValue() / 2.0f, startY, color);
                startY += 9.0f;
            }
        }

        void addWord(float maxLength) {
            float spacingLength;
            float f = spacingLength = this.lineBuilder.length() == 0 ? 0.0f : this.SPACE_LENGTH;
            if (this.lineLength + spacingLength + this.wordLength > maxLength) {
                this.linesToDraw.add((Pair<ITextComponent, Float>)Pair.of((Object)new StringTextComponent(this.lineBuilder.toString()), (Object)Float.valueOf(this.lineLength)));
                this.lineBuilder = new StringBuilder(this.wordBuilder);
                this.lineLength = this.wordLength;
            } else {
                if (spacingLength > 0.0f) {
                    this.lineBuilder.append(" ");
                }
                this.lineBuilder.append((CharSequence)this.wordBuilder);
                this.lineLength += spacingLength + this.wordLength;
            }
            this.wordLength = 0.0f;
            this.wordBuilder = new StringBuilder();
        }
    }
}

