/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.machine.TileEntityDigitalMiner;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MinerEnergyContainer
extends MachineEnergyContainer<TileEntityDigitalMiner> {
    private FloatingLong minerEnergyPerTick = this.getBaseEnergyPerTick();

    public static MinerEnergyContainer input(TileEntityDigitalMiner tile) {
        AttributeEnergy electricBlock = MinerEnergyContainer.validateBlock(tile);
        return new MinerEnergyContainer(electricBlock.getStorage(), electricBlock.getUsage(), tile);
    }

    private MinerEnergyContainer(FloatingLong maxEnergy, FloatingLong energyPerTick, TileEntityDigitalMiner tile) {
        super(maxEnergy, energyPerTick, notExternal, alwaysTrue, tile);
    }

    @Override
    public void setEnergyPerTick(FloatingLong energyPerTick) {
        super.setEnergyPerTick(energyPerTick);
        this.minerEnergyPerTick = energyPerTick;
    }

    @Override
    public FloatingLong getEnergyPerTick() {
        return this.minerEnergyPerTick;
    }

    @Override
    public void updateEnergyPerTick() {
        super.updateEnergyPerTick();
        this.updateMinerEnergyPerTick();
    }

    public void updateMinerEnergyPerTick() {
        this.minerEnergyPerTick = super.getEnergyPerTick();
        if (((TileEntityDigitalMiner)this.tile).getSilkTouch()) {
            this.minerEnergyPerTick = this.minerEnergyPerTick.multiply(MekanismConfig.general.minerSilkMultiplier.get());
        }
        this.minerEnergyPerTick = this.minerEnergyPerTick.multiply((1.0 + Math.max((double)(((TileEntityDigitalMiner)this.tile).getRadius() - 10) / 22.0, 0.0)) * (1.0 + Math.max((double)(((TileEntityDigitalMiner)this.tile).getMaxY() - ((TileEntityDigitalMiner)this.tile).getMinY() - 60) / 195.0, 0.0)));
    }
}

