/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import mekanism.api.Coord4D;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class RadiationCommand {
    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"radiation").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10000.0)).executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            return RadiationCommand.addRadiation(source, source.func_197036_d(), (World)source.func_197023_e(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            return RadiationCommand.addRadiation(source, Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), (World)source.func_197023_e(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            return RadiationCommand.addRadiation(source, Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), (World)DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            return RadiationCommand.getRadiationLevel(source, source.func_197036_d(), (World)source.func_197023_e());
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"location", (ArgumentType)Vec3Argument.func_197301_a()).executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            return RadiationCommand.getRadiationLevel(source, Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), (World)source.func_197023_e());
        })).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(ctx -> RadiationCommand.getRadiationLevel((CommandSource)ctx.getSource(), Vec3Argument.func_200385_b((CommandContext)ctx, (String)"location"), (World)DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dimension"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"heal").executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            source.func_197035_h().getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> c.set(0.0));
            source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_CLEAR.translateColored(EnumColor.GRAY, new Object[0]), true);
            return 0;
        })).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            for (PlayerEntity player : EntityArgument.func_197090_e((CommandContext)ctx, (String)"targets")) {
                player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> c.set(0.0));
                source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_CLEAR_PLAYER.translateColored(EnumColor.GRAY, EnumColor.INDIGO, player.func_145748_c_()), true);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"removeAll").executes(ctx -> {
            Mekanism.radiationManager.clearSources();
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_REMOVE_ALL.translateColored(EnumColor.GRAY, new Object[0]), true);
            return 0;
        }));
    }

    private static int addRadiation(CommandSource source, ILocationArgument location, World world, double magnitude) {
        return RadiationCommand.addRadiation(source, location.func_197281_a(source), world, magnitude);
    }

    private static int addRadiation(CommandSource source, Vector3d pos, World world, double magnitude) {
        Coord4D location = new Coord4D(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (RegistryKey<World>)world.func_234923_W_());
        Mekanism.radiationManager.radiate(location, magnitude);
        source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_ADD.translateColored(EnumColor.GRAY, RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3), EnumColor.INDIGO, RadiationCommand.getPosition(location.getPos()), EnumColor.INDIGO, location.dimension.func_240901_a_()), true);
        return 0;
    }

    private static int getRadiationLevel(CommandSource source, ILocationArgument location, World world) {
        return RadiationCommand.getRadiationLevel(source, location.func_197281_a(source), world);
    }

    private static int getRadiationLevel(CommandSource source, Vector3d pos, World world) {
        Coord4D location = new Coord4D(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (RegistryKey<World>)world.func_234923_W_());
        double magnitude = Mekanism.radiationManager.getRadiationLevel(location);
        source.func_197030_a((ITextComponent)MekanismLang.COMMAND_RADIATION_GET.translateColored(EnumColor.GRAY, EnumColor.INDIGO, RadiationCommand.getPosition(location.getPos()), EnumColor.INDIGO, location.dimension.func_240901_a_(), RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3)), true);
        return 0;
    }

    private static ITextComponent getPosition(BlockPos pos) {
        return MekanismLang.GENERIC_BLOCK_POS.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

