/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import java.util.EnumMap;
import java.util.Map;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.resource.OreType;
import mekanism.common.util.EnumUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class WorldConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedBooleanValue enableRegeneration;
    public final CachedIntValue userGenVersion;
    public final Map<OreType, OreConfig> ores = new EnumMap<OreType, OreConfig>(OreType.class);
    public final SaltConfig salt;

    WorldConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("World generation settings for Mekanism. This config is synced from server to client").push("world_generation");
        this.enableRegeneration = CachedBooleanValue.wrap(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Allows chunks to retrogen Mekanism ore blocks.").define("enableRegeneration", false));
        this.userGenVersion = CachedIntValue.wrap(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Change this value to cause Mekanism to regen its ore in all loaded chunks.").defineInRange("userWorldGenVersion", 0, 0, Integer.MAX_VALUE));
        for (OreType ore : EnumUtils.ORE_TYPES) {
            this.ores.put(ore, new OreConfig(this, builder, ore.getResource().getRegistrySuffix(), true, ore.getPerChunk(), ore.getMaxVeinSize(), ore.getBottomOffset(), ore.getTopOffset(), ore.getMaxHeight()));
        }
        this.salt = new SaltConfig(this, builder, true, 2, 2, 3, 1);
        builder.pop();
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "world";
    }

    @Override
    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    @Override
    public boolean addToContainer() {
        return false;
    }

    public static class SaltConfig {
        public final CachedBooleanValue shouldGenerate;
        public final CachedIntValue perChunk;
        public final CachedIntValue baseRadius;
        public final CachedIntValue spread;
        public final CachedIntValue ySize;

        private SaltConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, boolean shouldGenerate, int perChunk, int baseRadius, int spread, int ySize) {
            builder.comment("Generation Settings for salt.").push("salt");
            this.shouldGenerate = CachedBooleanValue.wrap(config, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Determines if salt should be added to world generation.").define("shouldGenerate", shouldGenerate));
            this.perChunk = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Chance that salt generates in a chunk.").defineInRange("perChunk", perChunk, 1, 128));
            this.baseRadius = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Base radius of a vein of salt.").defineInRange("baseRadius", baseRadius, 1, 4));
            this.spread = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Extended variability (spread) for the radius in a vein of salt.").defineInRange("spread", spread, 1, 4));
            this.ySize = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Number of blocks to extend up and down when placing a vein of salt.").defineInRange("ySize", ySize, 0, 127));
            builder.pop();
        }
    }

    public static class OreConfig {
        public final CachedBooleanValue shouldGenerate;
        public final CachedIntValue perChunk;
        public final CachedIntValue maxVeinSize;
        public final CachedIntValue bottomOffset;
        public final CachedIntValue topOffset;
        public final CachedIntValue maxHeight;

        private OreConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, String ore, boolean shouldGenerate, int perChunk, int maxVeinSize, int bottomOffset, int topOffset, int maxHeight) {
            builder.comment("Generation Settings for " + ore + " ore.").push(ore);
            this.shouldGenerate = CachedBooleanValue.wrap(config, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Determines if " + ore + " ore should be added to world generation.").define("shouldGenerate", shouldGenerate));
            this.perChunk = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Chance that " + ore + " generates in a chunk.").defineInRange("perChunk", perChunk, 1, 128));
            this.maxVeinSize = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Maximum number of blocks in a vein of " + ore + ".").defineInRange("maxVeinSize", maxVeinSize, 1, 512));
            this.maxHeight = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Maximum height (exclusive) that veins of " + ore + " can spawn. Height is calculated by: random.nextInt(maxHeight - topOffset) + bottomOffset").defineInRange("maxHeight", maxHeight, 1, 256));
            this.topOffset = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Top offset for calculating height that veins of " + ore + " can spawn. Height is calculated by: random.nextInt(maxHeight - topOffset) + bottomOffset").define("topOffset", (Object)topOffset, value -> {
                if (value instanceof Integer) {
                    int val = (Integer)value;
                    return val >= 0 && val < this.maxHeight.get();
                }
                return false;
            }));
            this.bottomOffset = CachedIntValue.wrap(config, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("Bottom offset for calculating height that veins of " + ore + " can spawn. Height is calculated by: random.nextInt(maxHeight - topOffset) + bottomOffset").define("bottomOffset", (Object)bottomOffset, value -> {
                if (value instanceof Integer) {
                    int val = (Integer)value;
                    return val >= 0 && val <= 256 - this.maxHeight.get() + this.topOffset.get();
                }
                return false;
            }));
            builder.pop();
        }
    }
}

