/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.matrix;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class MatrixValidator
extends CuboidStructureValidator<MatrixMultiblockData> {
    private final List<TileEntityInductionCell> cells = new ArrayList<TileEntityInductionCell>();
    private final List<TileEntityInductionProvider> providers = new ArrayList<TileEntityInductionProvider>();

    @Override
    protected FormationProtocol.CasingType getCasingType(BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        if (BlockType.is(block, MekanismBlockTypes.INDUCTION_CASING)) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is(block, MekanismBlockTypes.INDUCTION_PORT)) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    @Override
    public boolean validateInner(BlockState state, Long2ObjectMap<IChunk> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        if (BlockType.is(state.func_177230_c(), MekanismBlockTypes.BASIC_INDUCTION_CELL, MekanismBlockTypes.ADVANCED_INDUCTION_CELL, MekanismBlockTypes.ELITE_INDUCTION_CELL, MekanismBlockTypes.ULTIMATE_INDUCTION_CELL, MekanismBlockTypes.BASIC_INDUCTION_PROVIDER, MekanismBlockTypes.ADVANCED_INDUCTION_PROVIDER, MekanismBlockTypes.ELITE_INDUCTION_PROVIDER, MekanismBlockTypes.ULTIMATE_INDUCTION_PROVIDER)) {
            TileEntity tile = WorldUtils.getTileEntity((IWorld)this.world, chunkMap, pos);
            if (tile instanceof TileEntityInductionCell) {
                this.cells.add((TileEntityInductionCell)tile);
                return true;
            }
            if (tile instanceof TileEntityInductionProvider) {
                this.providers.add((TileEntityInductionProvider)tile);
                return true;
            }
        }
        return false;
    }

    @Override
    public FormationProtocol.FormationResult postcheck(MatrixMultiblockData structure, Set<BlockPos> innerNodes, Long2ObjectMap<IChunk> chunkMap) {
        this.cells.forEach(structure::addCell);
        this.providers.forEach(structure::addProvider);
        return FormationProtocol.FormationResult.SUCCESS;
    }
}

